/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.omap.SectionOffset;

public class PdbInternalRva {
    Long address;

    public PdbInternalRva(Long address) {
        this.address = address;
    }

    public Rva toRva(AddressMap translator) {
        if (translator.originalToTransformed != null) {
            return new Rva(translator.originalToTransformed.lookup(this.address));
        }
        return new Rva(this.address);
    }

    public SectionOffset toSectionOffset(AddressMap translator) {
        return this.toRva(translator).toSectionOffset(translator);
    }

    public PdbInternalSectionOffset toInternalOffset(AddressMap translator) {
        SectionOffset so = AddressMap.getSectionOffset(translator.originalSections, this.address);
        return new PdbInternalSectionOffset(so.getOffset(), so.getSection());
    }

    public Long getAddress() {
        return this.address;
    }

    public void setAddress(Long address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdbInternalRva)) {
            return false;
        }
        PdbInternalRva other = (PdbInternalRva)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$address = this.getAddress();
        Long other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdbInternalRva;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "PdbInternalRva(address=" + this.getAddress() + ")";
    }
}

