/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.OMAPRecord;
import com.uqm.crashsight.symtabtool.pdb.omap.RangeIter;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Range;

public class OMAPTable {
    List<OMAPRecord> records;

    public static OMAPTable parse(ParseBuffer stream) {
        OMAPTable table = new OMAPTable();
        stream.align(8L);
        assert (stream.remaining() % 8L == 0L);
        ArrayList<OMAPRecord> records = new ArrayList<OMAPRecord>((int)(stream.remaining() / 8L));
        while (!stream.isEmpty()) {
            records.add(OMAPRecord.parse(stream));
        }
        table.records = records;
        return table;
    }

    public SearchResult binarySearchByKey(List<OMAPRecord> records, long sourceAddress) {
        SearchResult result = new SearchResult(-1, false);
        int min = 0;
        int max = records.size() - 1;
        int mid = 0;
        while (min < max) {
            mid = (min + max) / 2;
            OMAPRecord record = records.get(mid);
            if (record.sourceAddress == sourceAddress) {
                result.founded = true;
                break;
            }
            if (record.sourceAddress > sourceAddress) {
                max = mid;
                continue;
            }
            min = mid;
        }
        result.index = mid;
        return result;
    }

    public Long lookup(long sourceAddress) {
        int index;
        List<OMAPRecord> records = this.getRecords();
        OMAPRecord record = records.get(index = this.binarySearchByKey(records, (long)sourceAddress).index);
        if (record.getTargetAddress() == 0L) {
            return null;
        }
        return record.translate(sourceAddress);
    }

    public RangeIter lookupRange(Range<Long> range) {
        List<OMAPRecord> next;
        OMAPRecord record;
        long start = range.getMinimum();
        long end = range.getMaximum();
        if (end <= start) {
            return RangeIter.empty();
        }
        List<OMAPRecord> records = this.getRecords();
        SearchResult search = this.binarySearchByKey(records, start);
        if (search.founded) {
            record = records.get(search.index);
            next = records.subList(search.index + 1, records.size());
        } else if (search.index == 0) {
            record = OMAPRecord.empty();
            next = records;
        } else {
            record = records.get(search.index - 1);
            next = records.subList(search.index, records.size());
        }
        return new RangeIter(next.iterator(), record, start, end);
    }

    public List<OMAPRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<OMAPRecord> records) {
        this.records = records;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OMAPTable)) {
            return false;
        }
        OMAPTable other = (OMAPTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<OMAPRecord> this$records = this.getRecords();
        List<OMAPRecord> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OMAPTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OMAPRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "OMAPTable(records=" + this.getRecords() + ")";
    }

    public static class SearchResult {
        int index;
        boolean founded;

        public SearchResult(int index, boolean founded) {
            this.index = index;
            this.founded = founded;
        }
    }
}

