/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.OMAPTable;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRvaRangeIter;
import com.uqm.crashsight.symtabtool.pdb.omap.RangeIter;
import com.uqm.crashsight.symtabtool.pdb.omap.RvaRangeIter;
import com.uqm.crashsight.symtabtool.pdb.omap.SectionOffset;
import com.uqm.crashsight.symtabtool.pdb.pe.ImageSectionHeader;
import java.util.List;
import org.apache.commons.lang3.Range;

public class AddressMap {
    List<ImageSectionHeader> originalSections;
    List<ImageSectionHeader> transformedSections;
    OMAPTable transformedToOriginal;
    OMAPTable originalToTransformed;

    public AddressMap(List<ImageSectionHeader> originalSections, List<ImageSectionHeader> transformedSections, OMAPTable transformedToOriginal, OMAPTable originalToTransformed) {
        this.originalSections = originalSections;
        this.transformedSections = transformedSections;
        this.transformedToOriginal = transformedToOriginal;
        this.originalToTransformed = originalToTransformed;
    }

    public RvaRangeIter rvaRanges(Range<Long> range) {
        if (this.originalToTransformed != null) {
            return new RvaRangeIter(this.originalToTransformed.lookupRange(range));
        }
        return new RvaRangeIter(RangeIter.identity(range));
    }

    public PdbInternalRvaRangeIter internalRvaRanges(Range<Long> range) {
        if (this.transformedToOriginal != null) {
            return new PdbInternalRvaRangeIter(this.transformedToOriginal.lookupRange(range));
        }
        return new PdbInternalRvaRangeIter(RangeIter.identity(range));
    }

    public static SectionOffset getSectionOffset(List<ImageSectionHeader> sections, long address) {
        int i;
        ImageSectionHeader s = null;
        for (i = 0; i < sections.size() && ((s = sections.get(i)).getVirtualAddress() > address || address >= s.getVirtualAddress() + s.getSizeOfRawData()); ++i) {
        }
        assert (s != null);
        return new SectionOffset(address - s.getVirtualAddress(), i + 1);
    }

    public static Long getVirtualAddress(List<ImageSectionHeader> sections, int section, long offset) {
        if (--section < 0 || section >= sections.size()) {
            return null;
        }
        ImageSectionHeader s = sections.get(section);
        return s.getVirtualAddress() + offset;
    }

    public List<ImageSectionHeader> getOriginalSections() {
        return this.originalSections;
    }

    public List<ImageSectionHeader> getTransformedSections() {
        return this.transformedSections;
    }

    public OMAPTable getTransformedToOriginal() {
        return this.transformedToOriginal;
    }

    public OMAPTable getOriginalToTransformed() {
        return this.originalToTransformed;
    }

    public void setOriginalSections(List<ImageSectionHeader> originalSections) {
        this.originalSections = originalSections;
    }

    public void setTransformedSections(List<ImageSectionHeader> transformedSections) {
        this.transformedSections = transformedSections;
    }

    public void setTransformedToOriginal(OMAPTable transformedToOriginal) {
        this.transformedToOriginal = transformedToOriginal;
    }

    public void setOriginalToTransformed(OMAPTable originalToTransformed) {
        this.originalToTransformed = originalToTransformed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressMap)) {
            return false;
        }
        AddressMap other = (AddressMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ImageSectionHeader> this$originalSections = this.getOriginalSections();
        List<ImageSectionHeader> other$originalSections = other.getOriginalSections();
        if (this$originalSections == null ? other$originalSections != null : !((Object)this$originalSections).equals(other$originalSections)) {
            return false;
        }
        List<ImageSectionHeader> this$transformedSections = this.getTransformedSections();
        List<ImageSectionHeader> other$transformedSections = other.getTransformedSections();
        if (this$transformedSections == null ? other$transformedSections != null : !((Object)this$transformedSections).equals(other$transformedSections)) {
            return false;
        }
        OMAPTable this$transformedToOriginal = this.getTransformedToOriginal();
        OMAPTable other$transformedToOriginal = other.getTransformedToOriginal();
        if (this$transformedToOriginal == null ? other$transformedToOriginal != null : !((Object)this$transformedToOriginal).equals(other$transformedToOriginal)) {
            return false;
        }
        OMAPTable this$originalToTransformed = this.getOriginalToTransformed();
        OMAPTable other$originalToTransformed = other.getOriginalToTransformed();
        return !(this$originalToTransformed == null ? other$originalToTransformed != null : !((Object)this$originalToTransformed).equals(other$originalToTransformed));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddressMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ImageSectionHeader> $originalSections = this.getOriginalSections();
        result = result * 59 + ($originalSections == null ? 43 : ((Object)$originalSections).hashCode());
        List<ImageSectionHeader> $transformedSections = this.getTransformedSections();
        result = result * 59 + ($transformedSections == null ? 43 : ((Object)$transformedSections).hashCode());
        OMAPTable $transformedToOriginal = this.getTransformedToOriginal();
        result = result * 59 + ($transformedToOriginal == null ? 43 : ((Object)$transformedToOriginal).hashCode());
        OMAPTable $originalToTransformed = this.getOriginalToTransformed();
        result = result * 59 + ($originalToTransformed == null ? 43 : ((Object)$originalToTransformed).hashCode());
        return result;
    }

    public String toString() {
        return "AddressMap(originalSections=" + this.getOriginalSections() + ", transformedSections=" + this.getTransformedSections() + ", transformedToOriginal=" + this.getTransformedToOriginal() + ", originalToTransformed=" + this.getOriginalToTransformed() + ")";
    }
}

