/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.source;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineIterator;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.LinesKey;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceFiles;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SourceLineCollector {
    AddressMap addressMap;
    SourceFiles sourceFiles;
    LinkedHashMap<LinesKey, LineInfo> lines;
    LineProgram lineProgram;

    public SourceLineCollector(AddressMap addressMap, SourceFiles sourceFiles, LineProgram lineProgram) {
        LineInfo line;
        LinkedHashMap<LinesKey, LineInfo> sourceLines = new LinkedHashMap<LinesKey, LineInfo>();
        LineIterator lines = lineProgram.getLines();
        while ((line = lines.next()) != null) {
            PdbInternalSectionOffset offset = line.offset;
            sourceLines.put(new LinesKey(offset.getSection(), offset.getOffset()), line);
        }
        this.addressMap = addressMap;
        this.sourceFiles = sourceFiles;
        this.lines = sourceLines;
        this.lineProgram = lineProgram;
    }

    public Lines collectSourceLines(PdbInternalSectionOffset offset, long len) {
        Lines sourceLines = new Lines();
        if (this.lines.isEmpty()) {
            return sourceLines;
        }
        ImmutablePair<Integer, Long> start = new ImmutablePair<Integer, Long>(offset.getSection(), offset.getOffset());
        ImmutablePair<Integer, Long> end = new ImmutablePair<Integer, Long>(offset.getSection(), offset.getOffset() + len);
        long lastFileIndex = Long.MAX_VALUE;
        long lastFileId = 0L;
        for (Map.Entry<LinesKey, LineInfo> entry : this.lines.entrySet()) {
            LinesKey key = entry.getKey();
            LineInfo line = entry.getValue();
            if (key.section != (Integer)((Pair)start).getLeft() || key.offset < (Long)((Pair)start).getRight() || key.offset >= (Long)((Pair)end).getRight()) continue;
            PdbInternalRva rva = line.getOffset().toInternalRva(this.addressMap);
            if (lastFileIndex != line.getFileIndex()) {
                FileInfo file = this.lineProgram.getFileInfo(line.getFileIndex());
                lastFileIndex = line.getFileIndex();
                lastFileId = this.sourceFiles.getId(file.getName());
            }
            sourceLines.addLine(rva.getAddress(), line.getLineStart(), lastFileId);
        }
        return sourceLines;
    }
}

