/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.source;

import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.dbi.ModuleIter;
import com.uqm.crashsight.symtabtool.pdb.mapping.PathMappings;
import com.uqm.crashsight.symtabtool.pdb.module.ModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileInfo;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileIterator;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SourceFiles {
    StringTable stringTable;
    Map<Long, Long> refToId = new LinkedHashMap<Long, Long>(0);
    List<Long> idToRef = new ArrayList<Long>(0);
    Map<String, String> mapping = null;

    public SourceFiles(PDBInfo PDBInfo2, DebugInformation dbi, PathMappings mapping) {
        Module module;
        this.stringTable = PDBInfo2.getStringTable();
        if (this.stringTable == null) {
            return;
        }
        ModuleIter modules = dbi.getModules();
        long id = 0L;
        while ((module = modules.next()) != null) {
            FileInfo file;
            ModuleInfo moduleInfo = PDBInfo2.getModuleInfo(module);
            if (moduleInfo == null) continue;
            if (moduleInfo.getLinesSize() + moduleInfo.getSymbolsSize() > (long)moduleInfo.getBuffer().getBuffer().limit()) break;
            LineProgram lineProgram = moduleInfo.getLineProgram();
            if (lineProgram.inner.getFileChecksums() == null) continue;
            FileIterator files = lineProgram.getFiles();
            while ((file = files.next()) != null) {
                if (this.refToId.containsKey(file.name)) continue;
                this.refToId.put(file.name, id);
                this.idToRef.add(file.name);
                ++id;
            }
        }
    }

    public long getId(long fileRef) {
        return this.refToId.get(fileRef);
    }

    public List<String> getMapping() {
        if (this.stringTable == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Long ref : this.idToRef) {
            String file = this.stringTable.get(ref);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public Map<Long, Long> getRefToId() {
        return this.refToId;
    }

    public List<Long> getIdToRef() {
        return this.idToRef;
    }

    public void setStringTable(StringTable stringTable) {
        this.stringTable = stringTable;
    }

    public void setRefToId(Map<Long, Long> refToId) {
        this.refToId = refToId;
    }

    public void setIdToRef(List<Long> idToRef) {
        this.idToRef = idToRef;
    }

    public void setMapping(Map<String, String> mapping) {
        this.mapping = mapping;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceFiles)) {
            return false;
        }
        SourceFiles other = (SourceFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringTable this$stringTable = this.getStringTable();
        StringTable other$stringTable = other.getStringTable();
        if (this$stringTable == null ? other$stringTable != null : !((Object)this$stringTable).equals(other$stringTable)) {
            return false;
        }
        Map<Long, Long> this$refToId = this.getRefToId();
        Map<Long, Long> other$refToId = other.getRefToId();
        if (this$refToId == null ? other$refToId != null : !((Object)this$refToId).equals(other$refToId)) {
            return false;
        }
        List<Long> this$idToRef = this.getIdToRef();
        List<Long> other$idToRef = other.getIdToRef();
        if (this$idToRef == null ? other$idToRef != null : !((Object)this$idToRef).equals(other$idToRef)) {
            return false;
        }
        List<String> this$mapping = this.getMapping();
        List<String> other$mapping = other.getMapping();
        return !(this$mapping == null ? other$mapping != null : !((Object)this$mapping).equals(other$mapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceFiles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringTable $stringTable = this.getStringTable();
        result = result * 59 + ($stringTable == null ? 43 : ((Object)$stringTable).hashCode());
        Map<Long, Long> $refToId = this.getRefToId();
        result = result * 59 + ($refToId == null ? 43 : ((Object)$refToId).hashCode());
        List<Long> $idToRef = this.getIdToRef();
        result = result * 59 + ($idToRef == null ? 43 : ((Object)$idToRef).hashCode());
        List<String> $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : ((Object)$mapping).hashCode());
        return result;
    }

    public String toString() {
        return "SourceFiles(stringTable=" + this.getStringTable() + ", refToId=" + this.getRefToId() + ", idToRef=" + this.getIdToRef() + ", mapping=" + this.getMapping() + ")";
    }
}

