/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.source;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.module.source.Line;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.RvaRangeIter;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Lines {
    List<Line> lines;
    boolean isSorted;
    long lastRva;

    public Lines() {
        this.lines = new ArrayList<Line>();
        this.isSorted = true;
        this.lastRva = 0L;
    }

    public Lines(List<Line> lines, boolean isSorted, long lastRva) {
        this.lines = lines;
        this.isSorted = isSorted;
        this.lastRva = lastRva;
    }

    public void addLine(long rva, long num, long fileId) {
        this.lines.add(new Line(rva, num, 0L, fileId));
        this.isSorted = this.isSorted && this.lastRva <= rva;
        this.lastRva = rva;
    }

    public void computeLen(long symRva, long symLen) {
        if (this.lines.isEmpty()) {
            return;
        }
        if (!this.isSorted) {
            this.lines.sort(Comparator.comparingLong(o -> o.rva));
        }
        for (int i = 0; i < this.lines.size() - 1; ++i) {
            this.lines.get((int)i).len = this.lines.get((int)(i + 1)).rva - this.lines.get((int)i).rva;
        }
        Line last = this.lines.get(this.lines.size() - 1);
        last.len = symLen - (last.rva - symRva);
    }

    public void finalize(long symRva, long symLen, AddressMap addressMap) {
        this.computeLen(symRva, symLen);
        ArrayList toInsert = new ArrayList();
        boolean isSorted = true;
        long lastRva = 0L;
        for (int i = 0; i < this.lines.size(); ++i) {
            Range<Long> rg;
            Line line = this.lines.get(i);
            PdbInternalRva start = new PdbInternalRva(line.rva);
            PdbInternalRva end = new PdbInternalRva(line.rva + line.len);
            ArrayList<Line> arrayList = new ArrayList<Line>();
            RvaRangeIter rvaRangeIter = addressMap.rvaRanges(Range.between(start.getAddress(), end.getAddress()));
            int j = 0;
            while ((rg = rvaRangeIter.next()) != null) {
                if (j == 0) {
                    line.rva = rg.getMinimum();
                    line.len = rg.getMaximum() - rg.getMinimum();
                    isSorted = isSorted && lastRva <= line.rva;
                    lastRva = line.rva;
                } else {
                    arrayList.add(new Line(rg.getMinimum(), rg.getMaximum() - rg.getMinimum(), line.num, line.fileId));
                    isSorted = isSorted && lastRva <= rg.getMinimum();
                    lastRva = rg.getMinimum();
                }
                ++j;
            }
            if (arrayList.isEmpty()) continue;
            toInsert.add(new ImmutablePair((long)i + 1L, arrayList));
        }
        if (!toInsert.isEmpty()) {
            ArrayList<Line> newLines = new ArrayList<Line>();
            long last = 0L;
            for (Pair pair : toInsert) {
                long i;
                List newLine = (List)pair.getRight();
                for (i = last; i < (Long)pair.getLeft(); ++i) {
                    newLines.add(this.lines.get((int)i));
                }
                newLines.addAll(newLine);
                last = i;
            }
            if (last < (long)this.lines.size()) {
                for (int i = (int)last; i < this.lines.size(); ++i) {
                    newLines.add(this.lines.get(i));
                }
            }
            this.lines = newLines;
        }
        if (!isSorted) {
            this.lines.sort(Comparator.comparingLong(o -> o.rva));
        }
    }

    public Lines findLinesForRange(long rva, long len) {
        List<Line> lines = this.lines.stream().filter(line -> rva <= line.rva && line.rva + line.len <= rva + len).collect(Collectors.toList());
        return new Lines(lines, true, 0L);
    }

    public Lines retain(long rva, long len) {
        if (this.lines.isEmpty()) {
            return null;
        }
        if (rva == this.lines.get((int)0).rva) {
            Line last = this.lines.get(this.lines.size() - 1);
            if (last.rva + last.len == rva + len) {
                return null;
            }
        }
        return this.findLinesForRange(rva, len);
    }

    public void display(BufferedWriter bufferedWriter) {
        try {
            for (Line line : this.lines) {
                bufferedWriter.write(String.format("%x %x %d %d\n", line.rva, line.len, line.num, line.fileId));
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public long getLastRva() {
        return this.lastRva;
    }

    public void setLines(List<Line> lines) {
        this.lines = lines;
    }

    public void setSorted(boolean isSorted) {
        this.isSorted = isSorted;
    }

    public void setLastRva(long lastRva) {
        this.lastRva = lastRva;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lines)) {
            return false;
        }
        Lines other = (Lines)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSorted() != other.isSorted()) {
            return false;
        }
        if (this.getLastRva() != other.getLastRva()) {
            return false;
        }
        List<Line> this$lines = this.getLines();
        List<Line> other$lines = other.getLines();
        return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Lines;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSorted() ? 79 : 97);
        long $lastRva = this.getLastRva();
        result = result * 59 + (int)($lastRva >>> 32 ^ $lastRva);
        List<Line> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        return result;
    }

    public String toString() {
        return "Lines(lines=" + this.getLines() + ", isSorted=" + this.isSorted() + ", lastRva=" + this.getLastRva() + ")";
    }
}

