/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.c13;

import com.uqm.crashsight.symtabtool.pdb.module.c13.LineEntry;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineMarkerEntry;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineMarkerKind;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineNumberEntry;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineInfoKind;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class LineNumberHeader {
    public static final int SIZE = 8;
    long offset;
    long flags;

    public static LineNumberHeader parse(ParseBuffer buffer) {
        LineNumberHeader header = new LineNumberHeader();
        header.offset = buffer.readU32();
        header.flags = buffer.readU32();
        return header;
    }

    public LineEntry parse() {
        long startLine = this.flags & 0xFFFFFFL;
        LineMarkerKind markerKind = null;
        if (startLine == 0xFEEFEEL) {
            markerKind = LineMarkerKind.DoNotStepOnto;
        } else if (startLine == 0xF00F00L) {
            markerKind = LineMarkerKind.DoNotStepInto;
        }
        if (markerKind != null) {
            LineMarkerEntry markerEntry = new LineMarkerEntry(this.offset, markerKind);
            return new LineEntry(null, markerEntry);
        }
        long highStart = startLine & 0xFFFFFFFFFFFFFF80L;
        long lineDelta = this.flags & 0x7FL;
        long endLine = highStart | lineDelta;
        if (endLine < startLine) {
            endLine += 128L;
        }
        LineInfoKind kind = (this.flags & Integer.MIN_VALUE) != 0L ? LineInfoKind.Statement : LineInfoKind.Expression;
        LineNumberEntry numberEntry = new LineNumberEntry(this.offset, startLine, endLine, kind);
        return new LineEntry(numberEntry, null);
    }
}

