/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.c13;

import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesHeader;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DebugLinesBlockHeader {
    public static final int SIZE = 12;
    long fileIndex;
    long numLines;
    long blockSize;

    public static DebugLinesBlockHeader parse(ParseBuffer buffer) {
        DebugLinesBlockHeader header = new DebugLinesBlockHeader();
        header.fileIndex = buffer.readU32();
        header.numLines = buffer.readU32();
        header.blockSize = buffer.readU32();
        return header;
    }

    public static DebugLinesBlockHeader empty() {
        return new DebugLinesBlockHeader();
    }

    long getDataSize() {
        return this.blockSize - 12L;
    }

    long getLineSize() {
        return this.numLines * 8L;
    }

    long getColumnSize(DebugLinesHeader subsection) {
        if (subsection.hasColumns()) {
            return this.numLines * 4L;
        }
        return 0L;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getNumLines() {
        return this.numLines;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setFileIndex(long fileIndex) {
        this.fileIndex = fileIndex;
    }

    public void setNumLines(long numLines) {
        this.numLines = numLines;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugLinesBlockHeader)) {
            return false;
        }
        DebugLinesBlockHeader other = (DebugLinesBlockHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFileIndex() != other.getFileIndex()) {
            return false;
        }
        if (this.getNumLines() != other.getNumLines()) {
            return false;
        }
        return this.getBlockSize() == other.getBlockSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebugLinesBlockHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fileIndex = this.getFileIndex();
        result = result * 59 + (int)($fileIndex >>> 32 ^ $fileIndex);
        long $numLines = this.getNumLines();
        result = result * 59 + (int)($numLines >>> 32 ^ $numLines);
        long $blockSize = this.getBlockSize();
        result = result * 59 + (int)($blockSize >>> 32 ^ $blockSize);
        return result;
    }

    public String toString() {
        return "DebugLinesBlockHeader(fileIndex=" + this.getFileIndex() + ", numLines=" + this.getNumLines() + ", blockSize=" + this.getBlockSize() + ")";
    }
}

