/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.c13;

import com.uqm.crashsight.symtabtool.pdb.module.c13.C13FileIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.C13LineIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugColumnsIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugFileChecksumsIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugFileChecksumsSubsection;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesBlockIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugSubsection;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugSubsectionIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugSubsectionKind;
import com.uqm.crashsight.symtabtool.pdb.module.c13.FileChecksumEntry;
import com.uqm.crashsight.symtabtool.pdb.module.source.FileInfo;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class C13LineProgram {
    ParseBuffer buffer;
    DebugFileChecksumsSubsection fileChecksums;

    public static C13LineProgram parse(ParseBuffer buffer) {
        C13LineProgram lineProgram = new C13LineProgram();
        DebugSubsectionIterator iterator2 = new DebugSubsectionIterator(buffer);
        DebugSubsection subsection = iterator2.find(DebugSubsectionKind.FileChecksums);
        DebugFileChecksumsSubsection fileChecksumsSubsection = subsection != null ? new DebugFileChecksumsSubsection(subsection.getBuffer()) : DebugFileChecksumsSubsection.empty();
        lineProgram.buffer = buffer;
        lineProgram.fileChecksums = fileChecksumsSubsection;
        return lineProgram;
    }

    public C13FileIterator getFiles() {
        return new C13FileIterator(this.fileChecksums.getEntries());
    }

    public C13LineIterator getLines() {
        return new C13LineIterator(new DebugSubsectionIterator(this.buffer), DebugLinesBlockIterator.empty(), DebugLinesIterator.empty(), DebugColumnsIterator.empty());
    }

    public FileInfo getFileInfo(long fileIndex) {
        DebugFileChecksumsIterator entries = this.fileChecksums.getEntriesAtOffset(fileIndex);
        FileChecksumEntry entry = entries.next();
        return new FileInfo(entry.getName(), entry.getChecksum());
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public DebugFileChecksumsSubsection getFileChecksums() {
        return this.fileChecksums;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public void setFileChecksums(DebugFileChecksumsSubsection fileChecksums) {
        this.fileChecksums = fileChecksums;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof C13LineProgram)) {
            return false;
        }
        C13LineProgram other = (C13LineProgram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer)) {
            return false;
        }
        DebugFileChecksumsSubsection this$fileChecksums = this.getFileChecksums();
        DebugFileChecksumsSubsection other$fileChecksums = other.getFileChecksums();
        return !(this$fileChecksums == null ? other$fileChecksums != null : !this$fileChecksums.equals(other$fileChecksums));
    }

    protected boolean canEqual(Object other) {
        return other instanceof C13LineProgram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        DebugFileChecksumsSubsection $fileChecksums = this.getFileChecksums();
        result = result * 59 + ($fileChecksums == null ? 43 : $fileChecksums.hashCode());
        return result;
    }

    public String toString() {
        return "C13LineProgram(buffer=" + this.getBuffer() + ", fileChecksums=" + this.getFileChecksums() + ")";
    }
}

