/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.c13;

import com.uqm.crashsight.symtabtool.pdb.module.c13.ColumnNumberEntry;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugColumnsIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesBlock;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesBlockHeader;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesBlockIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesHeader;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesSubsection;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugSubsection;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugSubsectionIterator;
import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugSubsectionKind;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineEntry;
import com.uqm.crashsight.symtabtool.pdb.module.c13.LineNumberEntry;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineInfo;

public class C13LineIterator {
    DebugSubsectionIterator sections;
    DebugLinesBlockIterator blocks;
    DebugLinesIterator lines;
    DebugColumnsIterator columns;

    public C13LineIterator(DebugSubsectionIterator debugSubsectionIterator, DebugLinesBlockIterator debugLinesBlockIterator, DebugLinesIterator debugLinesIterator, DebugColumnsIterator debugColumnsIterator) {
        this.sections = debugSubsectionIterator;
        this.blocks = debugLinesBlockIterator;
        this.lines = debugLinesIterator;
        this.columns = debugColumnsIterator;
    }

    public LineInfo next() {
        while (true) {
            LineEntry entry;
            if ((entry = this.lines.next()) != null) {
                ColumnNumberEntry columnEntry = this.columns.next();
                if (entry.mark != null) continue;
                LineNumberEntry lineEntry = entry.number;
                DebugLinesHeader sectionHeader = this.blocks.header;
                DebugLinesBlockHeader blockHeader = this.lines.block;
                LineInfo lineInfo = new LineInfo();
                lineInfo.setOffset(sectionHeader.offset.add(lineEntry.getOffset()));
                lineInfo.setLength(0L);
                lineInfo.setFileIndex(blockHeader.getFileIndex());
                lineInfo.setLineStart(lineEntry.getStartLine());
                lineInfo.setLineEnd(lineEntry.getEndLine());
                if (columnEntry == null) {
                    boolean bl = true;
                } else {
                    lineInfo.setColumnStart(columnEntry.startColumn);
                    lineInfo.setColumnEnd(columnEntry.endColumn);
                }
                lineInfo.setKind(lineEntry.getKind());
                return lineInfo;
            }
            DebugLinesBlock block = this.blocks.next();
            if (block != null) {
                this.lines = block.getLines();
                this.columns = block.getColumns();
                continue;
            }
            DebugSubsection section = this.sections.next();
            if (section == null) break;
            if (section.kind != DebugSubsectionKind.Lines) continue;
            DebugLinesSubsection linesSection = DebugLinesSubsection.parse(section.buffer);
            this.blocks = linesSection.getBlocks();
        }
        return null;
    }
}

