/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBIModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.c13.C13LineProgram;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolIter;

public class ModuleInfo {
    ParseBuffer buffer;
    long symbolsSize;
    long linesSize;

    public static ModuleInfo parse(ParseBuffer buffer, Module module) {
        if (buffer == null) {
            return null;
        }
        ModuleInfo moduleInfo = new ModuleInfo();
        DBIModuleInfo info = module.getInfo();
        assert (info.getLinesSize() == 0L);
        moduleInfo.linesSize = info.getC13LinesSize();
        moduleInfo.symbolsSize = info.getSymbolsSize();
        moduleInfo.buffer = buffer;
        return moduleInfo;
    }

    public LineProgram getLineProgram() {
        ParseBuffer data = this.getLinesData(this.linesSize);
        C13LineProgram c13LineProgram = C13LineProgram.parse(data);
        return new LineProgram(c13LineProgram);
    }

    public ParseBuffer getLinesData(long size) {
        long start = this.symbolsSize;
        ParseBuffer buf = new ParseBuffer(this.buffer.getBuffer(), start, start + size);
        return buf;
    }

    public SymbolIter getSymbols() {
        long sig;
        ParseBuffer buf = this.buffer.truncate(this.symbolsSize);
        if (this.symbolsSize > 0L && this.symbolsSize % 4L == 0L && (sig = buf.readU32()) != 4L) {
            Log.error("Unsupported symbol data format", new Object[0]);
            return SymbolIter.empty();
        }
        return new SymbolIter(buf);
    }

    public SymbolIter symbolsAt(long symbolIndex) {
        SymbolIter iter = this.getSymbols();
        iter.seek(symbolIndex);
        return iter;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public long getSymbolsSize() {
        return this.symbolsSize;
    }

    public long getLinesSize() {
        return this.linesSize;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public void setSymbolsSize(long symbolsSize) {
        this.symbolsSize = symbolsSize;
    }

    public void setLinesSize(long linesSize) {
        this.linesSize = linesSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSymbolsSize() != other.getSymbolsSize()) {
            return false;
        }
        if (this.getLinesSize() != other.getLinesSize()) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        return !(this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $symbolsSize = this.getSymbolsSize();
        result = result * 59 + (int)($symbolsSize >>> 32 ^ $symbolsSize);
        long $linesSize = this.getLinesSize();
        result = result * 59 + (int)($linesSize >>> 32 ^ $linesSize);
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        return result;
    }

    public String toString() {
        return "ModuleInfo(buffer=" + this.getBuffer() + ", symbolsSize=" + this.getSymbolsSize() + ", linesSize=" + this.getLinesSize() + ")";
    }
}

