/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

import com.uqm.crashsight.symtabtool.pdb.dbi.DBIHeader;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBISectionContributionIter;
import com.uqm.crashsight.symtabtool.pdb.dbi.MachineType;
import com.uqm.crashsight.symtabtool.pdb.dbi.ModuleIter;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DebugInformation {
    ParseBuffer buffer = null;
    DBIHeader header = null;
    long headLen;

    public static DebugInformation parse(ParseBuffer buffer) {
        DebugInformation self = new DebugInformation();
        self.buffer = buffer;
        self.header = DBIHeader.parse(buffer);
        self.headLen = buffer.pos();
        return self;
    }

    public MachineType getMachineType() {
        return MachineType.fromInt(this.header.getMachineType());
    }

    public ModuleIter getModules() {
        this.buffer.pos(this.headLen);
        return new ModuleIter(this.buffer);
    }

    public DBISectionContributionIter getSectionContributes() {
        this.buffer.pos(this.headLen + this.header.getModuleListSize());
        ParseBuffer data = new ParseBuffer(this.buffer.getBuffer(), this.buffer.pos(), this.buffer.pos() + this.header.getSectionContributionSize());
        return DBISectionContributionIter.parse(data);
    }

    public void delete() {
        this.buffer = null;
        this.header = null;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public DBIHeader getHeader() {
        return this.header;
    }

    public long getHeadLen() {
        return this.headLen;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public void setHeader(DBIHeader header) {
        this.header = header;
    }

    public void setHeadLen(long headLen) {
        this.headLen = headLen;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugInformation)) {
            return false;
        }
        DebugInformation other = (DebugInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHeadLen() != other.getHeadLen()) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer)) {
            return false;
        }
        DBIHeader this$header = this.getHeader();
        DBIHeader other$header = other.getHeader();
        return !(this$header == null ? other$header != null : !((Object)this$header).equals(other$header));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebugInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $headLen = this.getHeadLen();
        result = result * 59 + (int)($headLen >>> 32 ^ $headLen);
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        DBIHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        return result;
    }

    public String toString() {
        return "DebugInformation(buffer=" + this.getBuffer() + ", header=" + this.getHeader() + ", headLen=" + this.getHeadLen() + ")";
    }
}

