/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.GUID;
import com.uqm.crashsight.symtabtool.pdb.dbi.HeaderVersion;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DBIHeader {
    long signature;
    HeaderVersion version;
    long age;
    int gsSymbolsStream;
    int internalVersion;
    int psSymbolsStream;
    int pdbDllBuildVersion;
    int symbolRecordsStream;
    int pdbDllRbldVersion;
    long moduleListSize;
    long sectionContributionSize;
    long sectionMapSize;
    long fileInfoSize;
    long typeServerMapSize;
    long mfcTypeServerIndex;
    long debugHeaderSize;
    long ecSubstreamSize;
    int flags;
    int machineType;
    long reserved;

    public static DBIHeader parse(ParseBuffer buffer) {
        DBIHeader header = new DBIHeader();
        header.signature = buffer.readU32() & 0xFFFFFFFFFFFFFFFFL;
        header.version = HeaderVersion.fromInt((int)buffer.readU32());
        header.age = buffer.readU32();
        header.gsSymbolsStream = buffer.readU16();
        header.internalVersion = buffer.readU16();
        header.psSymbolsStream = buffer.readU16();
        header.pdbDllBuildVersion = buffer.readU16();
        header.symbolRecordsStream = buffer.readU16();
        header.pdbDllRbldVersion = buffer.readU16();
        header.moduleListSize = buffer.readU32();
        header.sectionContributionSize = buffer.readU32();
        header.sectionMapSize = buffer.readU32();
        header.fileInfoSize = buffer.readU32();
        header.typeServerMapSize = buffer.readU32();
        header.mfcTypeServerIndex = buffer.readU32();
        header.debugHeaderSize = buffer.readU32();
        header.ecSubstreamSize = buffer.readU32();
        header.flags = buffer.readU16();
        header.machineType = buffer.readU16();
        header.reserved = buffer.readU32();
        return header;
    }

    public void print(GUID guid, String filename) {
        Log.info("MODULE windows %s %08X%04X%04X%02X%02X%02X%02X%02X%02X%02X%02X%x %s\n", this.machineType, guid.Data1, guid.Data2, guid.Data3, guid.Data4[0], guid.Data4[1], guid.Data4[2], guid.Data4[3], guid.Data4[4], guid.Data4[5], guid.Data4[6], guid.Data4[7], this.age, filename);
    }

    public long getSignature() {
        return this.signature;
    }

    public HeaderVersion getVersion() {
        return this.version;
    }

    public long getAge() {
        return this.age;
    }

    public int getGsSymbolsStream() {
        return this.gsSymbolsStream;
    }

    public int getInternalVersion() {
        return this.internalVersion;
    }

    public int getPsSymbolsStream() {
        return this.psSymbolsStream;
    }

    public int getPdbDllBuildVersion() {
        return this.pdbDllBuildVersion;
    }

    public int getSymbolRecordsStream() {
        return this.symbolRecordsStream;
    }

    public int getPdbDllRbldVersion() {
        return this.pdbDllRbldVersion;
    }

    public long getModuleListSize() {
        return this.moduleListSize;
    }

    public long getSectionContributionSize() {
        return this.sectionContributionSize;
    }

    public long getSectionMapSize() {
        return this.sectionMapSize;
    }

    public long getFileInfoSize() {
        return this.fileInfoSize;
    }

    public long getTypeServerMapSize() {
        return this.typeServerMapSize;
    }

    public long getMfcTypeServerIndex() {
        return this.mfcTypeServerIndex;
    }

    public long getDebugHeaderSize() {
        return this.debugHeaderSize;
    }

    public long getEcSubstreamSize() {
        return this.ecSubstreamSize;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMachineType() {
        return this.machineType;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void setSignature(long signature) {
        this.signature = signature;
    }

    public void setVersion(HeaderVersion version) {
        this.version = version;
    }

    public void setAge(long age) {
        this.age = age;
    }

    public void setGsSymbolsStream(int gsSymbolsStream) {
        this.gsSymbolsStream = gsSymbolsStream;
    }

    public void setInternalVersion(int internalVersion) {
        this.internalVersion = internalVersion;
    }

    public void setPsSymbolsStream(int psSymbolsStream) {
        this.psSymbolsStream = psSymbolsStream;
    }

    public void setPdbDllBuildVersion(int pdbDllBuildVersion) {
        this.pdbDllBuildVersion = pdbDllBuildVersion;
    }

    public void setSymbolRecordsStream(int symbolRecordsStream) {
        this.symbolRecordsStream = symbolRecordsStream;
    }

    public void setPdbDllRbldVersion(int pdbDllRbldVersion) {
        this.pdbDllRbldVersion = pdbDllRbldVersion;
    }

    public void setModuleListSize(long moduleListSize) {
        this.moduleListSize = moduleListSize;
    }

    public void setSectionContributionSize(long sectionContributionSize) {
        this.sectionContributionSize = sectionContributionSize;
    }

    public void setSectionMapSize(long sectionMapSize) {
        this.sectionMapSize = sectionMapSize;
    }

    public void setFileInfoSize(long fileInfoSize) {
        this.fileInfoSize = fileInfoSize;
    }

    public void setTypeServerMapSize(long typeServerMapSize) {
        this.typeServerMapSize = typeServerMapSize;
    }

    public void setMfcTypeServerIndex(long mfcTypeServerIndex) {
        this.mfcTypeServerIndex = mfcTypeServerIndex;
    }

    public void setDebugHeaderSize(long debugHeaderSize) {
        this.debugHeaderSize = debugHeaderSize;
    }

    public void setEcSubstreamSize(long ecSubstreamSize) {
        this.ecSubstreamSize = ecSubstreamSize;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setMachineType(int machineType) {
        this.machineType = machineType;
    }

    public void setReserved(long reserved) {
        this.reserved = reserved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBIHeader)) {
            return false;
        }
        DBIHeader other = (DBIHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSignature() != other.getSignature()) {
            return false;
        }
        if (this.getAge() != other.getAge()) {
            return false;
        }
        if (this.getGsSymbolsStream() != other.getGsSymbolsStream()) {
            return false;
        }
        if (this.getInternalVersion() != other.getInternalVersion()) {
            return false;
        }
        if (this.getPsSymbolsStream() != other.getPsSymbolsStream()) {
            return false;
        }
        if (this.getPdbDllBuildVersion() != other.getPdbDllBuildVersion()) {
            return false;
        }
        if (this.getSymbolRecordsStream() != other.getSymbolRecordsStream()) {
            return false;
        }
        if (this.getPdbDllRbldVersion() != other.getPdbDllRbldVersion()) {
            return false;
        }
        if (this.getModuleListSize() != other.getModuleListSize()) {
            return false;
        }
        if (this.getSectionContributionSize() != other.getSectionContributionSize()) {
            return false;
        }
        if (this.getSectionMapSize() != other.getSectionMapSize()) {
            return false;
        }
        if (this.getFileInfoSize() != other.getFileInfoSize()) {
            return false;
        }
        if (this.getTypeServerMapSize() != other.getTypeServerMapSize()) {
            return false;
        }
        if (this.getMfcTypeServerIndex() != other.getMfcTypeServerIndex()) {
            return false;
        }
        if (this.getDebugHeaderSize() != other.getDebugHeaderSize()) {
            return false;
        }
        if (this.getEcSubstreamSize() != other.getEcSubstreamSize()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getMachineType() != other.getMachineType()) {
            return false;
        }
        if (this.getReserved() != other.getReserved()) {
            return false;
        }
        HeaderVersion this$version = this.getVersion();
        HeaderVersion other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBIHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signature = this.getSignature();
        result = result * 59 + (int)($signature >>> 32 ^ $signature);
        long $age = this.getAge();
        result = result * 59 + (int)($age >>> 32 ^ $age);
        result = result * 59 + this.getGsSymbolsStream();
        result = result * 59 + this.getInternalVersion();
        result = result * 59 + this.getPsSymbolsStream();
        result = result * 59 + this.getPdbDllBuildVersion();
        result = result * 59 + this.getSymbolRecordsStream();
        result = result * 59 + this.getPdbDllRbldVersion();
        long $moduleListSize = this.getModuleListSize();
        result = result * 59 + (int)($moduleListSize >>> 32 ^ $moduleListSize);
        long $sectionContributionSize = this.getSectionContributionSize();
        result = result * 59 + (int)($sectionContributionSize >>> 32 ^ $sectionContributionSize);
        long $sectionMapSize = this.getSectionMapSize();
        result = result * 59 + (int)($sectionMapSize >>> 32 ^ $sectionMapSize);
        long $fileInfoSize = this.getFileInfoSize();
        result = result * 59 + (int)($fileInfoSize >>> 32 ^ $fileInfoSize);
        long $typeServerMapSize = this.getTypeServerMapSize();
        result = result * 59 + (int)($typeServerMapSize >>> 32 ^ $typeServerMapSize);
        long $mfcTypeServerIndex = this.getMfcTypeServerIndex();
        result = result * 59 + (int)($mfcTypeServerIndex >>> 32 ^ $mfcTypeServerIndex);
        long $debugHeaderSize = this.getDebugHeaderSize();
        result = result * 59 + (int)($debugHeaderSize >>> 32 ^ $debugHeaderSize);
        long $ecSubstreamSize = this.getEcSubstreamSize();
        result = result * 59 + (int)($ecSubstreamSize >>> 32 ^ $ecSubstreamSize);
        result = result * 59 + this.getFlags();
        result = result * 59 + this.getMachineType();
        long $reserved = this.getReserved();
        result = result * 59 + (int)($reserved >>> 32 ^ $reserved);
        HeaderVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        return result;
    }

    public String toString() {
        return "DBIHeader(signature=" + this.getSignature() + ", version=" + (Object)((Object)this.getVersion()) + ", age=" + this.getAge() + ", gsSymbolsStream=" + this.getGsSymbolsStream() + ", internalVersion=" + this.getInternalVersion() + ", psSymbolsStream=" + this.getPsSymbolsStream() + ", pdbDllBuildVersion=" + this.getPdbDllBuildVersion() + ", symbolRecordsStream=" + this.getSymbolRecordsStream() + ", pdbDllRbldVersion=" + this.getPdbDllRbldVersion() + ", moduleListSize=" + this.getModuleListSize() + ", sectionContributionSize=" + this.getSectionContributionSize() + ", sectionMapSize=" + this.getSectionMapSize() + ", fileInfoSize=" + this.getFileInfoSize() + ", typeServerMapSize=" + this.getTypeServerMapSize() + ", mfcTypeServerIndex=" + this.getMfcTypeServerIndex() + ", debugHeaderSize=" + this.getDebugHeaderSize() + ", ecSubstreamSize=" + this.getEcSubstreamSize() + ", flags=" + this.getFlags() + ", machineType=" + this.getMachineType() + ", reserved=" + this.getReserved() + ")";
    }
}

