/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

import com.uqm.crashsight.symtabtool.pdb.dbi.DBIHeader;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DBIExtraStreams {
    int fpo = -1;
    int exception = -1;
    int fixup = -1;
    int omapToSrc = -1;
    int omapFromSrc = -1;
    int sectionHeaders = -1;
    int tokenRidMap = -1;
    int xdata = -1;
    int pdata = -1;
    int framedata = -1;
    int originalSectionHeaders = -1;

    public DBIExtraStreams(DebugInformation debugInfo) {
        ParseBuffer parseBuffer = debugInfo.getBuffer();
        DBIHeader dbiHeader = debugInfo.getHeader();
        long offset = debugInfo.getHeadLen() + dbiHeader.getModuleListSize() + dbiHeader.sectionContributionSize + dbiHeader.sectionMapSize + dbiHeader.fileInfoSize + dbiHeader.typeServerMapSize + dbiHeader.mfcTypeServerIndex + dbiHeader.ecSubstreamSize;
        parseBuffer.pos(offset);
        this.fpo = parseBuffer.readU16();
        this.exception = parseBuffer.readU16();
        this.fixup = parseBuffer.readU16();
        this.omapToSrc = parseBuffer.readU16();
        this.omapFromSrc = parseBuffer.readU16();
        this.sectionHeaders = parseBuffer.readU16();
        this.tokenRidMap = parseBuffer.readU16();
        this.xdata = parseBuffer.readU16();
        this.pdata = parseBuffer.readU16();
        this.framedata = parseBuffer.readU16();
        this.originalSectionHeaders = parseBuffer.readU16();
    }

    public int getFpo() {
        return this.fpo;
    }

    public int getException() {
        return this.exception;
    }

    public int getFixup() {
        return this.fixup;
    }

    public int getOmapToSrc() {
        return this.omapToSrc;
    }

    public int getOmapFromSrc() {
        return this.omapFromSrc;
    }

    public int getSectionHeaders() {
        return this.sectionHeaders;
    }

    public int getTokenRidMap() {
        return this.tokenRidMap;
    }

    public int getXdata() {
        return this.xdata;
    }

    public int getPdata() {
        return this.pdata;
    }

    public int getFramedata() {
        return this.framedata;
    }

    public int getOriginalSectionHeaders() {
        return this.originalSectionHeaders;
    }

    public void setFpo(int fpo) {
        this.fpo = fpo;
    }

    public void setException(int exception) {
        this.exception = exception;
    }

    public void setFixup(int fixup) {
        this.fixup = fixup;
    }

    public void setOmapToSrc(int omapToSrc) {
        this.omapToSrc = omapToSrc;
    }

    public void setOmapFromSrc(int omapFromSrc) {
        this.omapFromSrc = omapFromSrc;
    }

    public void setSectionHeaders(int sectionHeaders) {
        this.sectionHeaders = sectionHeaders;
    }

    public void setTokenRidMap(int tokenRidMap) {
        this.tokenRidMap = tokenRidMap;
    }

    public void setXdata(int xdata) {
        this.xdata = xdata;
    }

    public void setPdata(int pdata) {
        this.pdata = pdata;
    }

    public void setFramedata(int framedata) {
        this.framedata = framedata;
    }

    public void setOriginalSectionHeaders(int originalSectionHeaders) {
        this.originalSectionHeaders = originalSectionHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBIExtraStreams)) {
            return false;
        }
        DBIExtraStreams other = (DBIExtraStreams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFpo() != other.getFpo()) {
            return false;
        }
        if (this.getException() != other.getException()) {
            return false;
        }
        if (this.getFixup() != other.getFixup()) {
            return false;
        }
        if (this.getOmapToSrc() != other.getOmapToSrc()) {
            return false;
        }
        if (this.getOmapFromSrc() != other.getOmapFromSrc()) {
            return false;
        }
        if (this.getSectionHeaders() != other.getSectionHeaders()) {
            return false;
        }
        if (this.getTokenRidMap() != other.getTokenRidMap()) {
            return false;
        }
        if (this.getXdata() != other.getXdata()) {
            return false;
        }
        if (this.getPdata() != other.getPdata()) {
            return false;
        }
        if (this.getFramedata() != other.getFramedata()) {
            return false;
        }
        return this.getOriginalSectionHeaders() == other.getOriginalSectionHeaders();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBIExtraStreams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFpo();
        result = result * 59 + this.getException();
        result = result * 59 + this.getFixup();
        result = result * 59 + this.getOmapToSrc();
        result = result * 59 + this.getOmapFromSrc();
        result = result * 59 + this.getSectionHeaders();
        result = result * 59 + this.getTokenRidMap();
        result = result * 59 + this.getXdata();
        result = result * 59 + this.getPdata();
        result = result * 59 + this.getFramedata();
        result = result * 59 + this.getOriginalSectionHeaders();
        return result;
    }

    public String toString() {
        return "DBIExtraStreams(fpo=" + this.getFpo() + ", exception=" + this.getException() + ", fixup=" + this.getFixup() + ", omapToSrc=" + this.getOmapToSrc() + ", omapFromSrc=" + this.getOmapFromSrc() + ", sectionHeaders=" + this.getSectionHeaders() + ", tokenRidMap=" + this.getTokenRidMap() + ", xdata=" + this.getXdata() + ", pdata=" + this.getPdata() + ", framedata=" + this.getFramedata() + ", originalSectionHeaders=" + this.getOriginalSectionHeaders() + ")";
    }
}

