/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.common;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class PdbInternalSectionOffset {
    private long offset;
    private int section;

    public static PdbInternalSectionOffset parse(ParseBuffer buffer) {
        return new PdbInternalSectionOffset(buffer.readU32(), buffer.readU16());
    }

    public static PdbInternalSectionOffset empty() {
        return new PdbInternalSectionOffset(0L, 0);
    }

    public PdbInternalSectionOffset(long offset, int section) {
        this.offset = offset;
        this.section = section;
    }

    public Rva toRva(AddressMap translator) {
        return this.toInternalRva(translator).toRva(translator);
    }

    public PdbInternalRva toInternalRva(AddressMap translator) {
        Long internalRva = AddressMap.getVirtualAddress(translator.getOriginalSections(), this.section, this.offset);
        return new PdbInternalRva(internalRva);
    }

    public PdbInternalSectionOffset add(long offset) {
        return new PdbInternalSectionOffset(this.offset + offset, this.section);
    }

    public boolean isEq(PdbInternalSectionOffset other) {
        return this.section == other.getSection() && this.offset == other.getOffset();
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSection() {
        return this.section;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdbInternalSectionOffset)) {
            return false;
        }
        PdbInternalSectionOffset other = (PdbInternalSectionOffset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getSection() == other.getSection();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdbInternalSectionOffset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + this.getSection();
        return result;
    }

    public String toString() {
        return "PdbInternalSectionOffset(offset=" + this.getOffset() + ", section=" + this.getSection() + ")";
    }
}

