/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    private static final ByteBuffer buffer = ByteBuffer.allocate(8);

    public static List<String> rsplitn(String s, String p, int n) {
        int i;
        String[] splits = s.split(p);
        ArrayList<String> results = new ArrayList<String>(n);
        for (i = splits.length - 1; i >= 0; --i) {
            results.add(splits[i]);
            if (results.size() == n - 1) break;
        }
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            sb.append(splits[j]);
            if (j >= i - 1) continue;
            sb.append(p);
        }
        if (sb.length() > 0) {
            results.add(sb.toString());
        }
        return results;
    }

    public static void align(ByteBuffer buffer, int align) {
        while (buffer.hasRemaining() && buffer.position() % align != 0) {
            buffer.position(buffer.position() + 1);
        }
    }

    public static int unsignedCompare(short s, int i) {
        buffer.clear();
        buffer.putInt(0);
        short sZero = 0;
        buffer.putShort(sZero);
        buffer.putShort(s);
        buffer.flip();
        long sL = buffer.getLong();
        buffer.clear();
        buffer.putInt(0);
        buffer.putInt(i);
        buffer.flip();
        long iL = buffer.getLong();
        return Long.compare(sL, iL);
    }

    public static int unsignedCompare(int s, int i) {
        buffer.clear();
        buffer.putInt(0);
        buffer.putInt(s);
        buffer.flip();
        long sL = buffer.getLong();
        buffer.clear();
        buffer.putInt(0);
        buffer.putInt(i);
        buffer.flip();
        long iL = buffer.getLong();
        return Long.compare(sL, iL);
    }

    public static short readUByte(ByteBuffer reader) {
        byte b = reader.get();
        buffer.clear();
        buffer.put((byte)0);
        buffer.put(b);
        buffer.flip();
        return buffer.getShort();
    }

    public static long readUInt(ByteBuffer reader) {
        byte[] fourBytes = new byte[4];
        reader.get(fourBytes);
        buffer.clear();
        buffer.putInt(0);
        for (int i = 3; i >= 0; --i) {
            buffer.put(fourBytes[i]);
        }
        buffer.flip();
        return buffer.getLong();
    }

    public static int readUShort(ByteBuffer reader) {
        byte[] twoBytes = new byte[2];
        reader.get(twoBytes);
        buffer.clear();
        buffer.putShort((short)0);
        for (int i = 1; i >= 0; --i) {
            buffer.put(twoBytes[i]);
        }
        buffer.flip();
        return buffer.getInt();
    }

    public static long readUInt(RandomAccessFile randomAccessFile) {
        try {
            byte[] fourBytes = new byte[4];
            randomAccessFile.read(fourBytes);
            buffer.clear();
            buffer.putInt(0);
            for (int i = 3; i >= 0; --i) {
                buffer.put(fourBytes[i]);
            }
            buffer.flip();
            return buffer.getLong();
        }
        catch (Exception e) {
            Log.error(e);
            return -1L;
        }
    }

    public static int getBufferCapacity(long capacity) throws Exception {
        if (capacity > Integer.MAX_VALUE) {
            throw new Exception("ByteBuffer capacity too big!");
        }
        return (int)capacity;
    }

    public static void main(String[] args2) {
        List<String> r = Utils.rsplitn("Mary had a little lamb", " ", 3);
        r = Utils.rsplitn("lionXXtigerXleopard", "X", 3);
        r = Utils.rsplitn("lion::tiger::leopard", "::", 2);
        System.out.println(r);
    }
}

