/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.pdb.DumpSymType;
import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.PdbHeaderParser;
import com.uqm.crashsight.symtabtool.pdb.module.source.Line;
import com.uqm.crashsight.symtabtool.pdb.stream.StreamManager;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Vector;

public class PdbParser {
    public String fileName;
    public DumpSymType dumpSymType;
    public boolean dumpCfi;
    public long fileFormat = 0L;
    public String uuid = null;
    public String arch = null;
    public SymbolTable symbolTable = null;
    public PDBInfo pdbInfo = null;
    public String symbolPath = "";
    public String appName = "";

    private PdbParser(String fileName, boolean dumpSymType, boolean dmpCfi) {
        this.fileName = fileName;
        this.dumpSymType = dumpSymType ? DumpSymType.DumpAll : (dmpCfi ? DumpSymType.DumpCfi : DumpSymType.DumpNone);
    }

    public static boolean isPdb(String fileName) {
        return PdbHeaderParser.isPdb(fileName);
    }

    public static PdbParser create(String fileName, boolean dmpSymbol, boolean dmpCfi) {
        PdbParser pdbParser = new PdbParser(fileName, dmpSymbol, dmpCfi);
        if (!pdbParser.load()) {
            return null;
        }
        return pdbParser;
    }

    public static String getPdbDebugId(String fileName) {
        StreamManager.init(fileName);
        return new PDBInfo().parseDebugId();
    }

    public static Vector<Symbol> breakpadToSymbolTab(String breakpadPath) {
        Vector<Symbol> symbolList = new Vector<Symbol>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(breakpadPath));
            HashMap<String, String> files = new HashMap<String, String>();
            String line = reader.readLine();
            while (line != null) {
                String[] a;
                if (line.startsWith("FILE ")) {
                    a = line.split(" ");
                    files.put(a[1], a[2]);
                    line = reader.readLine();
                    continue;
                }
                if (line.startsWith("FUNC ")) {
                    a = line.split(" ");
                    StringBuilder func = new StringBuilder();
                    for (int i = 4; i < a.length; ++i) {
                        func.append(a[i]);
                    }
                    line = reader.readLine();
                    if (line == null) continue;
                    if (line.startsWith("FUNC ") || line.startsWith("PUBLIC ") || line.startsWith("FILE ")) {
                        Symbol symbol = new Symbol();
                        String startAddress = a[1].equals("m") ? a[2] : a[1];
                        String endAddress = a[1].equals("m") ? a[3] : a[2];
                        symbol.setAddress(Long.parseLong(startAddress, 16));
                        symbol.setEndAddress(symbol.getAddress() + Long.parseLong(endAddress, 16));
                        symbol.setFunction(func.toString());
                        symbolList.add(symbol);
                        continue;
                    }
                    while (!(line == null || line.startsWith("FUNC ") || line.startsWith("PUBLIC ") || line.startsWith("FILE "))) {
                        String[] b = line.split(" ");
                        Symbol symbol = new Symbol();
                        symbol.setAddress(Long.parseLong(b[0], 16));
                        symbol.setEndAddress(symbol.getAddress() + Long.parseLong(b[1], 16));
                        symbol.setFunction(func.toString());
                        symbol.setSourceFile((String)files.get(b[3]));
                        symbol.setSourceLine(Long.parseLong(b[2]));
                        symbolList.add(symbol);
                        line = reader.readLine();
                    }
                    continue;
                }
                line = reader.readLine();
            }
            Log.info("breakpad symbol list len: " + symbolList.size(), new Object[0]);
        }
        catch (Exception e) {
            Log.error(e);
        }
        return symbolList;
    }

    private String parseAppName(String fileName) {
        File file = new File(fileName);
        String simpleName = file.getName();
        if (simpleName.contains(".")) {
            simpleName = simpleName.substring(0, simpleName.indexOf("."));
        }
        return simpleName;
    }

    private String pdbSymtabFileNameFormatter() {
        String pdbDir = Paths.get(this.fileName, new String[0]).getParent().toString();
        this.appName = this.pdbInfo.pdbName.substring(0, this.pdbInfo.pdbName.lastIndexOf(46));
        String pdbSymtabFileName = "crashsightSymbol";
        pdbSymtabFileName = pdbSymtabFileName + "&";
        pdbSymtabFileName = pdbSymtabFileName + this.arch;
        pdbSymtabFileName = pdbSymtabFileName + "&";
        pdbSymtabFileName = pdbSymtabFileName + Utils.urlEncodeString(this.appName);
        pdbSymtabFileName = pdbSymtabFileName + "&";
        pdbSymtabFileName = pdbSymtabFileName + this.uuid;
        pdbSymtabFileName = pdbSymtabFileName + ".sym";
        return Paths.get(pdbDir, pdbSymtabFileName).toString();
    }

    private boolean load() {
        try {
            Log.info("Begin to parse file: %s", this.fileName);
            StreamManager.init(this.fileName);
            if (this.dumpCfi) {
                // empty if block
            }
            if (this.dumpSymType == DumpSymType.DumpAll || this.dumpSymType == DumpSymType.DumpCfi) {
                // empty if block
            }
            this.pdbInfo = new PDBInfo(null, this.fileName, null, null);
            if (!this.pdbInfo.parsed) {
                return false;
            }
            this.arch = this.pdbInfo.getCpu().toString();
            this.uuid = this.pdbInfo.getDebugId();
            long l = this.fileFormat = this.arch.contains("64") ? 64L : 32L;
            if (this.dumpSymType != DumpSymType.DumpNone) {
                this.symbolPath = this.pdbSymtabFileNameFormatter();
                BufferedWriter bufferedWriter = FileHelper.openFileWriter(new File(this.symbolPath));
                this.pdbInfo.display(bufferedWriter, this.dumpSymType);
                assert (bufferedWriter != null);
                bufferedWriter.flush();
            }
            this.symbolTable = this.getSymbolTable();
            this.pdbInfo = null;
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    SymbolTable getSymbolTable() {
        SymbolTable symbolTable = new SymbolTable();
        for (PDBSymbol sym : this.pdbInfo.symbols.getMap().values()) {
            if (sym.getSource().getLines().isEmpty()) {
                Symbol symbol = new Symbol();
                symbol.setFunction(sym.getName());
                symbol.setAddress(sym.getRva());
                symbol.setEndAddress(sym.getRva() + sym.getLen());
                symbolTable.add(symbol);
                continue;
            }
            for (Line line : sym.getSource().getLines()) {
                Symbol symbol = new Symbol();
                symbol.setFunction(sym.getName());
                symbol.setAddress(line.getRva());
                symbol.setEndAddress(line.getRva() + line.getLen());
                symbol.setSourceLine(line.getNum());
                symbol.setSourceFile(this.pdbInfo.files.get((int)line.getFileId()));
                symbolTable.add(symbol);
            }
        }
        return symbolTable;
    }
}

