/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.pe.ImageSectionHeader;
import java.util.List;
import java.util.stream.Collectors;

public class PDBSections {
    public static final long IMAGE_SCN_CNT_CODE = 32L;
    public static final long IMAGE_SCN_MEM_EXECUTE = 0x20000000L;
    List<Boolean> sections;

    public PDBSections(PDBInfo PDBInfo2) {
        List<ImageSectionHeader> imageSectionHeaders = PDBInfo2.getSections();
        this.sections = imageSectionHeaders.stream().map(x -> this.hasCode(x.getCharacteristics())).collect(Collectors.toList());
    }

    public boolean hasCode(long characteristics) {
        return (characteristics & 0x20000020L) != 0L;
    }

    public boolean isCode(int section) {
        if (this.sections.size() > section) {
            return this.sections.get(section);
        }
        return false;
    }

    public List<Boolean> getSections() {
        return this.sections;
    }

    public void setSections(List<Boolean> sections) {
        this.sections = sections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDBSections)) {
            return false;
        }
        PDBSections other = (PDBSections)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Boolean> this$sections = this.getSections();
        List<Boolean> other$sections = other.getSections();
        return !(this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PDBSections;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Boolean> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        return result;
    }

    public String toString() {
        return "PDBSections(sections=" + this.getSections() + ")";
    }
}

