/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.Collector;
import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.DumpSymType;
import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.PDBContributions;
import com.uqm.crashsight.symtabtool.pdb.PDBData;
import com.uqm.crashsight.symtabtool.pdb.PDBSections;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBIExtraStreams;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBIHeader;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.dbi.MachineType;
import com.uqm.crashsight.symtabtool.pdb.framedata.FrameTable;
import com.uqm.crashsight.symtabtool.pdb.module.ModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.PSymbolTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceFiles;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.OMAPTable;
import com.uqm.crashsight.symtabtool.pdb.pdbi.PDBInformation;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamName;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamNames;
import com.uqm.crashsight.symtabtool.pdb.pe.ImageSectionHeader;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.stream.StreamManager;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTable;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.RvaSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.Symbol;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemInformation;
import com.uqm.crashsight.symtabtool.pdb.types.DumperFlags;
import com.uqm.crashsight.symtabtool.pdb.types.TypeDumper;
import com.uqm.crashsight.symtabtool.pe.PeObject;
import java.io.BufferedWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class PDBInfo {
    PDBSymbols symbols;
    List<String> files;
    Cpu cpu;
    String debugId;
    String pdbName;
    String peName;
    String codeId;
    String stack;
    DBIExtraStreams dbiExtraStreams = null;
    PDBInformation pi = null;
    ParseBuffer oldStream = null;
    ParseBuffer newStream = null;
    FrameTable frameTable = null;
    boolean parsed = false;

    public PDBInfo(ParseBuffer buf, String fileName, String peName, PeObject pe) {
        long start;
        String pdbName = Paths.get(fileName, new String[0]).getFileName().toString();
        long tmp = start = System.currentTimeMillis();
        DebugInformation dbi = this.getDebugInformation();
        if (dbi == null) {
            Log.warn("The pdb file does not have debug infor header.", new Object[0]);
            return;
        }
        PDBInformation pi = this.getPdbInformation();
        FrameTable frameTable = this.getFrameTable();
        PDBSections pdbSections = new PDBSections(this);
        PDBContributions pdbContributions = new PDBContributions(dbi, pdbSections);
        tmp = System.currentTimeMillis();
        Log.info("prepare stream cost[%d]", tmp - start);
        start = tmp;
        Cpu cpu = this.getCpu(dbi);
        if (!cpu.equals((Object)Cpu.X86_64)) {
            Log.warn("Unsupport pdb file which machine type is " + cpu.toString(), new Object[0]);
            return;
        }
        String debugId = this.getDebugId(dbi, pi);
        SourceFiles sourceFiles = new SourceFiles(this, dbi, null);
        tmp = System.currentTimeMillis();
        Log.info("SourceFiles cost[%d]", tmp - start);
        start = tmp;
        PDBData pdbData = new PDBData(this.getAddressMap());
        Collector collector = new Collector(cpu, RvaSymbols.empty(), pdbSections, pdbContributions);
        pdbData.collectFunctions(this, dbi, collector, sourceFiles);
        tmp = System.currentTimeMillis();
        Log.info("collectFunctions cost[%d]", tmp - start);
        start = tmp;
        PSymbolTable globals = this.getGlobalSymbols(dbi.getHeader());
        dbi.delete();
        dbi = null;
        pdbData.collectPublicSymbols(globals, collector);
        tmp = System.currentTimeMillis();
        Log.info("collectPublicSymbols cost[%d]", tmp - start);
        start = tmp;
        globals.delete();
        globals = null;
        ItemInformation typeInfo = this.getTypeInformation();
        TypeDumper typeDumper = new TypeDumper(typeInfo, cpu.getPtrSize(), DumperFlags.empty());
        tmp = System.currentTimeMillis();
        Log.info("getTypeInformation cost[%d]", tmp - start);
        start = tmp;
        pe = new PeObject(fileName, "PDB");
        Log.info("begin to moveToPdbSymbols", new Object[0]);
        PDBSymbols symbols = collector.symbols.moveToPdbSymbols(typeDumper, pdbData.addressMap, frameTable);
        Log.info("moveToPdbSymbols cost[%d]", System.currentTimeMillis() - start);
        this.symbols = Symbol.appendDummySymbol(symbols, peName);
        this.files = sourceFiles.getMapping();
        this.cpu = cpu;
        this.debugId = debugId;
        this.pdbName = pdbName;
        this.parsed = true;
    }

    public PDBInfo() {
    }

    public String parseDebugId() {
        long start = System.currentTimeMillis();
        DebugInformation dbi = this.getDebugInformation();
        if (dbi == null) {
            Log.warn("The pdb file does not have debug info header.", new Object[0]);
            return null;
        }
        PDBInformation pi = this.getPdbInformation();
        Log.info("parseDebugId cost[%d]", System.currentTimeMillis() - start);
        return this.getDebugId(dbi, pi);
    }

    public DebugInformation getDebugInformation() {
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(3);
        if (buffer == null) {
            return null;
        }
        return DebugInformation.parse(buffer);
    }

    private PDBInformation getPdbInformation() {
        if (this.pi == null) {
            ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(1);
            this.pi = PDBInformation.parse(parseBuffer);
        }
        return this.pi;
    }

    private PSymbolTable getGlobalSymbols(DBIHeader dbiHeader) {
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(dbiHeader.getSymbolRecordsStream());
        return new PSymbolTable(buffer);
    }

    private DBIExtraStreams getExtraStreams() {
        DBIExtraStreams extra;
        if (this.dbiExtraStreams != null) {
            return this.dbiExtraStreams;
        }
        DebugInformation dbi = this.getDebugInformation();
        this.dbiExtraStreams = extra = new DBIExtraStreams(dbi);
        return extra;
    }

    public List<ImageSectionHeader> getSections() {
        int index = this.getExtraStreams().getSectionHeaders();
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(index);
        ArrayList<ImageSectionHeader> headers = new ArrayList<ImageSectionHeader>();
        while (parseBuffer.getBuffer().hasRemaining()) {
            headers.add(ImageSectionHeader.parse(parseBuffer));
        }
        return headers;
    }

    public Cpu getCpu(DebugInformation dbi) {
        MachineType mt = dbi.getMachineType();
        switch (mt) {
            case X86: {
                return Cpu.X86;
            }
            case Amd64: 
            case Ia64: {
                return Cpu.X86_64;
            }
        }
        return Cpu.Unknown;
    }

    public String getDebugId(DebugInformation dbi, PDBInformation pi) {
        String uuidStr = Hex.encodeHexString(pi.getGuid().getBytes()).toUpperCase();
        StringBuilder sb = new StringBuilder();
        sb.append(uuidStr);
        sb.append(Long.toHexString(dbi.getHeader().getAge()));
        return sb.toString().toUpperCase();
    }

    public String getStackInfo(PeObject pe) {
        return pe.processCfi();
    }

    public ParseBuffer getNamedStream(String name) {
        PDBInformation pdi = this.getPdbInformation();
        StreamNames names = pdi.getStreamNames();
        for (StreamName name1 : names.getNames()) {
            if (!name1.getName().equalsIgnoreCase(name)) continue;
            return StreamManager.getInstance().getParseBuffer(name1.getStreamId());
        }
        Log.error("Name[%s] stream not found!", name);
        return null;
    }

    public StringTable getStringTable() {
        ParseBuffer buffer = this.getNamedStream("/names");
        if (buffer != null) {
            return StringTable.parse(buffer);
        }
        return new StringTable();
    }

    public ModuleInfo getModuleInfo(Module module) {
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(module.getInfo().getStream());
        return ModuleInfo.parse(buffer, module);
    }

    public ParseBuffer getOldStream() {
        if (this.oldStream != null) {
            return this.oldStream;
        }
        DBIExtraStreams extra = this.getExtraStreams();
        this.oldStream = StreamManager.getInstance().getParseBuffer(extra.getFpo());
        if (this.oldStream == null) {
            this.oldStream = ParseBuffer.empty();
        }
        return this.oldStream;
    }

    public ParseBuffer getNewStream() {
        if (this.newStream != null) {
            return this.newStream;
        }
        DBIExtraStreams extra = this.getExtraStreams();
        this.newStream = StreamManager.getInstance().getParseBuffer(extra.getFramedata());
        if (this.newStream == null) {
            this.newStream = ParseBuffer.empty();
        }
        return this.newStream;
    }

    public FrameTable getFrameTable() {
        if (this.frameTable != null) {
            return this.frameTable;
        }
        this.frameTable = FrameTable.parse(this.getOldStream(), this.getNewStream());
        return this.frameTable;
    }

    public List<ImageSectionHeader> getOriginSections() {
        int index = this.getExtraStreams().getOriginalSectionHeaders();
        ParseBuffer parseBuffer = StreamManager.getInstance().getParseBuffer(index);
        if (parseBuffer == null) {
            return null;
        }
        ArrayList<ImageSectionHeader> headers = new ArrayList<ImageSectionHeader>();
        while (parseBuffer.getBuffer().hasRemaining()) {
            headers.add(ImageSectionHeader.parse(parseBuffer));
        }
        return headers;
    }

    public OMAPTable getOmapFromSrc() {
        int index = this.getExtraStreams().getOmapFromSrc();
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(index);
        if (buffer == null) {
            return null;
        }
        return OMAPTable.parse(buffer);
    }

    public OMAPTable getOmapToSrc() {
        int index = this.getExtraStreams().getOmapToSrc();
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(index);
        if (buffer == null) {
            return null;
        }
        return OMAPTable.parse(buffer);
    }

    public AddressMap getAddressMap() {
        List<ImageSectionHeader> sections = this.getSections();
        List<ImageSectionHeader> originSections = this.getOriginSections();
        if (originSections == null) {
            return new AddressMap(sections, null, null, null);
        }
        OMAPTable omapFromSrc = this.getOmapFromSrc();
        OMAPTable omapToSrc = this.getOmapToSrc();
        return new AddressMap(originSections, sections, omapFromSrc, omapToSrc);
    }

    public ItemInformation getTypeInformation() {
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(2);
        return ItemInformation.parse(buffer);
    }

    public ItemInformation getIdInformation() {
        ParseBuffer buffer = StreamManager.getInstance().getParseBuffer(4);
        return ItemInformation.parse(buffer);
    }

    public void display(BufferedWriter bufferedWriter, DumpSymType dumpSymType) {
        try {
            bufferedWriter.write(String.format("MODULE windows %s %s %s\n", new Object[]{this.cpu, this.debugId, this.pdbName}));
            if (this.codeId != null && !this.codeId.isEmpty()) {
                bufferedWriter.write(String.format("INFO CODE_ID %s %s\n", this.codeId, this.peName));
            }
            if (dumpSymType == DumpSymType.DumpAll) {
                for (int i = 0; i < this.files.size(); ++i) {
                    bufferedWriter.write(String.format("FILE %d %s\n", i, this.files.get(i)));
                }
                for (PDBSymbol sym : this.symbols.getMap().values()) {
                    sym.display(bufferedWriter);
                }
            }
            bufferedWriter.write(String.format("%s\n", this.stack));
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public PDBSymbols getSymbols() {
        return this.symbols;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getPeName() {
        return this.peName;
    }

    public String getCodeId() {
        return this.codeId;
    }

    public String getStack() {
        return this.stack;
    }

    public DBIExtraStreams getDbiExtraStreams() {
        return this.dbiExtraStreams;
    }

    public PDBInformation getPi() {
        return this.pi;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setSymbols(PDBSymbols symbols) {
        this.symbols = symbols;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    public void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    public void setPdbName(String pdbName) {
        this.pdbName = pdbName;
    }

    public void setPeName(String peName) {
        this.peName = peName;
    }

    public void setCodeId(String codeId) {
        this.codeId = codeId;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public void setDbiExtraStreams(DBIExtraStreams dbiExtraStreams) {
        this.dbiExtraStreams = dbiExtraStreams;
    }

    public void setPi(PDBInformation pi) {
        this.pi = pi;
    }

    public void setOldStream(ParseBuffer oldStream) {
        this.oldStream = oldStream;
    }

    public void setNewStream(ParseBuffer newStream) {
        this.newStream = newStream;
    }

    public void setFrameTable(FrameTable frameTable) {
        this.frameTable = frameTable;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDBInfo)) {
            return false;
        }
        PDBInfo other = (PDBInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isParsed() != other.isParsed()) {
            return false;
        }
        PDBSymbols this$symbols = this.getSymbols();
        PDBSymbols other$symbols = other.getSymbols();
        if (this$symbols == null ? other$symbols != null : !((Object)this$symbols).equals(other$symbols)) {
            return false;
        }
        List<String> this$files = this.getFiles();
        List<String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Cpu this$cpu = this.getCpu();
        Cpu other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)((Object)this$cpu)).equals((Object)other$cpu)) {
            return false;
        }
        String this$debugId = this.getDebugId();
        String other$debugId = other.getDebugId();
        if (this$debugId == null ? other$debugId != null : !this$debugId.equals(other$debugId)) {
            return false;
        }
        String this$pdbName = this.getPdbName();
        String other$pdbName = other.getPdbName();
        if (this$pdbName == null ? other$pdbName != null : !this$pdbName.equals(other$pdbName)) {
            return false;
        }
        String this$peName = this.getPeName();
        String other$peName = other.getPeName();
        if (this$peName == null ? other$peName != null : !this$peName.equals(other$peName)) {
            return false;
        }
        String this$codeId = this.getCodeId();
        String other$codeId = other.getCodeId();
        if (this$codeId == null ? other$codeId != null : !this$codeId.equals(other$codeId)) {
            return false;
        }
        String this$stack = this.getStack();
        String other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
            return false;
        }
        DBIExtraStreams this$dbiExtraStreams = this.getDbiExtraStreams();
        DBIExtraStreams other$dbiExtraStreams = other.getDbiExtraStreams();
        if (this$dbiExtraStreams == null ? other$dbiExtraStreams != null : !((Object)this$dbiExtraStreams).equals(other$dbiExtraStreams)) {
            return false;
        }
        PDBInformation this$pi = this.getPi();
        PDBInformation other$pi = other.getPi();
        if (this$pi == null ? other$pi != null : !((Object)this$pi).equals(other$pi)) {
            return false;
        }
        ParseBuffer this$oldStream = this.getOldStream();
        ParseBuffer other$oldStream = other.getOldStream();
        if (this$oldStream == null ? other$oldStream != null : !((Object)this$oldStream).equals(other$oldStream)) {
            return false;
        }
        ParseBuffer this$newStream = this.getNewStream();
        ParseBuffer other$newStream = other.getNewStream();
        if (this$newStream == null ? other$newStream != null : !((Object)this$newStream).equals(other$newStream)) {
            return false;
        }
        FrameTable this$frameTable = this.getFrameTable();
        FrameTable other$frameTable = other.getFrameTable();
        return !(this$frameTable == null ? other$frameTable != null : !((Object)this$frameTable).equals(other$frameTable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PDBInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isParsed() ? 79 : 97);
        PDBSymbols $symbols = this.getSymbols();
        result = result * 59 + ($symbols == null ? 43 : ((Object)$symbols).hashCode());
        List<String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Cpu $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)((Object)$cpu)).hashCode());
        String $debugId = this.getDebugId();
        result = result * 59 + ($debugId == null ? 43 : $debugId.hashCode());
        String $pdbName = this.getPdbName();
        result = result * 59 + ($pdbName == null ? 43 : $pdbName.hashCode());
        String $peName = this.getPeName();
        result = result * 59 + ($peName == null ? 43 : $peName.hashCode());
        String $codeId = this.getCodeId();
        result = result * 59 + ($codeId == null ? 43 : $codeId.hashCode());
        String $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
        DBIExtraStreams $dbiExtraStreams = this.getDbiExtraStreams();
        result = result * 59 + ($dbiExtraStreams == null ? 43 : ((Object)$dbiExtraStreams).hashCode());
        PDBInformation $pi = this.getPi();
        result = result * 59 + ($pi == null ? 43 : ((Object)$pi).hashCode());
        ParseBuffer $oldStream = this.getOldStream();
        result = result * 59 + ($oldStream == null ? 43 : ((Object)$oldStream).hashCode());
        ParseBuffer $newStream = this.getNewStream();
        result = result * 59 + ($newStream == null ? 43 : ((Object)$newStream).hashCode());
        FrameTable $frameTable = this.getFrameTable();
        result = result * 59 + ($frameTable == null ? 43 : ((Object)$frameTable).hashCode());
        return result;
    }

    public String toString() {
        return "PDBInfo(symbols=" + this.getSymbols() + ", files=" + this.getFiles() + ", cpu=" + (Object)((Object)this.getCpu()) + ", debugId=" + this.getDebugId() + ", pdbName=" + this.getPdbName() + ", peName=" + this.getPeName() + ", codeId=" + this.getCodeId() + ", stack=" + this.getStack() + ", dbiExtraStreams=" + this.getDbiExtraStreams() + ", pi=" + this.getPi() + ", oldStream=" + this.getOldStream() + ", newStream=" + this.getNewStream() + ", frameTable=" + this.getFrameTable() + ", parsed=" + this.isParsed() + ")";
    }
}

