/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.Collector;
import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.dbi.ModuleIter;
import com.uqm.crashsight.symtabtool.pdb.module.ModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.PSymbolTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceFiles;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RegisterRelativeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SelectedSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SeparatedCodeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolData;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolIter;

public class PDBData {
    AddressMap addressMap;

    public PDBData(AddressMap addressMap) {
        this.addressMap = addressMap;
    }

    public void handleSymbol(SymbolData symbolData, Collector collector, SourceLineCollector lines, ModuleInfo moduleInfo) {
        if (symbolData.getProcedure() != null) {
            ProcedureSymbol procedureSymbol = symbolData.getProcedure();
            Rva rva = procedureSymbol.getOffset().toRva(this.addressMap);
            if (rva == null || rva.isNone()) {
                return;
            }
            collector.addProcedureSymbol(procedureSymbol, new BlockInfo(rva.getAddress(), procedureSymbol.getOffset(), procedureSymbol.getLen()), lines);
        } else if (symbolData.getBlock() != null) {
            BlockSymbol block = symbolData.getBlock();
            this.addBlock(moduleInfo, block, collector, lines);
        } else if (symbolData.getSeparatedCode() != null) {
            SeparatedCodeSymbol block = symbolData.getSeparatedCode();
            this.addSepcode(block, collector, lines);
        } else if (symbolData.getRegisterRelative() != null) {
            RegisterRelativeSymbol regRel = symbolData.getRegisterRelative();
            collector.addRegRel(regRel);
        } else if (symbolData.getScopeEnd() != null) {
            collector.closeProcedure();
        }
    }

    public void collectPublicSymbols(PSymbolTable globals, Collector collector) {
        PSymbol symbol;
        SymbolIter symbols = globals.iter();
        while ((symbol = symbols.next()) != null) {
            PublicSymbol publicSymbol;
            SymbolData symbolData = symbol.parse();
            if (symbolData == null || symbolData.isNone() || symbolData.getPublic_() == null || (publicSymbol = symbolData.getPublic_()).getOffset().getSection() > 7) continue;
            collector.addPublicSymbol(publicSymbol, this.addressMap);
        }
    }

    public void collectFunctions(PDBInfo PDBInfo2, DebugInformation dbi, Collector collector, SourceFiles sourceFiles) {
        Module module;
        ModuleIter moduleIter = dbi.getModules();
        while ((module = moduleIter.next()) != null) {
            PSymbol symbol;
            ModuleInfo moduleInfo = PDBInfo2.getModuleInfo(module);
            if (moduleInfo == null) continue;
            if (moduleInfo.getLinesSize() + moduleInfo.getSymbolsSize() > (long)moduleInfo.getBuffer().getBuffer().limit()) break;
            LineProgram lineProgram = moduleInfo.getLineProgram();
            SourceLineCollector lines = new SourceLineCollector(this.addressMap, sourceFiles, lineProgram);
            SymbolIter symbols = moduleInfo.getSymbols();
            while ((symbol = symbols.next()) != null) {
                SymbolData symbolData = symbol.parse();
                if (symbolData == null) continue;
                this.handleSymbol(symbolData, collector, lines, moduleInfo);
            }
        }
    }

    public void addBlock(ModuleInfo moduleInfo, BlockSymbol block, Collector collector, SourceLineCollector lines) {
        PSymbol parent = moduleInfo.symbolsAt(block.getParent()).next();
        if (parent == null) {
            return;
        }
        SymbolData parentSymbolData = parent.parse();
        if (parentSymbolData == null) {
            return;
        }
        ProcedureSymbol parentProcedureSymbol = parentSymbolData.getProcedure();
        if (parentProcedureSymbol == null) {
            return;
        }
        Rva blockRva = block.getOffset().toRva(this.addressMap);
        if (blockRva == null) {
            return;
        }
        Rva parentRva = parentProcedureSymbol.getOffset().toRva(this.addressMap);
        if (parentRva == null) {
            return;
        }
        if (blockRva.getAddress() < parentRva.getAddress() || blockRva.getAddress() > parentRva.getAddress() + parentProcedureSymbol.getLen()) {
            collector.addProcedureSymbol(parentProcedureSymbol, new BlockInfo(blockRva.getAddress(), block.getOffset(), block.getLen()), lines);
        }
    }

    public void addSepcode(SeparatedCodeSymbol block, Collector collector, SourceLineCollector lines) {
        Rva blockRva = block.getOffset().toRva(this.addressMap);
        if (blockRva == null) {
            return;
        }
        Rva parentRva = block.getParentOffset().toRva(this.addressMap);
        if (parentRva == null) {
            return;
        }
        SelectedSymbol parent = collector.getSymbolAt(parentRva.getAddress());
        if (parent != null && (blockRva.getAddress() < parentRva.getAddress() || blockRva.getAddress() > parentRva.getAddress() + parent.getLen())) {
            Lines source2 = lines.collectSourceLines(block.getOffset(), block.getLen());
            SelectedSymbol sym = new SelectedSymbol(parent.getName(), parent.getTypeIndex(), parent.isPublic(), false, block.getOffset(), parent.getSymOffset(), block.getLen(), parent.getParameterSize(), source2, parent.getEbp(), parent.getId());
            collector.addSymbol(sym, new BlockInfo(blockRva.getAddress(), block.getOffset(), block.getLen()));
        }
    }
}

