/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DBISectionContribution {
    PdbInternalSectionOffset offset;
    long size;
    long characteristics;
    int module;
    long dataCrc;
    long relocCrc;

    public static DBISectionContribution parse(ParseBuffer buffer) {
        DBISectionContribution self = new DBISectionContribution();
        int section = buffer.readU16();
        int padding1 = buffer.readU16();
        long offset = buffer.readU32();
        self.size = buffer.readU32();
        self.characteristics = buffer.readU32();
        self.module = buffer.readU16();
        int padding2 = buffer.readU16();
        self.dataCrc = buffer.readU32();
        self.relocCrc = buffer.readU32();
        self.offset = new PdbInternalSectionOffset(offset, section);
        return self;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public long getCharacteristics() {
        return this.characteristics;
    }

    public int getModule() {
        return this.module;
    }

    public long getDataCrc() {
        return this.dataCrc;
    }

    public long getRelocCrc() {
        return this.relocCrc;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setCharacteristics(long characteristics) {
        this.characteristics = characteristics;
    }

    public void setModule(int module) {
        this.module = module;
    }

    public void setDataCrc(long dataCrc) {
        this.dataCrc = dataCrc;
    }

    public void setRelocCrc(long relocCrc) {
        this.relocCrc = relocCrc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBISectionContribution)) {
            return false;
        }
        DBISectionContribution other = (DBISectionContribution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getCharacteristics() != other.getCharacteristics()) {
            return false;
        }
        if (this.getModule() != other.getModule()) {
            return false;
        }
        if (this.getDataCrc() != other.getDataCrc()) {
            return false;
        }
        if (this.getRelocCrc() != other.getRelocCrc()) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBISectionContribution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $characteristics = this.getCharacteristics();
        result = result * 59 + (int)($characteristics >>> 32 ^ $characteristics);
        result = result * 59 + this.getModule();
        long $dataCrc = this.getDataCrc();
        result = result * 59 + (int)($dataCrc >>> 32 ^ $dataCrc);
        long $relocCrc = this.getRelocCrc();
        result = result * 59 + (int)($relocCrc >>> 32 ^ $relocCrc);
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        return result;
    }

    public String toString() {
        return "DBISectionContribution(offset=" + this.getOffset() + ", size=" + this.getSize() + ", characteristics=" + this.getCharacteristics() + ", module=" + this.getModule() + ", dataCrc=" + this.getDataCrc() + ", relocCrc=" + this.getRelocCrc() + ")";
    }
}

