/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.PDBContributions;
import com.uqm.crashsight.symtabtool.pdb.PDBSections;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RegisterRelativeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RvaSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.SelectedSymbol;

public class Collector {
    Cpu cpu;
    RvaSymbols symbols;
    PDBSections pdbSections;
    PDBContributions pdbContributions;

    public Collector(Cpu cpu, RvaSymbols symbols, PDBSections pdbSections, PDBContributions pdbContributions) {
        this.cpu = cpu;
        this.symbols = symbols;
        this.pdbSections = pdbSections;
        this.pdbContributions = pdbContributions;
    }

    public void addPublicSymbol(PublicSymbol symbol, AddressMap addressMap) {
        this.symbols.addPublicSymbol(symbol, this.pdbSections, this.pdbContributions, addressMap);
    }

    public void addProcedureSymbol(ProcedureSymbol symbol, BlockInfo info, SourceLineCollector lines) {
        this.symbols.addProcedureSymbol(lines, symbol, info);
    }

    public SelectedSymbol getSymbolAt(long rva) {
        return this.symbols.getSymbolAt(rva);
    }

    public void addSymbol(SelectedSymbol symbol, BlockInfo info) {
        this.symbols.addSymbol(symbol, info);
    }

    public void addRegRel(RegisterRelativeSymbol symbol) {
        if (this.cpu == Cpu.X86 && symbol.getRegister() == 22 && symbol.getOffset() > 0) {
            this.symbols.addEbp(symbol);
        }
    }

    public void closeProcedure() {
        this.symbols.closeProcedure();
    }
}

