/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class MachSymtabParser {
    private static final long N_SECT = 14L;
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setEndian(long endian) {
        this.endian = endian;
    }

    public MachSymtabParser(String fileName, long fileFormat, long endian) {
        this.setFileName(fileName);
        this.setFileFormat(fileFormat);
        this.setEndian(endian);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private long parseSymbolType(long type) {
        return type & 0xEL;
    }

    private Vector<MachSymtabEntry> parseSubroutineTable(long entryNumber) {
        Vector<MachSymtabEntry> subroutineTable = new Vector<MachSymtabEntry>();
        int i = 0;
        while ((long)i < entryNumber) {
            MachSymtabEntry machSymtabEntry = new MachSymtabEntry();
            if (!machSymtabEntry.parse(this.binaryFileReader, this.fileFormat)) {
                Log.error("MachSymtab \u7b26\u53f7\u89e3\u6790\u9519\u8bef\uff01", new Object[0]);
                return null;
            }
            if (14L == this.parseSymbolType(machSymtabEntry.getType())) {
                subroutineTable.add(machSymtabEntry);
            }
            ++i;
        }
        return subroutineTable;
    }

    public Vector<MachSymtabEntry> getSubroutineTable(long sectionOffset, long entryNumber) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(sectionOffset)) {
            this.close();
            return null;
        }
        Vector<MachSymtabEntry> subroutineTable = this.parseSubroutineTable(entryNumber);
        this.close();
        MachSymtabParser.sortSubroutineTable(subroutineTable);
        return subroutineTable;
    }

    private static void sortSubroutineTable(Vector<MachSymtabEntry> subroutineTable) {
        subroutineTable.sort((a, b) -> {
            int cmpValue = Long.compare(a.getValue(), b.getValue());
            if (cmpValue == 0) {
                return Long.compare(a.getSectionIndex(), b.getSectionIndex());
            }
            return cmpValue;
        });
    }

    public static class MachSymtabEntry {
        private long name = 0L;
        private long type = 0L;
        private long sectionIndex = 0L;
        private long description = 0L;
        private long value = 0L;

        public long getName() {
            return this.name;
        }

        public long getType() {
            return this.type;
        }

        public long getSectionIndex() {
            return this.sectionIndex;
        }

        public long getDescription() {
            return this.description;
        }

        public long getValue() {
            return this.value;
        }

        public boolean parse(BinaryFileReader binaryFileReader, long fileFormat) {
            block6: {
                try {
                    boolean bl;
                    this.name = binaryFileReader.readUInt();
                    this.type = binaryFileReader.readUByte();
                    this.sectionIndex = binaryFileReader.readUByte();
                    if (this.sectionIndex > 48L) {
                        bl = true;
                    }
                    if (this.sectionIndex == 0L) {
                        bl = true;
                    }
                    this.description = binaryFileReader.readUShort();
                    if (32L == fileFormat) {
                        this.value = binaryFileReader.readUInt();
                        break block6;
                    }
                    if (64L == fileFormat) {
                        this.value = binaryFileReader.readULong();
                        break block6;
                    }
                    Log.error("MachSymtabEntry \u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01", new Object[0]);
                    return false;
                }
                catch (IOException e) {
                    Log.error(e);
                    return false;
                }
            }
            return true;
        }
    }
}

