/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class MachSegmentParser {
    public static final String TEXT_SEGMENT = "__TEXT";
    private long fileFormat = 0L;
    private BinaryFileReader binaryFileReader = null;

    public void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public MachSegmentParser(BinaryFileReader binaryFileReader, long fileFomat) {
        this.setBinaryFileReader(binaryFileReader);
        this.setFileFormat(fileFomat);
    }

    public Vector<Section> getSectionInfoTable(long sectionNumber) {
        Vector<Section> sectionInfoTable = new Vector<Section>();
        int i = 0;
        while ((long)i < sectionNumber) {
            MachSection machSection = new MachSection();
            Section sectionInfo = new Section();
            sectionInfo.setHeaderOffset(this.binaryFileReader.getOffset());
            if (!machSection.parse(this.binaryFileReader, this.fileFormat)) {
                Log.error("MachSegment \u8282\u533a\u89e3\u6790\u9519\u8bef\uff01", new Object[0]);
            }
            sectionInfo.setName(machSection.getSectionName());
            sectionInfo.setAddress(machSection.getAddr());
            sectionInfo.setOffset(machSection.getOffset());
            sectionInfo.setSize(machSection.getSize());
            sectionInfoTable.add(sectionInfo);
            sectionInfo.setOtherValue(machSection.getSectionName(), machSection.getSegmentName(), (int)machSection.getAlign(), (int)machSection.getRelocationOffset(), (int)machSection.getRelocationEntryNumber(), (int)machSection.getFlags(), (int)machSection.getReserved1(), (int)machSection.getReserved2(), (int)machSection.getOmit());
            sectionInfo.setOrder(i);
            ++i;
        }
        return sectionInfoTable;
    }

    public static String byteArraytoString(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ba.length && 0 != ba[i]; ++i) {
            sb.append((char)ba[i]);
        }
        return sb.toString();
    }

    public static class MachSection {
        private String sectionName = null;
        private String segmentName = null;
        private long addr = 0L;
        private long size = 0L;
        private long offset = 0L;
        private long align = 0L;
        private long relocationOffset = 0L;
        private long relocationEntryNumber = 0L;
        private long flags = 0L;
        private long reserved1 = 0L;
        private long reserved2 = 0L;
        private long omit = 0L;

        public String getSectionName() {
            return this.sectionName;
        }

        public String getSegmentName() {
            return this.segmentName;
        }

        public long getAddr() {
            return this.addr;
        }

        public long getSize() {
            return this.size;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getAlign() {
            return this.align;
        }

        public long getRelocationOffset() {
            return this.relocationOffset;
        }

        public long getRelocationEntryNumber() {
            return this.relocationEntryNumber;
        }

        public long getFlags() {
            return this.flags;
        }

        public long getReserved1() {
            return this.reserved1;
        }

        public long getReserved2() {
            return this.reserved2;
        }

        public long getOmit() {
            return this.omit;
        }

        private String parseName(BinaryFileReader binaryFileReader) {
            byte[] array = new byte[16];
            if (!binaryFileReader.readByteArray(array)) {
                return null;
            }
            return MachSegmentParser.byteArraytoString(array);
        }

        public boolean parse(BinaryFileReader binaryFileReader, long fileFormat) {
            try {
                this.sectionName = this.parseName(binaryFileReader);
                if (null == this.sectionName) {
                    return false;
                }
                this.segmentName = this.parseName(binaryFileReader);
                if (null == this.sectionName) {
                    return false;
                }
                if (32L == fileFormat) {
                    this.addr = binaryFileReader.readUInt();
                    this.size = binaryFileReader.readUInt();
                } else if (64L == fileFormat) {
                    this.addr = binaryFileReader.readULong();
                    this.size = binaryFileReader.readULong();
                } else {
                    Log.error("File format error", new Object[0]);
                    return false;
                }
                this.offset = binaryFileReader.readUInt();
                this.align = binaryFileReader.readUInt();
                this.relocationOffset = binaryFileReader.readUInt();
                this.relocationEntryNumber = binaryFileReader.readUInt();
                this.flags = binaryFileReader.readUInt();
                this.reserved1 = binaryFileReader.readUInt();
                this.reserved2 = binaryFileReader.readUInt();
                if (64L == fileFormat) {
                    this.omit = binaryFileReader.readUInt();
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }
    }
}

