/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DwarfInfoBean;
import com.uqm.crashsight.symtabtool.dwarf.DwarfParser;
import com.uqm.crashsight.symtabtool.mach.MachCommandParser;
import com.uqm.crashsight.symtabtool.mach.MachHeaderParser;
import com.uqm.crashsight.symtabtool.mach.MachStringParser;
import com.uqm.crashsight.symtabtool.mach.MachSymtabParser;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import com.uqm.crashsight.symtabtool.symtab.SymtabMerger;
import java.util.HashMap;
import java.util.Vector;

public class MachParser {
    public static final long INVALID_ADDRESS = -1L;
    public static final long FILE_FORMAT_INVALID = 0L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    public static final String TEXT_SECTION = "__text";
    public static final String DEBUG_INFO_SECTION = "__debug_info";
    public static final String DEBUG_ABBREV_SECTION = "__debug_abbrev";
    public static final String DEBUG_LINE_SECTION = "__debug_line";
    public static final String DEBUG_RANGES_SECTION = "__debug_ranges";
    public static final String DEBUG_STR_SECTION = "__debug_str";
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private MachHeaderParser header = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private byte[] uuid = null;
    private long vmAddr = -1L;
    private HashMap<String, Section> sectionTable = null;
    private Vector<Subroutine> subroutineTable = null;
    private SymbolTable symbolTable = null;

    public String getFileName() {
        return this.fileName;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    public String getArch() {
        return this.header.getArch();
    }

    public static String getArch(String fileName, long offset) {
        MachParser machParser = new MachParser(fileName);
        Log.info("Begin to parse file: %s", fileName);
        if (!machParser.openFile()) {
            return null;
        }
        if (!machParser.binaryFileReader.skip(offset)) {
            return null;
        }
        if (!machParser.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return null;
        }
        Log.info("Architecture: %s", machParser.header.getArch());
        String arch = machParser.header.getArch();
        machParser.closeFile();
        return arch;
    }

    public String getUuid() {
        return Utils.byteArrayToHexString(this.uuid);
    }

    public static String getUuid(String fileName, long offset) {
        MachParser machParser = new MachParser(fileName);
        Log.info("Begin to parse file: %s", fileName);
        if (!machParser.openFile()) {
            return null;
        }
        if (!machParser.binaryFileReader.skip(offset)) {
            return null;
        }
        if (!machParser.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return null;
        }
        Log.info("Architecture: %s", machParser.header.getArch());
        if (!machParser.parseCommand(offset)) {
            Log.error("Failed to parse command", new Object[0]);
            return null;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        String uuid = machParser.getUuid();
        machParser.closeFile();
        return uuid;
    }

    public long getVmAddr() {
        return this.vmAddr;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public HashMap<String, Section> getSectionTable() {
        return this.sectionTable;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    private void setEndian(long endian) {
        this.endian = endian;
    }

    private void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    private void closeFile() {
        if (null != this.binaryFileReader) {
            this.binaryFileReader.close();
            this.binaryFileReader = null;
        }
    }

    public void close() {
        this.closeFile();
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.closeFile();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private MachParser(String fileName) {
        this.setFileName(fileName);
    }

    private boolean parseHeaderInfo() {
        this.header = new MachHeaderParser();
        if (!this.header.parse(this.binaryFileReader)) {
            return false;
        }
        this.setFileFormat(this.header.getFileFormat());
        this.setEndian(this.header.getEndian());
        return true;
    }

    private boolean parseSectionInfoTable(Vector<Section> sectionInfos, long offset) {
        if (null == sectionInfos || sectionInfos.isEmpty()) {
            return false;
        }
        this.sectionTable = new HashMap();
        long localOffset = 0L;
        boolean fisrtPart = true;
        for (Section sectionInfo : sectionInfos) {
            if (sectionInfo.getSegmentName().equals("__DWARF")) {
                if (fisrtPart) {
                    fisrtPart = false;
                    localOffset = sectionInfo.getOffset();
                }
                sectionInfo.setOffset(localOffset + offset);
                localOffset += sectionInfo.getSize();
            } else {
                sectionInfo.setOffset(offset + sectionInfo.getOffset());
            }
            this.sectionTable.put(sectionInfo.getName(), sectionInfo);
        }
        return true;
    }

    private boolean parseSubroutineTable(long offset, MachCommandParser.MachSymtabCommand machSymtabCommand, Vector<Section> sectionInfos) {
        long symtabSize;
        long strtabOffset = machSymtabCommand.getStrtabOffset() + offset;
        long strtabSize = machSymtabCommand.getStrtabSize();
        MachStringParser machStringParser = new MachStringParser(this.fileName, strtabOffset, strtabSize);
        MachSymtabParser machSymtab = new MachSymtabParser(this.fileName, this.fileFormat, this.endian);
        long symtabOffset = machSymtabCommand.getSymtabOffset() + offset;
        Vector<MachSymtabParser.MachSymtabEntry> machSymtabEntries = machSymtab.getSubroutineTable(symtabOffset, symtabSize = machSymtabCommand.getEntryNumber());
        if (null == machSymtabEntries) {
            return false;
        }
        this.fillSymtab(machSymtabEntries, sectionInfos, machStringParser);
        return true;
    }

    private void fillSymtab(Vector<MachSymtabParser.MachSymtabEntry> machSymtabEntries, Vector<Section> sectionTable, MachStringParser machStringParser) {
        this.subroutineTable = new Vector();
        if (machSymtabEntries.isEmpty()) {
            return;
        }
        Section section = null;
        for (int i = 0; i < machSymtabEntries.size() - 1; ++i) {
            MachSymtabParser.MachSymtabEntry machSymtabEntry = machSymtabEntries.get(i);
            int index = (int)machSymtabEntry.getSectionIndex() - 1;
            if (index >= sectionTable.size()) {
                Log.warn("MACH file may be corrupted for table index '%d' is out of bound '%d'.", index, sectionTable.size());
                continue;
            }
            if (index < 0) {
                Log.warn("MACH file may be corrupted for table index '%d' is out of bound '%d'.", index, sectionTable.size());
                continue;
            }
            section = sectionTable.get(index);
            if (machSymtabEntry.getValue() < section.getAddress()) continue;
            Subroutine subroutine = new Subroutine();
            subroutine.setLowPc(machSymtabEntry.getValue());
            subroutine.setName(machStringParser.getString(machSymtabEntry.getName()));
            long highPc = -1L;
            highPc = machSymtabEntry.getSectionIndex() != machSymtabEntries.get(i + 1).getSectionIndex() ? section.getAddress() + section.getSize() : machSymtabEntries.get(i + 1).getValue();
            subroutine.setHighPc(highPc);
            this.subroutineTable.add(subroutine);
            if (subroutine.getName() == null || !subroutine.getName().equalsIgnoreCase("__ZNK6UClass18FindFunctionByNameE5FNameN17EIncludeSuperFlag4TypeE")) continue;
            boolean bl = true;
        }
        MachSymtabParser.MachSymtabEntry machSymtabEntry = machSymtabEntries.lastElement();
        int index = (int)machSymtabEntry.getSectionIndex() - 1;
        if (index >= sectionTable.size()) {
            Log.warn("MACH file may be corrupted for table index '%d' is out of bound '%d'.", index, sectionTable.size());
            return;
        }
        section = sectionTable.get(index);
        long highPc = section.getAddress() + section.getSize();
        Subroutine subroutine = new Subroutine();
        subroutine.setName(machStringParser.getString(machSymtabEntry.getName()));
        subroutine.setLowPc(machSymtabEntry.getValue());
        subroutine.setHighPc(highPc);
        this.subroutineTable.add(subroutine);
    }

    private boolean parseCommand(long offset) {
        MachCommandParser machCommand = MachCommandParser.create(this.binaryFileReader, this.fileFormat, this.header.getCommandNumber());
        if (null == machCommand) {
            return false;
        }
        this.uuid = machCommand.getUuid();
        this.vmAddr = machCommand.getVmAddr();
        Vector<Section> sectionInfos = machCommand.getSectionInfoTable();
        if (!this.parseSectionInfoTable(sectionInfos, offset)) {
            Log.error("Failed to parse section info", new Object[0]);
            return false;
        }
        if (!this.parseSubroutineTable(offset, machCommand.getMachSymtabCommand(), sectionInfos)) {
            Log.error("Failed to parse subroutine table", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean parseCommandForRebuild(long offset) {
        MachCommandParser machCommand = MachCommandParser.create(this.binaryFileReader, this.fileFormat, this.header.getCommandNumber());
        if (null == machCommand) {
            return false;
        }
        this.uuid = machCommand.getUuid();
        this.vmAddr = machCommand.getVmAddr();
        Vector<Section> sectionInfos = machCommand.getSectionInfoTable();
        if (!this.parseSectionInfoTable(sectionInfos, offset)) {
            Log.error("Failed to parse section info", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean parse(long offset) {
        Log.info("Begin to parse file: %s", this.fileName);
        if (!this.openFile()) {
            return false;
        }
        if (!this.binaryFileReader.skip(offset)) {
            return false;
        }
        if (!this.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return false;
        }
        Log.info("Architecture: %s", this.header.getArch());
        if (!this.parseCommand(offset)) {
            Log.error("Failed to parse command", new Object[0]);
            return false;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        Log.printBusyingLog("Begin to extract symbol table..", 256L);
        DwarfInfoBean dwarfInfoBean = this.getDwarfInfoBean();
        if (null == dwarfInfoBean) {
            Log.warn("Failed to get DWARF info!", new Object[0]);
        }
        SymbolTable symbolTable = null;
        if (dwarfInfoBean != null) {
            symbolTable = DwarfParser.getSymbolTable(this.subroutineTable, dwarfInfoBean);
            if (null == symbolTable) {
                Log.error("Failed to extract symbol table from DWARF section!", new Object[0]);
                return false;
            }
        } else {
            symbolTable = new SymbolTable();
        }
        if (null == (symbolTable = SymtabMerger.merge(this.subroutineTable, symbolTable, "Mach-O"))) {
            Log.error("Failed to merge symbol table!", new Object[0]);
            return false;
        }
        this.setSymbolTable(symbolTable);
        Log.info("Successfully to extract symbol table!", new Object[0]);
        return true;
    }

    public boolean parseForRebuild(long offset) {
        Log.info("Begin to parse file: %s", this.fileName);
        if (!this.openFile()) {
            return false;
        }
        if (!this.binaryFileReader.skip(offset)) {
            return false;
        }
        if (!this.parseHeaderInfo()) {
            Log.error("Failed to parse header", new Object[0]);
            return false;
        }
        Log.info("Architecture: %s", this.header.getArch());
        if (!this.parseCommandForRebuild(offset)) {
            Log.error("Failed to parse command", new Object[0]);
            return false;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        return true;
    }

    private DwarfInfoBean getDwarfInfoBean() {
        Section debugStrSection;
        DwarfInfoBean dwarfInfoBean = new DwarfInfoBean();
        dwarfInfoBean.setFileName(this.fileName);
        Section debugAbbrevSection = this.sectionTable.get(DEBUG_ABBREV_SECTION);
        if (null == debugAbbrevSection) {
            Log.error("No debug_abbrev section in the elf file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugAbbrevOffset(debugAbbrevSection.getOffset());
        dwarfInfoBean.setDebugAbbrevSize(debugAbbrevSection.getSize());
        Section debugInfoSection = this.sectionTable.get(DEBUG_INFO_SECTION);
        if (null == debugInfoSection) {
            Log.error("No debug_info section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugInfoOffset(debugInfoSection.getOffset());
        dwarfInfoBean.setDebugInfoSize(debugInfoSection.getSize());
        Section debugLineSection = this.sectionTable.get(DEBUG_LINE_SECTION);
        if (null == debugLineSection) {
            Log.error("No debug_line section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugLineOffset(debugLineSection.getOffset());
        dwarfInfoBean.setDebugLineSize(debugLineSection.getSize());
        Section debugRangesSection = this.sectionTable.get(DEBUG_RANGES_SECTION);
        if (null != debugRangesSection) {
            dwarfInfoBean.setDebugRangesOffset(debugRangesSection.getOffset());
            dwarfInfoBean.setDebugRangesSize(debugRangesSection.getSize());
        }
        if (null == (debugStrSection = this.sectionTable.get(DEBUG_STR_SECTION))) {
            Log.error("No debug_str section in the file", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugStrOffset(debugStrSection.getOffset());
        dwarfInfoBean.setDebugStrSize(debugStrSection.getSize());
        return dwarfInfoBean;
    }

    public static MachParser create(String fileName, long offset, boolean isRebuild) {
        MachParser machParser = new MachParser(fileName);
        if (isRebuild) {
            if (!machParser.parseForRebuild(offset)) {
                machParser.closeFile();
                return null;
            }
        } else if (!machParser.parse(offset)) {
            machParser.closeFile();
            return null;
        }
        return machParser;
    }

    public static boolean isMach(String fileName) {
        return MachHeaderParser.isMach(fileName);
    }
}

