/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class MachFatHeaderParser {
    public static final long MAGIC_MACH_FAT_LE = 3405691582L;
    public static final long MAGIC_MACH_FAT_BE = 3199925962L;
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private long endian = 0L;
    private long magic = 0L;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public MachFatHeaderParser(String fileName) {
        this.setFileName(fileName);
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private boolean parseMagic() {
        if (3405691582L == this.magic) {
            this.endian = BinaryFileReader.LITTLE_ENDIAN;
        } else if (3199925962L == this.magic) {
            this.endian = BinaryFileReader.BIG_ENDIAN;
        } else {
            return false;
        }
        this.binaryFileReader.setEndian(this.endian);
        return true;
    }

    private Vector<Long> parseHeader() {
        try {
            Vector<Long> offsetTable = new Vector<Long>();
            this.magic = this.binaryFileReader.readUInt();
            if (!this.parseMagic()) {
                offsetTable.add(new Long(0L));
                return offsetTable;
            }
            long archNumber = this.binaryFileReader.readUInt();
            int i = 0;
            while ((long)i < archNumber) {
                long cpuType = this.binaryFileReader.readUInt();
                long cpuSubType = this.binaryFileReader.readUInt();
                long offset = this.binaryFileReader.readUInt();
                long size = this.binaryFileReader.readUInt();
                long align = this.binaryFileReader.readUInt();
                offsetTable.add(new Long(offset));
                ++i;
            }
            return offsetTable;
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    public Vector<Long> getOffsetTable() {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        return this.parseHeader();
    }
}

