/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.util;

import com.amazonaws.services.s3.model.PutObjectResult;
import com.qcloud.cos.model.UploadResult;
import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.codec.digest.DigestUtils;

public class SymbolFileInfo {
    private String cosPath = "";
    private String sourceFileName = "";
    private long zippedFileSize = 0L;
    private int symType = 0;
    private UploadResult uploadResult;
    private PutObjectResult putUploadResult;
    private String fileObjectKey;
    private String md5;

    public SymbolFileInfo(String cosPath, File symbolFile, String symbolType, UploadResult uploadResult, String fileObjectKey) {
        this.cosPath = cosPath;
        this.sourceFileName = symbolFile.getName();
        this.symType = Integer.valueOf(symbolType);
        this.zippedFileSize = symbolFile.length();
        this.uploadResult = uploadResult;
        this.fileObjectKey = fileObjectKey;
        try {
            this.md5 = DigestUtils.md5Hex(new FileInputStream(symbolFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SymbolFileInfo(String cosPath, File symbolFile, String symbolType, PutObjectResult uploadResult, String fileObjectKey) {
        this.cosPath = cosPath;
        this.sourceFileName = symbolFile.getName();
        this.symType = Integer.valueOf(symbolType);
        this.zippedFileSize = symbolFile.length();
        this.putUploadResult = uploadResult;
        this.fileObjectKey = fileObjectKey;
    }

    public SymbolFileInfo(String cosPath, String fileName, Long length, String symbolType, String md5) {
        this.cosPath = cosPath;
        this.sourceFileName = fileName;
        this.symType = Integer.parseInt(symbolType);
        this.zippedFileSize = length;
        this.md5 = md5;
        this.fileObjectKey = cosPath.substring(cosPath.lastIndexOf("/") + 1);
    }

    public String getFileObjectKey() {
        return this.fileObjectKey;
    }
}

