/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.Upload;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.generic.util.DESUtil;
import com.uqm.crashsight.symtabtool.generic.util.ErrorInfo;
import com.uqm.crashsight.symtabtool.generic.util.NotifyParam;
import com.uqm.crashsight.symtabtool.generic.util.SymbolDuplicateRequestBean;
import com.uqm.crashsight.symtabtool.generic.util.SymbolFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;

public class CosUploader {
    private COSClient cosClient = null;
    private String cosAccessKey = "";
    private String cosSecreteKey = "";
    private String cosSessionToken = "";
    private String cosRegion = "";
    private int platformId = 1;
    private String bucketName = "";
    private String fileObjectKey = "";
    private TransferManager transferManager = null;
    private String appId = "";
    private String appKey = "";
    private String bundleId = "";
    private String appVersion = "";
    private static final String NOTIFY_URL_SUFFIX = "/symbolTool/upload";
    private static final String COS_TOKEN_URL_SUFFIX = "/symbolTool/getSymbolTokenInfo";
    private static final String REPORT_ERROR_URL_SUFFIX = "/symbolTool/saveErrorUploadMessage";
    private static final String LIST_BY_MD5 = "/symbolTool/listByMd5";
    private Vector<SymbolFileInfo> uploadedSymFiles = new Vector();
    private String cosProxyHost = null;
    private static final int MAX_NOTIFY_FILE_LIMIT = 5;
    private String uploadUrl;
    private String cosInnerDomain;
    private AmazonS3 s3client = null;
    private boolean cosInit;
    private ErrorInfo errorInfo = new ErrorInfo();
    private String platform;

    public CosUploader(String appId, String appKey, String uploadUrl, String bundleId, String appVersion, String platform) {
        this.appId = appId;
        this.appKey = appKey;
        this.uploadUrl = uploadUrl;
        this.bundleId = bundleId;
        this.appVersion = appVersion;
        this.platform = platform;
        this.cosInit = false;
        this.getDirectUploadEnable();
        this.errorInfo.setAppId(appId);
        this.errorInfo.setAppKey(appKey);
        this.errorInfo.setCosSecreteKey(this.cosSecreteKey);
    }

    public CosUploader(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    private AmazonS3 getS3Client() {
        String bucketName = "crashsight-east";
        com.amazonaws.auth.BasicSessionCredentials sessionCredentials = new com.amazonaws.auth.BasicSessionCredentials(this.cosAccessKey, this.cosSecreteKey, this.cosSessionToken);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProtocol(Protocol.HTTPS);
        try {
            Properties prop = System.getProperties();
            String proxyHost = prop.getProperty("https.proxyHost");
            String proxyPort = prop.getProperty("https.proxyPort");
            if (proxyHost != null && proxyPort != null) {
                int port = Integer.parseInt(proxyPort);
                this.cosProxyHost = proxyHost;
                clientConfiguration.setProxyHost(proxyHost);
                clientConfiguration.setProxyPort(port);
                Log.info("Success to set s3 client proxy.", new Object[0]);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), new Object[0]);
        }
        AmazonS3 s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(sessionCredentials))).withRegion("us-east-2")).withClientConfiguration(clientConfiguration)).build();
        return s3client;
    }

    private TransferManager createTransferManager() {
        ClientConfig clientConfig = new ClientConfig(new Region(this.cosRegion));
        clientConfig.setConnectionTimeout(2000);
        BasicSessionCredentials cred = new BasicSessionCredentials(this.cosAccessKey, this.cosSecreteKey, this.cosSessionToken);
        this.cosClient = new COSClient(cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(16);
        TransferManager transferManager = new TransferManager(this.cosClient, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0x3200000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0xA00000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        return transferManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(File localFile, final String symbolType) {
        if (!this.cosInit) {
            Log.error("get cos credentials failed", new Object[0]);
            return false;
        }
        boolean isS3 = this.bucketName.equals("crashsight-east");
        Log.info("Start to upload symbol file to cos.", new Object[0]);
        final Vector<String> targetFiles = new Vector<String>();
        if (localFile.isDirectory()) {
            try {
                Files.walkFileTree(localFile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (file.toFile().getName().endsWith(".zip")) {
                            targetFiles.add(file.toAbsolutePath().toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Log.error("Failed to collect zip file path:%s", e.getMessage());
            }
        } else {
            targetFiles.add(localFile.getPath());
        }
        Log.info("Target file list size is:%s", targetFiles.size());
        if (this.transferManager == null && !isS3) {
            this.transferManager = this.createTransferManager();
        }
        if (isS3 && this.s3client == null) {
            this.s3client = this.getS3Client();
        }
        this.uploadedSymFiles.clear();
        int cores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        ArrayList<Future<JsonObject>> futures = new ArrayList<Future<JsonObject>>();
        final JsonObject retJson = this.listByMd5(targetFiles, symbolType);
        for (final String targetFilePath : targetFiles) {
            final File targetFile = new File(targetFilePath);
            if (!targetFile.exists() || targetFile.length() <= 0L) continue;
            Log.info("Uploading file %s with size %s", targetFilePath, targetFile.length());
            if (isS3) {
                block20: {
                    this.fileObjectKey = this.getCosDstPath(symbolType);
                    boolean uploadRes = false;
                    try {
                        PutObjectResult uploadResult = this.s3client.putObject(this.bucketName, this.fileObjectKey, targetFile);
                        SymbolFileInfo symbolFileInfo = new SymbolFileInfo(this.bucketName + "/s3/" + this.fileObjectKey, targetFile, symbolType, uploadResult, this.fileObjectKey);
                        this.uploadedSymFiles.add(symbolFileInfo);
                        uploadRes = true;
                        if (uploadRes) break block20;
                    }
                    catch (Exception e) {
                        block21: {
                            try {
                                Log.error("Upload to s3 file error:%s", e.getMessage());
                                if (uploadRes) break block21;
                            }
                            catch (Throwable throwable) {
                                if (!uploadRes) {
                                    Log.error("Upload failed with proxyHost:%s", this.cosProxyHost);
                                    break;
                                }
                                Log.info("Success to Upload file %s", targetFile.getName());
                                throw throwable;
                            }
                            Log.error("Upload failed with proxyHost:%s", this.cosProxyHost);
                            break;
                        }
                        Log.info("Success to Upload file %s", targetFile.getName());
                        continue;
                    }
                    Log.error("Upload failed with proxyHost:%s", this.cosProxyHost);
                    break;
                }
                Log.info("Success to Upload file %s", targetFile.getName());
                continue;
            }
            final String platform = this.platform;
            Future<JsonObject> future = executor.submit(new Callable<JsonObject>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JsonObject call() throws Exception {
                    JsonObject resultJson = new JsonObject();
                    JsonObject json = CosUploader.this.hasFile(targetFilePath, retJson);
                    if (json != null) {
                        resultJson.addProperty("name", targetFile.getName());
                        resultJson.addProperty("time", 0);
                        resultJson.addProperty("result", true);
                        SymbolFileInfo symbolFileInfo = new SymbolFileInfo(json.get("cosPath").getAsString(), json.get("sourceFileName").getAsString(), json.get("zippedFileSize").getAsLong(), symbolType, json.get("md5").getAsString());
                        CosUploader.this.uploadedSymFiles.add(symbolFileInfo);
                    } else {
                        String cosKey = CosUploader.this.getCosDstPath(symbolType);
                        PutObjectRequest putObjectRequest = new PutObjectRequest(CosUploader.this.bucketName, cosKey, targetFile);
                        putObjectRequest.setStorageClass(StorageClass.Standard_IA);
                        boolean uploadRes = false;
                        boolean notNeedRetry = true;
                        int retryCount = 0;
                        while (notNeedRetry) {
                            try {
                                if (CosUploader.this.transferManager == null) {
                                    CosUploader.this.transferManager = CosUploader.this.createTransferManager();
                                }
                                long beginTime = System.currentTimeMillis();
                                Upload upload = CosUploader.this.transferManager.upload(putObjectRequest);
                                UploadResult uploadResult = upload.waitForUploadResult();
                                SymbolFileInfo symbolFileInfo = new SymbolFileInfo(CosUploader.this.bucketName + "/cos/" + cosKey, targetFile, symbolType, uploadResult, cosKey);
                                CosUploader.this.uploadedSymFiles.add(symbolFileInfo);
                                long endTime = System.currentTimeMillis();
                                resultJson.addProperty("time", endTime - beginTime);
                                uploadRes = true;
                                notNeedRetry = false;
                                if (retryCount <= 0) continue;
                                --retryCount;
                            }
                            catch (Exception e) {
                                if (platform.equals("win") && targetFiles.size() > 100 && retryCount < 10) {
                                    Thread.sleep(20000L);
                                    ++retryCount;
                                } else {
                                    notNeedRetry = false;
                                }
                                Log.error("cos error is: " + e.getMessage(), new Object[0]);
                                CosUploader.this.errorInfo.addErrorMsg("Upload failed:" + e.getMessage());
                            }
                            finally {
                                if (!uploadRes) {
                                    Log.error("Upload failed:" + targetFile.getName(), new Object[0]);
                                    continue;
                                }
                                Log.info("Success to Upload file " + targetFile.getName(), new Object[0]);
                            }
                        }
                        resultJson.addProperty("name", targetFile.getName());
                        resultJson.addProperty("result", uploadRes);
                    }
                    return resultJson;
                }
            });
            futures.add(future);
        }
        JsonObject reportJson = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        int success = 0;
        for (Future<JsonObject> future : futures) {
            try {
                JsonObject jsonObject = (JsonObject)future.get();
                if (!jsonObject.get("result").getAsBoolean()) continue;
                jsonArray.add(jsonObject);
                ++success;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
        reportJson.addProperty("all", targetFiles.size());
        reportJson.addProperty("success", success);
        reportJson.addProperty("info", jsonArray.toString());
        ErrorInfo reportInfo = new ErrorInfo();
        reportInfo.setAppKey(this.errorInfo.getAppKey());
        reportInfo.setAppId(this.errorInfo.getAppId());
        reportInfo.setCosSecreteKey(this.errorInfo.getSecretId());
        reportInfo.setType("jar-statistics");
        reportInfo.setUploadResult(reportJson.toString());
        this.reportError(reportInfo);
        if (this.transferManager != null) {
            this.transferManager.shutdownNow(true);
            this.transferManager = null;
        }
        if (this.s3client != null) {
            this.s3client.shutdown();
            this.s3client = null;
        }
        if (this.uploadedSymFiles.size() != targetFiles.size()) {
            this.reportError(this.errorInfo);
            return false;
        }
        return this.notifyServer(localFile, symbolType);
    }

    private boolean notifyServer(File file, String symbolType) {
        NotifyParam notifyParam = new NotifyParam();
        int indexBegin = 0;
        int indexEnd = 0;
        boolean isNofityAll = false;
        do {
            Vector<SymbolFileInfo> tempUploadedSymFiles;
            if (this.uploadedSymFiles.size() - indexEnd > 5) {
                indexEnd = indexBegin + 5;
                tempUploadedSymFiles = new Vector<SymbolFileInfo>(this.uploadedSymFiles.subList(indexBegin, indexEnd));
                indexBegin += 5;
            } else {
                tempUploadedSymFiles = new Vector<SymbolFileInfo>(this.uploadedSymFiles.subList(indexBegin, this.uploadedSymFiles.size()));
                isNofityAll = true;
            }
            notifyParam.appId = this.appId;
            notifyParam.appKey = this.appKey;
            notifyParam.bundleId = this.bundleId;
            notifyParam.version = this.appVersion;
            notifyParam.platformId = this.platformId;
            notifyParam.symbolFileInfos = tempUploadedSymFiles;
            notifyParam.secretId = this.cosSecreteKey;
            String checkUrl = "https://" + this.uploadUrl + NOTIFY_URL_SUFFIX;
            MediaType mediaType = MediaType.parse("application/json");
            Gson requestJson = new Gson();
            Log.info("request param is :%s", requestJson.toJson(notifyParam));
            RequestBody body = RequestBody.create(mediaType, requestJson.toJson(notifyParam));
            Request checkRequest = new Request.Builder().url(checkUrl).post(body).build();
            String responseMsg = "";
            JsonObject responseObject = null;
            JsonParser parser = new JsonParser();
            int retry = 3;
            do {
                try {
                    responseMsg = CosUploader.doPostServer(checkRequest);
                    if (responseMsg != null) {
                        Log.info("Upload result is :%s", responseMsg);
                        responseObject = (JsonObject)parser.parse(responseMsg);
                        if (responseObject != null && responseObject.get("code") != null && responseObject.get("code").getAsString().equals("0")) {
                            Log.info("Success to notify server", new Object[0]);
                            break;
                        }
                    }
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    Log.error("Failed to notify server with msg: %s", e.getMessage());
                }
            } while (--retry > 0);
            if (retry > 0) continue;
            Log.error("Failed to notify server after retry 3 times.", new Object[0]);
            return false;
        } while (!isNofityAll);
        return true;
    }

    public void getDirectUploadEnable() {
        try {
            String checkUrl = "https://" + this.uploadUrl + COS_TOKEN_URL_SUFFIX;
            JsonObject requestParam = new JsonObject();
            requestParam.addProperty("appId", this.appId);
            requestParam.addProperty("appKey", this.appKey);
            MediaType mediaType = MediaType.parse("application/json");
            RequestBody body = RequestBody.create(mediaType, String.valueOf(requestParam));
            Request checkRequest = new Request.Builder().url(checkUrl).post(body).build();
            String checkMsg = "";
            String data = "";
            JsonParser parser = new JsonParser();
            JsonObject cosParams = null;
            checkMsg = CosUploader.doPostServer(checkRequest);
            cosParams = (JsonObject)parser.parse(checkMsg);
            if (cosParams.get("code").getAsString().equals("200")) {
                data = cosParams.get("data").getAsString();
                data = DESUtil.decrypt(this.appKey, data);
                cosParams = (JsonObject)parser.parse(data);
                this.cosAccessKey = cosParams.get("tmpSecretId").getAsString();
                this.cosSecreteKey = cosParams.get("tmpSecretKey").getAsString();
                this.cosSessionToken = cosParams.get("sessionToken").getAsString();
                this.bucketName = cosParams.get("bucket").getAsString();
                this.cosRegion = cosParams.get("region").getAsString();
                this.platformId = cosParams.get("platformId").getAsInt();
                if (cosParams.get("internalDomain") != null) {
                    this.cosInnerDomain = cosParams.get("internalDomain").getAsString();
                }
                this.cosInit = true;
            } else {
                Log.error("Failed to get code with info:%s,appId:%s,appKey:%s ", checkMsg, this.appId, this.appKey);
            }
        }
        catch (Exception e) {
            Log.warn("The target server is not support upload with slices: %s", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPostServer(Request request) throws InterruptedException, IOException {
        String responseMsg = "";
        ConnectionPool cp = new ConnectionPool(0, 5L, TimeUnit.SECONDS);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(20L, TimeUnit.SECONDS);
        builder.writeTimeout(20L, TimeUnit.SECONDS);
        builder.readTimeout(20L, TimeUnit.SECONDS);
        builder.connectionPool(cp);
        OkHttpClient httpClient = builder.build();
        try (Response response = null;){
            response = httpClient.newCall(request).execute();
            assert (response.body() != null);
            responseMsg = response.body().string();
        }
        httpClient.dispatcher().executorService().shutdown();
        return responseMsg;
    }

    private String getCosDstPath(String symbolType) {
        Date date = new Date();
        SimpleDateFormat dataFormat = new SimpleDateFormat("YYYY-MM-dd");
        String currentDay = dataFormat.format(date);
        String cosFileKey = "";
        if (symbolType.equals("1")) {
            cosFileKey = "java-" + currentDay;
        } else if (symbolType.equals("2")) {
            cosFileKey = "ios-" + currentDay;
        } else if (symbolType.equals("3")) {
            cosFileKey = "native-" + currentDay;
        } else if (symbolType.equals("6")) {
            cosFileKey = "win-" + currentDay;
        } else if (symbolType.equals("11")) {
            cosFileKey = "win-stif-" + currentDay;
        } else if (symbolType.equals("12")) {
            cosFileKey = "win-sym-" + currentDay;
        } else if (symbolType.equals("30")) {
            cosFileKey = "ts-" + currentDay;
        } else if (symbolType.equals("14")) {
            cosFileKey = "ps-" + currentDay;
        } else if (symbolType.equals("13")) {
            cosFileKey = "switch-" + currentDay;
        } else if (symbolType.equals("20")) {
            cosFileKey = "linux-stif-" + currentDay;
        } else if (symbolType.equals("21")) {
            cosFileKey = "linux-sym-" + currentDay;
        } else if (symbolType.equals("15")) {
            cosFileKey = "xbox-" + currentDay;
        }
        cosFileKey = "cst-" + cosFileKey + "-" + UUID.randomUUID().toString() + ".zip";
        return cosFileKey;
    }

    private void deleteFiles(Vector<SymbolFileInfo> vector) {
        boolean isS3;
        boolean bl = isS3 = this.bucketName.equals("crashsight-east");
        if (isS3 && this.s3client == null) {
            this.s3client = this.getS3Client();
        }
        if (this.transferManager == null && !isS3) {
            this.getDirectUploadEnable();
            this.transferManager = this.createTransferManager();
        }
        for (SymbolFileInfo symbolFileInfo : vector) {
            Log.info("delete file object key:%s,bucket:%s", symbolFileInfo.getFileObjectKey(), this.bucketName);
            if (isS3) {
                this.s3client.deleteObject(this.bucketName, symbolFileInfo.getFileObjectKey());
                continue;
            }
            try {
                this.cosClient.deleteObject(this.bucketName, symbolFileInfo.getFileObjectKey());
                Log.info("delete success", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.transferManager != null) {
            this.transferManager.shutdownNow(true);
            this.transferManager = null;
        }
        if (this.s3client != null) {
            this.s3client.shutdown();
            this.s3client = null;
        }
    }

    public boolean reportError(ErrorInfo ei) {
        String checkUrl = "https://" + this.uploadUrl + REPORT_ERROR_URL_SUFFIX;
        MediaType mediaType = MediaType.parse("application/json");
        Gson requestJson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy(){

            @Override
            public boolean shouldSkipField(FieldAttributes f) {
                String fieldNameToExclude = "version";
                return f.getName().equals(fieldNameToExclude);
            }

            @Override
            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }).create();
        String jsonInfo = requestJson.toJson(ei);
        Log.info("report error param info:" + jsonInfo, new Object[0]);
        RequestBody body = RequestBody.create(mediaType, jsonInfo);
        Request checkRequest = new Request.Builder().url(checkUrl).post(body).build();
        String responseMsg = "";
        JsonObject responseObject = null;
        JsonParser parser = new JsonParser();
        try {
            responseMsg = CosUploader.doPostServer(checkRequest);
            if (responseMsg != null) {
                Log.info("Report error result is: " + responseMsg, new Object[0]);
                responseObject = (JsonObject)parser.parse(responseMsg);
                if (responseObject != null && responseObject.get("code") != null && responseObject.get("code").getAsString().equals("200")) {
                    Log.info("Success to report error", new Object[0]);
                    return true;
                }
                return false;
            }
            Log.error("Report Error response msg is null.", new Object[0]);
        }
        catch (Exception e) {
            Log.error("Failed to report error with msg: " + e.getMessage(), new Object[0]);
            return false;
        }
        return false;
    }

    public JsonObject listByMd5(Vector<String> targetFiles, String symbolType) {
        ArrayList<String> md5List = new ArrayList<String>();
        for (String targetFilePath : targetFiles) {
            File targetFile = new File(targetFilePath);
            try {
                FileInputStream is = new FileInputStream(targetFile);
                Throwable throwable = null;
                try {
                    String md5 = DigestUtils.md5Hex(is);
                    md5List.add(md5);
                }
                catch (Throwable md5) {
                    throwable = md5;
                    throw md5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable md5) {
                            throwable.addSuppressed(md5);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (md5List.isEmpty()) {
            return null;
        }
        String checkUrl = "https://" + this.uploadUrl + LIST_BY_MD5;
        MediaType mediaType = MediaType.parse("application/json");
        SymbolDuplicateRequestBean sdrb = new SymbolDuplicateRequestBean();
        sdrb.setMd5List(md5List);
        sdrb.setAppId(this.appId);
        sdrb.setAppKey(this.appKey);
        sdrb.setSymbolType(symbolType);
        Gson requestJson = new Gson();
        String jsonInfo = requestJson.toJson(sdrb);
        Log.info("request param:%s", jsonInfo);
        RequestBody body = RequestBody.create(mediaType, jsonInfo);
        Request checkRequest = new Request.Builder().url(checkUrl).post(body).build();
        String responseMsg = "";
        JsonObject responseObject = null;
        JsonParser parser = new JsonParser();
        try {
            responseMsg = CosUploader.doPostServer(checkRequest);
            Log.info("response msg:%s", responseMsg);
            if (responseMsg != null) {
                responseObject = (JsonObject)parser.parse(responseMsg);
                if (responseObject != null && responseObject.get("code") != null && responseObject.get("code").getAsString().equals("200")) {
                    if (responseObject.has("data")) {
                        return responseObject.get("data").getAsJsonObject();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject hasFile(String targetFile, JsonObject jsonObject) {
        try (FileInputStream is = new FileInputStream(targetFile);){
            String md5 = DigestUtils.md5Hex(is);
            if (jsonObject == null) return null;
            if (!jsonObject.has(md5)) return null;
            JsonObject ret = jsonObject.get(md5).getAsJsonObject();
            ret.addProperty("md5", md5);
            JsonObject jsonObject2 = ret;
            return jsonObject2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static interface MappingTypeUtil {
        public static final String MAPPING_JAVA = "1";
        public static final String MAPPING_IOS = "2";
        public static final String MAPPING_NATIVE = "3";
        public static final String MAPPING_PLUGIN = "4";
        public static final String MAPPING_UNITY = "5";
        public static final String MAPPING_WINDOWS = "6";
        public static final String MAPPING_WINDOWS_STIF = "11";
        public static final String MAPPING_WINDOWS_SYM = "12";
        public static final String MAPPING_JS = "30";
        public static final String MAPPING_PS = "14";
        public static final String MAPPING_NSS = "13";
        public static final String MAPPING_XBOX = "15";
        public static final String MAPPING_LINUX_STIF = "20";
        public static final String MAPPING_LINUX_SYM = "21";
    }
}

