/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    private static final Logger logger = LoggerFactory.getLogger(Common.class);

    public static String splitZipFiles(String zipFilePath, String type) {
        File resultsDir;
        String outputFolderPath = "";
        File zipFile = new File(zipFilePath);
        if (zipFile.exists()) {
            outputFolderPath = zipFile.getParent() + File.separator + "CrashSymbol_" + String.valueOf(System.currentTimeMillis()) + File.separator;
            resultsDir = new File(outputFolderPath);
            if (!resultsDir.exists()) {
                resultsDir.mkdir();
            }
        } else {
            return outputFolderPath;
        }
        resultsDir.deleteOnExit();
        HashMap<String, Long> oriFileMap = new HashMap<String, Long>();
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry;
            byte[] buffer = new byte[0x100000];
            try (ZipFile tempZipFile = new ZipFile(zipFilePath);){
                Enumeration<? extends ZipEntry> entries = tempZipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry tempEntry = entries.nextElement();
                    tempEntry.setTime(0L);
                    long originalSize = tempEntry.getCompressedSize();
                    oriFileMap.put(tempEntry.getName(), originalSize);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    entry.setTime(0L);
                    String fileName = entry.getName();
                    long oriFileSize = (Long)oriFileMap.get(fileName);
                    String outputFilePath = outputFolderPath + Common.changeFileSuffix(fileName, "") + ".zip";
                    if (type.equals("14")) {
                        String[] arr = fileName.split("_");
                        String uuid = arr[0];
                        outputFilePath = outputFolderPath + "crashsightSymbol&ps5&" + arr[1] + "&" + uuid + ".zip";
                    } else if (type.equals("13")) {
                        outputFilePath = outputFolderPath + "crashsightSymbol&nss&" + Common.changeFileSuffix(fileName, "") + "&" + UUID.randomUUID().toString().replace("-", "") + ".zip";
                    } else if (type.equals("1")) {
                        outputFilePath = outputFolderPath + "crashsightSymbol&java&" + Common.changeFileSuffix(fileName, "") + "&" + UUID.randomUUID().toString().replace("-", "") + ".zip";
                    } else if (type.equals("30")) {
                        outputFilePath = outputFolderPath + "crashsightSymbol&ts&" + Common.changeFileSuffix(fileName, "") + "&" + UUID.randomUUID().toString().replace("-", "") + ".zip";
                    }
                    try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(outputFilePath));){
                        int bytesRead;
                        ZipEntry zipEntry = new ZipEntry(fileName);
                        zipEntry.setTime(0L);
                        zipOutputStream.putNextEntry(zipEntry);
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            zipOutputStream.write(buffer, 0, bytesRead);
                        }
                        zipOutputStream.closeEntry();
                    }
                    File outFile = new File(outputFilePath);
                    if (outFile.exists()) {
                        outFile.deleteOnExit();
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputFolderPath;
    }

    public static String changeFileSuffix(String fileName, String suffix) {
        if (null == fileName || fileName.isEmpty()) {
            return fileName;
        }
        String ret = "";
        ret = fileName.lastIndexOf(".") > 0 ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
        ret = ret + suffix;
        return ret;
    }

    public static File zipFile(List<File> srcZipFiles, String filename) throws IOException {
        File zipedFile = File.createTempFile("bugly", filename + ".zip");
        ZipOutputStream zipOut = null;
        zipOut = new ZipOutputStream(new FileOutputStream(zipedFile));
        BufferedOutputStream bos = new BufferedOutputStream(zipOut, 2048);
        for (File srcZipFile : srcZipFiles) {
            FileInputStream input = new FileInputStream(srcZipFile);
            ZipEntry zipEntry = new ZipEntry(srcZipFile.getName());
            zipEntry.setTime(0L);
            zipOut.putNextEntry(zipEntry);
            BufferedInputStream zis = new BufferedInputStream(input);
            byte[] tempBuf = new byte[2048];
            int count = 0;
            while ((count = zis.read(tempBuf, 0, 2048)) != -1) {
                bos.write(tempBuf, 0, count);
            }
            ((InputStream)input).close();
        }
        bos.flush();
        bos.close();
        zipOut.close();
        return zipedFile;
    }
}

