/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.pdb.PdbParser;
import com.uqm.crashsight.symtabtool.pe.PeDebugIdFile;
import com.uqm.crashsight.symtabtool.pe.PeObject;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class SymtabExtractorWin {
    private static SymtabExtractorWin instance = null;
    private ExecutorService executorService = null;

    private SymtabExtractorWin() {
        ThreadFactory threadFactory2 = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread2 = new Thread(r);
                return thread2;
            }
        };
        this.executorService = Executors.newScheduledThreadPool(3, threadFactory2);
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser pdbArgsParser, PdbParser pdbParser, String fileName) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("PDB");
        symtabFileInfoBean.setFileFormat(pdbParser.fileFormat);
        symtabFileInfoBean.setArch(pdbParser.arch);
        symtabFileInfoBean.setUuid(pdbParser.uuid + "0");
        symtabFileInfoBean.setFileName(fileName);
        symtabFileInfoBean.setAppName(pdbParser.appName);
        symtabFileInfoBean.setVmAddr(0L);
        symtabFileInfoBean.setSymbolTable(pdbParser.symbolTable);
        symtabFileInfoBean.setSymtabToolVersion(pdbArgsParser.crashsightVersion);
        return symtabFileInfoBean;
    }

    public String[] extract(final ArgsParser argsParser) {
        String zipFileName;
        block47: {
            final ArrayList<File> pcFiles = new ArrayList<File>();
            final ArrayList<File> peFiles = new ArrayList<File>();
            final ArrayList symFilesList = new ArrayList();
            ArrayList<File> dirs = new ArrayList<File>();
            File symbolFile = null;
            zipFileName = argsParser.getPathName() + "CrashSight_" + System.currentTimeMillis() + "_WinSymbol.zip";
            try {
                String[] fileDirs;
                for (String dirName : fileDirs = argsParser.getPathName().split(";")) {
                    dirs.add(new File(dirName));
                }
                File f = new File(argsParser.getFileName());
                if (f.isFile()) {
                    dirs.clear();
                    dirs.add(f);
                }
                for (File dir : dirs) {
                    Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            if (argsParser.getParseMode().equals("") || argsParser.getParseMode().equals("ori")) {
                                if (file.toFile().getName().endsWith(".pdb") | file.toFile().getName().endsWith(".exe") | file.toFile().getName().endsWith(".dll")) {
                                    pcFiles.add(file.toFile());
                                    Log.info("File " + file.toFile() + " will be processed.", new Object[0]);
                                }
                            } else if (argsParser.getParseMode().equals("generic")) {
                                if (file.toFile().getName().endsWith(".pdb")) {
                                    pcFiles.add(file.toFile());
                                    Log.info("File " + file.toFile() + " will be processed.", new Object[0]);
                                }
                                if (file.toFile().getName().endsWith(".exe") | file.toFile().getName().endsWith(".dll")) {
                                    peFiles.add(file.toFile());
                                    Log.info("File " + file.toFile() + " will be processed.", new Object[0]);
                                }
                            } else if (file.toFile().getName().endsWith(".pdb")) {
                                pcFiles.add(file.toFile());
                                Log.info("File " + file.toFile() + " will be processed.", new Object[0]);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                if (pcFiles.size() == 0 && peFiles.size() == 0) {
                    Log.info("no .pdb or .exe/.dll file found", new Object[0]);
                    return null;
                }
                if (argsParser.getParseMode().equals("") || argsParser.getParseMode().equals("ori")) {
                    symbolFile = SymtabExtractorWin.zipFiles(pcFiles, zipFileName);
                    String[] zipFileNames = new String[]{zipFileName};
                    return zipFileNames;
                }
                if (argsParser.getParseMode().equals("generic")) {
                    String pathName = argsParser.getPathName();
                    StringBuilder stifZipFileName = new StringBuilder("crashsightSymbol");
                    StringBuilder symZipFileName = new StringBuilder("crashsightBreakpadSymbol");
                    symZipFileName.insert(0, pathName);
                    stifZipFileName.insert(0, pathName);
                    HashMap<String, File> stifFiles = new HashMap<String, File>();
                    HashMap<String, File> symFiles = new HashMap<String, File>();
                    if (pcFiles.isEmpty() && peFiles.isEmpty()) {
                        return null;
                    }
                    if (pcFiles.size() == 1) {
                        Log.info("Extracting symtab file: %s", ((File)pcFiles.get(0)).getName());
                    } else {
                        Log.info("Extracting symtab files of directory: %s", pathName);
                    }
                    int i = 0;
                    for (File file : pcFiles) {
                        boolean res;
                        String fileName;
                        long beginTime = System.currentTimeMillis();
                        try {
                            fileName = file.getCanonicalPath();
                        }
                        catch (IOException e) {
                            Log.error(e);
                            return null;
                        }
                        long startTime = System.currentTimeMillis();
                        boolean dumpSymbol = argsParser.dumpSymbol();
                        boolean dumpCfi = argsParser.getDumpCfi();
                        PdbParser pdbParser = PdbParser.create(fileName, dumpSymbol, dumpCfi);
                        if (null == pdbParser) {
                            SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file!");
                            Log.error("Failed to parse the file!", new Object[0]);
                            continue;
                        }
                        Log.info("[Time]parse elf cost " + (System.currentTimeMillis() - startTime) + "ms", new Object[0]);
                        Log.info("UUID: " + pdbParser.uuid, new Object[0]);
                        SymtabFileInfoBean symtabFileInfoBean = SymtabExtractorWin.getSymtabFileInfoBean(argsParser, pdbParser, fileName);
                        SymtabFile symtabFile = SymtabFile.create(symtabFileInfoBean);
                        if (argsParser.getDumpStif()) {
                            res = SymtabExtractorWin.generateStifFile(symtabFileInfoBean, argsParser, symtabFile, stifFiles);
                            if (!res) continue;
                            if (i++ < 2) {
                                stifZipFileName.append("_").append(pdbParser.arch);
                                stifZipFileName.append("-").append(pdbParser.uuid, 0, 5);
                            }
                        }
                        if (argsParser.getDumpSym()) {
                            res = SymtabExtractorWin.generateSymFile(symtabFileInfoBean, argsParser, symtabFile, pdbParser, symFiles);
                            if (!res) continue;
                            if (i++ < 2) {
                                symZipFileName.append("_").append(pdbParser.arch);
                                symZipFileName.append("-").append(pdbParser.uuid, 0, 5);
                            }
                        }
                        long endTime = System.currentTimeMillis();
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("name", file.getName());
                        jsonObject.addProperty("time", endTime - beginTime);
                        SymtabToolClient.getJsonArray().add(jsonObject);
                    }
                    if (argsParser.getSymbolPlatform().equals("xbox")) {
                        Log.info("Processing Xbox symbol file.", new Object[0]);
                        for (File file : peFiles) {
                            String fileName;
                            try {
                                fileName = file.getCanonicalPath();
                            }
                            catch (IOException e) {
                                Log.error(e);
                                return null;
                            }
                            PeObject pe = new PeObject(fileName, "peFile");
                            boolean res = pe.load();
                            if (!res || !argsParser.getDumpCfi() || pe.getDebugId().equals("")) continue;
                            symFiles.put(pe.symbolPath, new File(pe.symbolPath));
                            if (i++ >= 2) continue;
                            symZipFileName.append("_").append(pe.getArch());
                            symZipFileName.append("-").append(pe.getDebugId(), 0, 5);
                        }
                    } else {
                        Log.info("Processing Windows symbol file.", new Object[0]);
                        List<File> newPeFiles = SymtabExtractorWin.checkPeFiles(peFiles, pcFiles);
                        for (File peFile : newPeFiles) {
                            String fileName;
                            long beginTime = System.currentTimeMillis();
                            try {
                                fileName = peFile.getCanonicalPath();
                            }
                            catch (IOException e) {
                                Log.error(e);
                                return null;
                            }
                            PeObject pe = new PeObject(fileName, "peFile");
                            boolean res = pe.load();
                            if (res && argsParser.getDumpCfi() && !pe.getDebugId().equals("")) {
                                symFiles.put(pe.symbolPath, new File(pe.symbolPath));
                                if (i++ < 2) {
                                    symZipFileName.append("_").append(pe.getArch());
                                    symZipFileName.append("-").append(pe.getDebugId(), 0, 5);
                                }
                            }
                            long endTime = System.currentTimeMillis();
                            JsonObject jsonObject = new JsonObject();
                            jsonObject.addProperty("name", peFile.getName());
                            jsonObject.addProperty("time", endTime - beginTime);
                            SymtabToolClient.getJsonArray().add(jsonObject);
                        }
                    }
                    stifZipFileName.append(".zip");
                    symZipFileName.append(".zip");
                    if (argsParser.getSymZipFileName() != null && !argsParser.getSymZipFileName().isEmpty()) {
                        symZipFileName = new StringBuilder(argsParser.getSymZipFileName());
                    }
                    if (argsParser.getStifZipFileName() != null && !argsParser.getStifZipFileName().isEmpty()) {
                        stifZipFileName = new StringBuilder(argsParser.getStifZipFileName());
                    }
                    boolean zipRes = false;
                    if (symFiles.size() > 0) {
                        zipRes = FileHelper.zipFiles(new Vector<File>(symFiles.values()), symZipFileName.toString());
                        if (zipRes) {
                            Log.info("Successfully zipped symtab file!", new Object[0]);
                        } else {
                            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
                            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
                        }
                    }
                    if (stifFiles.size() > 0) {
                        Log.info("Begin to zip stif file: " + stifZipFileName.toString(), new Object[0]);
                        zipRes = FileHelper.zipFiles(new Vector<File>(stifFiles.values()), stifZipFileName.toString());
                        if (zipRes) {
                            Log.info("Successfully zipped stif file!", new Object[0]);
                        } else {
                            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
                            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
                        }
                    }
                    for (File file : stifFiles.values()) {
                        if (file.delete()) continue;
                        file.deleteOnExit();
                    }
                    for (File file : symFiles.values()) {
                        if (file.delete()) continue;
                        file.deleteOnExit();
                    }
                    String[] stringArray = new String[]{stifZipFileName.toString(), symZipFileName.toString()};
                    return stringArray;
                }
                if (!argsParser.getParseMode().equals("win")) break block47;
                for (final File pdbFile : pcFiles) {
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            SymtabExtractorWin.generateWinSym(pdbFile, symFilesList);
                        }
                    });
                }
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(1800000L, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executorService.shutdownNow();
                }
                Log.info("Begin to zip symtab file: " + zipFileName, new Object[0]);
                boolean zipRes = FileHelper.zipFiles(new Vector<File>(symFilesList), zipFileName.toString());
                if (zipRes) {
                    Log.info("Successfully zipped symtab file!", new Object[0]);
                } else {
                    SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
                    Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
                }
                if (!argsParser.uploadDsym()) {
                    for (File file : symFilesList) {
                        if (file.delete()) continue;
                        file.deleteOnExit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SymtabToolClient.getErrorInfo().addErrorMsg(e.getMessage());
                Log.error("Error1!!!!", new Object[0]);
            }
        }
        String[] zipFileNames = new String[]{zipFileName};
        return zipFileNames;
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        Vector<File> soFiles = argsParser.getSoFiles();
        if (soFiles.isEmpty()) {
            return null;
        }
        if (soFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", soFiles.get(0).getName());
        } else if (soFiles.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", pathName);
        }
        Vector<String> uuids = new Vector<String>();
        for (File soFile : soFiles) {
            String fileName = null;
            try {
                fileName = soFile.getCanonicalPath();
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            uuids.add(ElfParser.getUuid(fileName));
        }
        return uuids;
    }

    public static File zipFiles(List<File> srcZipFiles, String filename) throws IOException {
        int bufferSize = 2048;
        File zipedFile = new File(filename);
        byte[] tempBuf = new byte[bufferSize];
        ZipOutputStream zipOut = null;
        zipOut = new ZipOutputStream(new FileOutputStream(zipedFile));
        BufferedOutputStream bos = new BufferedOutputStream(zipOut, bufferSize);
        HashSet<String> isDuplicateFile = new HashSet<String>();
        Log.info("Zipping with size " + srcZipFiles.size(), new Object[0]);
        for (File srcZipFile : srcZipFiles) {
            String fileName = srcZipFile.getName();
            Log.info("Zipping " + fileName, new Object[0]);
            if (isDuplicateFile.contains(fileName)) continue;
            isDuplicateFile.add(fileName);
            FileInputStream input = new FileInputStream(srcZipFile);
            ZipEntry tempZipEntry = new ZipEntry(fileName);
            tempZipEntry.setTime(0L);
            zipOut.putNextEntry(tempZipEntry);
            BufferedInputStream zis = new BufferedInputStream(input);
            int count = 0;
            while ((count = zis.read(tempBuf, 0, bufferSize)) != -1) {
                bos.write(tempBuf, 0, count);
            }
            bos.flush();
            ((InputStream)input).close();
        }
        zipOut.close();
        return zipedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL outputResTool(String jarName) throws IOException {
        File outPutFile = new File(jarName);
        InputStream resToolInputMD5Stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarName);
        InputStream resToolInputStream = null;
        OutputStream resToolOutputStream = null;
        if (resToolInputMD5Stream == null) {
            Log.info("resToolInputMD5Stream is null.", new Object[0]);
            throw new NullPointerException();
        }
        String inputMD5 = DigestUtils.md5Hex(resToolInputMD5Stream);
        try {
            boolean flag = true;
            if (flag) {
                int i;
                resToolInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarName);
                resToolOutputStream = new FileOutputStream(outPutFile);
                if (resToolInputStream == null) {
                    throw new NullPointerException("\u6307\u5b9ajar\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                byte[] bytes = new byte[1024];
                while ((i = resToolInputStream.read(bytes)) != -1) {
                    resToolOutputStream.write(bytes, 0, i);
                }
            }
        }
        finally {
            resToolInputMD5Stream.close();
            if (resToolInputStream != null) {
                resToolInputStream.close();
            }
            if (resToolOutputStream != null) {
                resToolOutputStream.close();
            }
        }
        return outPutFile.toURI().toURL();
    }

    private static void generateWinSym(File pdbFile, List<File> symFiles) {
        try {
            if (pdbFile.getName().endsWith(".pdb")) {
                URL url = SymtabExtractorWin.outputBuglyTool("crashSightDumpSym.exe");
                URL dllUrl = SymtabExtractorWin.outputBuglyTool("msdia140.dll");
                Log.info(pdbFile.getName() + " with size " + pdbFile.length() + " byte", new Object[0]);
                File symFile = new File(pdbFile.getCanonicalPath() + ".sym");
                ArrayList<String> params = new ArrayList<String>();
                params.add("cmd");
                params.add("/c");
                params.add("crashSightDumpSym.exe  \"" + pdbFile.getCanonicalPath() + "\" \"" + symFile.getCanonicalPath() + "\"");
                String[] strings = new String[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    strings[i] = (String)params.get(i);
                }
                Process process = null;
                Runtime runtime = Runtime.getRuntime();
                process = runtime.exec(strings);
                InputStream fis = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    Log.info(line, new Object[0]);
                }
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder errorOutput = new StringBuilder();
                while ((line = errorReader.readLine()) != null) {
                    errorOutput.append(line).append("\n");
                }
                int exitCode = process.waitFor();
                Log.info("exitCode:" + exitCode, new Object[0]);
                Log.info("exitInfo:" + errorOutput.toString(), new Object[0]);
                if (symFile.exists()) {
                    String[] properties;
                    BufferedReader in = new BufferedReader(new FileReader(symFile));
                    String uuid = "";
                    String moduleName = "";
                    String arch = "";
                    String str = in.readLine();
                    if (str != null && (properties = str.split(" ")).length == 5) {
                        arch = properties[2];
                        uuid = properties[3].toUpperCase();
                        moduleName = properties[4];
                        moduleName = moduleName.substring(0, moduleName.lastIndexOf("."));
                    }
                    in.close();
                    Log.info(arch + "&" + uuid + "&" + moduleName, new Object[0]);
                    String symFilePrefix = symFile.getParent();
                    String desFileName = symFilePrefix + "/crashsight&" + arch + "&" + moduleName + "&" + uuid + ".sym";
                    File desFile = new File(desFileName);
                    boolean isSuccess = symFile.renameTo(desFile);
                    if (!isSuccess) {
                        symFile.delete();
                    }
                    Log.info("rename file result:" + isSuccess, new Object[0]);
                    if (desFile.exists()) {
                        symFiles.add(desFile);
                    } else {
                        Log.info(desFileName + " is not exits.", new Object[0]);
                    }
                } else {
                    Log.error("Sym file:" + symFile + " not exist", new Object[0]);
                    SymtabToolClient.getErrorInfo().addErrorMsg("Sym file:" + symFile + " not exist");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static PeDebugIdFile checkPeFile(File pdbFile) {
        try {
            String pdbDebugId = PdbParser.getPdbDebugId(pdbFile.getAbsolutePath());
            String dir = Paths.get(pdbFile.getAbsolutePath(), new String[0]).getParent().toString();
            Vector<File> files = FileHelper.getDirFileList(new File(dir));
            for (File file : files) {
                PeObject peObject;
                String peDebugId;
                if (StringUtils.equals(file.getAbsolutePath(), pdbFile.getAbsolutePath()) || !StringUtils.endsWith(file.getAbsolutePath(), ".dll") && !StringUtils.endsWith(file.getAbsolutePath(), ".exe") || !StringUtils.equals(pdbDebugId, peDebugId = (peObject = new PeObject(file.getAbsolutePath(), "pe")).getDebugId())) continue;
                if (StringUtils.equals(FilenameUtils.removeExtension(file.getAbsolutePath()), FilenameUtils.removeExtension(pdbFile.getAbsolutePath()))) {
                    return new PeDebugIdFile(peDebugId, file);
                }
                String targetPePath = FileHelper.changeFileSuffix(pdbFile.getAbsolutePath(), FilenameUtils.getExtension(file.getAbsolutePath()));
                File peFile = new File(targetPePath);
                FileUtils.copyFile(file, peFile);
                return new PeDebugIdFile(peDebugId, peFile);
            }
        }
        catch (Exception e) {
            Log.error("preparePeFile err:", e);
        }
        return null;
    }

    private static List<File> checkPeFiles(List<File> peFiles, List<File> pdbFiles) {
        ArrayList<File> newPeFiles = new ArrayList<File>();
        HashMap<String, File> peDebugId2File = new HashMap<String, File>();
        for (File file : peFiles) {
            String debugId = SymtabExtractorWin.getPeDebugId(file);
            if (!StringUtils.isNotEmpty(debugId)) continue;
            peDebugId2File.put(debugId, file);
        }
        for (File file : pdbFiles) {
            PeDebugIdFile peDebugIdFile = SymtabExtractorWin.checkPeFile(file);
            if (peDebugIdFile == null || !peDebugId2File.containsKey(peDebugIdFile.getDebugId())) continue;
            peDebugId2File.put(peDebugIdFile.getDebugId(), peDebugIdFile.getFile());
        }
        for (Map.Entry entry : peDebugId2File.entrySet()) {
            newPeFiles.add((File)entry.getValue());
        }
        return newPeFiles;
    }

    private static String getPeDebugId(File file) {
        PeObject peObject = new PeObject(file.getAbsolutePath(), "pe");
        return peObject.getDebugId();
    }

    public static SymtabExtractorWin getInstance() {
        if (instance == null) {
            instance = new SymtabExtractorWin();
        }
        return instance;
    }

    private static boolean generateStifFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, Map<String, File> files) {
        SymtabIndexFile.vmAddr = symtabFileInfoBean.getVmAddr();
        SymtabIndexFile.pvAddr = symtabFileInfoBean.getPvaddr();
        SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
        String symtabFileName = symtabFile.getSymtabFileName();
        if (symtabFileName == null) {
            return false;
        }
        File symbolFile = new File(symtabFileName);
        if (!SymtabFileParser.parseFile(symtabFileName, symbolFile.getParent(), symtabFileInfoBean.getSymbolTable())) {
            Log.warn("Failed to parse symbol file: " + symtabFileName, new Object[0]);
        } else {
            String stifFilePath = FileHelper.changeFileSuffix(symtabFileName, "stif");
            File stifFile = new File(stifFilePath);
            Log.info("Add stif to symtab zip file: " + stifFilePath, new Object[0]);
            files.put(stifFilePath, stifFile);
        }
        if (null != symtabFileInfoBean.getSymbolTable()) {
            symtabFileInfoBean.getSymbolTable().close();
        }
        if (argsParser.dumpSymbol()) {
            Log.info("Add symbol to symtab zip file: " + symtabFileName, new Object[0]);
            files.put(symtabFileName, symbolFile);
        } else if (!symbolFile.delete()) {
            symbolFile.deleteOnExit();
        }
        return true;
    }

    private static boolean generateSymFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, PdbParser pdbParser, Map<String, File> breakpadFiles) {
        symtabFile.setUuid(pdbParser.uuid);
        Log.info("Breakpad UUID: " + pdbParser.uuid, new Object[0]);
        SymtabFile symtabFile2 = SymtabFile.create(symtabFileInfoBean);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL outputBuglyTool(String jarName) throws IOException {
        ClassPathResource resource = new ClassPathResource(jarName);
        File outPutFile = new File(jarName);
        InputStream stream = resource.getInputStream();
        InputStream buglyToolInputMD5Stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarName);
        InputStream buglyToolInputStream = null;
        OutputStream buglyToolOutputStream = null;
        if (buglyToolInputMD5Stream == null) {
            throw new NullPointerException();
        }
        String inputMD5 = DigestUtils.md5Hex(buglyToolInputMD5Stream);
        try {
            String outPutMD5;
            boolean flag = true;
            if (outPutFile.exists() && inputMD5.equals(outPutMD5 = DigestUtils.md5Hex(stream))) {
                flag = false;
            }
            if (flag) {
                int i;
                buglyToolInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarName);
                buglyToolOutputStream = new FileOutputStream(outPutFile);
                if (buglyToolInputStream == null) {
                    throw new NullPointerException("\u6307\u5b9ajar\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                byte[] bytes = new byte[1024];
                while ((i = buglyToolInputStream.read(bytes)) != -1) {
                    buglyToolOutputStream.write(bytes, 0, i);
                }
            }
        }
        finally {
            buglyToolInputMD5Stream.close();
            stream.close();
            if (buglyToolInputStream != null) {
                buglyToolInputStream.close();
            }
            if (buglyToolOutputStream != null) {
                buglyToolOutputStream.close();
            }
        }
        return outPutFile.toURI().toURL();
    }
}

