/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SymtabExtractorPs {
    public static String extract(ArgsParser argsParser) {
        String pathName = argsParser.getFileName();
        String copyPath = null;
        try {
            Path tmp = Files.createTempDirectory("tmp", new FileAttribute[0]);
            copyPath = tmp.toAbsolutePath().toString();
        }
        catch (Exception e) {
            Log.error("Create temp directory failed", new Object[0]);
            SymtabToolClient.getErrorInfo().addErrorMsg("Create temp directory failed");
            return null;
        }
        Map<String, File> ps5SymbolFiles = SymtabExtractorPs.getPs5SymbolFiles(pathName);
        Vector<File> filteredFiles = new Vector<File>();
        HashSet<String> uuidSet = new HashSet<String>();
        for (File file : ps5SymbolFiles.values()) {
            String fileName = file.getName();
            String buildId = ElfParser.getUuid(file.getAbsolutePath());
            if (!uuidSet.add(buildId)) continue;
            String newName = copyPath + File.separator + buildId + "_" + fileName;
            File destFile = new File(newName);
            try {
                Files.copy(file.toPath(), destFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                SymtabToolClient.getErrorInfo().addErrorMsg(e.getMessage());
            }
            filteredFiles.add(destFile);
        }
        ps5SymbolFiles.clear();
        String zipName = pathName + "crashsightSymbol-" + UUID.randomUUID() + ".zip";
        String res = SymtabExtractorPs.zipSymtabFiles(zipName, filteredFiles);
        if (StringUtils.isNotBlank(res)) {
            return new File(res).getAbsolutePath();
        }
        return null;
    }

    private static Map<String, File> getPs5SymbolFiles(String path) {
        Map<String, File> fileMap = null;
        try (Stream<Path> paths = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            fileMap = paths.filter(f -> f.toString().endsWith(".self") || f.toString().endsWith(".prx") || f.toString().endsWith(".sym")).distinct().collect(Collectors.toMap(Path::toString, e -> e.toFile()));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return fileMap;
    }

    public static String getZipFileName(ArgsParser argsParser) {
        String fileName = argsParser.getStifZipFileName();
        File file = null;
        if (fileName != null) {
            file = new File(fileName);
        } else {
            try {
                file = File.createTempFile("tmp", ".zip");
            }
            catch (IOException e) {
                Log.error("Create temp file failed", new Object[0]);
                System.exit(-4);
            }
        }
        return file.getAbsolutePath();
    }

    public static String zipSymtabFiles(String zipFileName, Vector<File> files) {
        Log.info("Begin to zip symtab file: " + zipFileName, new Object[0]);
        if (FileHelper.zipFiles(files, zipFileName)) {
            Log.info("Successfully zipped symtab file!", new Object[0]);
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
        }
        for (File file : files) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        return zipFileName;
    }
}

