/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.generic.util.Common;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

public class SymtabExtractorNss {
    public static String extract(ArgsParser argsParser) {
        String pathName = argsParser.getFileName();
        final ArrayList<File> nssFiles = new ArrayList<File>();
        String result = null;
        try {
            Files.walkFileTree(new File(pathName).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toFile().getName().endsWith(".nss")) {
                        nssFiles.add(file.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (nssFiles.size() == 0) {
                Log.info("no nss file found", new Object[0]);
                return null;
            }
            File tmpNss = Common.zipFile(nssFiles, "nssFile");
            result = tmpNss.getAbsolutePath();
        }
        catch (Exception e) {
            SymtabToolClient.getErrorInfo().addErrorMsg(e.getMessage());
            Log.error(e.getMessage(), new Object[0]);
        }
        return result;
    }
}

