/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class SymtabExtractorLinux {
    private SymtabExtractorLinux() {
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser elfArgsParser, ElfParser elfParser, String fileName) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("LINUX_ELF");
        symtabFileInfoBean.setFileFormat(elfParser.getFileFormat());
        symtabFileInfoBean.setArch(elfParser.getArch());
        symtabFileInfoBean.setSha1(elfParser.getUuid());
        if (elfParser.getSoVersion() != null) {
            symtabFileInfoBean.setSoVersion(elfParser.getSoVersion());
        }
        symtabFileInfoBean.setFileName(fileName);
        symtabFileInfoBean.setAppName(elfArgsParser.getSoName(fileName));
        symtabFileInfoBean.setVmAddr(elfParser.getModuleBase());
        symtabFileInfoBean.setSymbolTable(elfParser.getSymbolTable());
        symtabFileInfoBean.setSymtabToolVersion("@version@");
        symtabFileInfoBean.setPvaddr(elfParser.getProgramVaddr().get(0));
        symtabFileInfoBean.setModuleBase(elfParser.getModuleBase());
        return symtabFileInfoBean;
    }

    public static String[] extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        StringBuilder stifZipFileName = new StringBuilder(argsParser.getPathName() + "crashsightSymbol");
        StringBuilder symZipFileName = new StringBuilder(argsParser.getPathName() + "crashsightBreakpadSymbol");
        HashMap<String, File> stifFiles = new HashMap<String, File>();
        HashMap<String, File> symFiles = new HashMap<String, File>();
        Vector<File> soFiles = argsParser.getSoFiles();
        if (soFiles.isEmpty()) {
            return null;
        }
        if (soFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", soFiles.get(0).getName());
        } else if (soFiles.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", pathName);
        }
        HashSet<String> processedFiles = new HashSet<String>();
        int i = 0;
        for (File soFile : soFiles) {
            long beginTime = System.currentTimeMillis();
            Log.info("Processing file: %s", soFile.getAbsolutePath());
            String fileName = null;
            try {
                fileName = soFile.getCanonicalPath();
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            ElfParser elfParser = ElfParser.create(fileName);
            if (null == elfParser) {
                SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file:" + fileName);
                Log.error("Failed to parse the file!", new Object[0]);
                continue;
            }
            Log.info("UUID: " + elfParser.getUuid(), new Object[0]);
            processedFiles.add(elfParser.getUuid());
            Log.info("stif file name %s", fileName);
            SymtabFileInfoBean symtabFileInfoBean = SymtabExtractorLinux.getSymtabFileInfoBean(argsParser, elfParser, fileName);
            symtabFileInfoBean.setSha1(elfParser.getBreakpadDebugId());
            SymtabFile symtabFile = SymtabFile.create(symtabFileInfoBean);
            if (symtabFile == null) {
                SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to create symtab file!");
                Log.error("SymtabExtractor: Failed to create symtab file!", new Object[0]);
                continue;
            }
            String symtabFileName = symtabFile.getSymtabFileName();
            if (symtabFileName == null) continue;
            if (elfParser.getSectionTable().get(".debug_abbrev") != null) {
                SymtabExtractorLinux.generateStifFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, stifFiles);
                if (i++ < 2) {
                    stifZipFileName.append("_").append(argsParser.getSoName(fileName));
                    stifZipFileName.append("_").append(elfParser.getArch());
                    stifZipFileName.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            } else if (elfParser.getSectionTable().get(".eh_frame") != null) {
                SymtabExtractorLinux.generateSymFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, symFiles);
                if (i++ < 2) {
                    symZipFileName.append("_").append(argsParser.getSoName(fileName));
                    symZipFileName.append("_").append(elfParser.getArch());
                    symZipFileName.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            }
            long endTime = System.currentTimeMillis();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", soFile.getName());
            jsonObject.addProperty("time", endTime - beginTime);
            SymtabToolClient.getJsonArray().add(jsonObject);
        }
        String[] zipFileNames = new String[2];
        if (argsParser.getSymZipFileName() != null && !argsParser.getSymZipFileName().isEmpty()) {
            Log.info("symZipFileName is  " + argsParser.getSymZipFileName(), new Object[0]);
            symZipFileName = new StringBuilder(argsParser.getSymZipFileName());
        }
        if (argsParser.getStifZipFileName() != null && !argsParser.getStifZipFileName().isEmpty()) {
            Log.info("stifZipFileName is  " + argsParser.getStifZipFileName(), new Object[0]);
            stifZipFileName = new StringBuilder(argsParser.getStifZipFileName());
        }
        if (stifFiles.size() == 0) {
            zipFileNames[0] = "";
        } else {
            FileHelper.zipFiles(new Vector<File>(stifFiles.values()), stifZipFileName.toString());
            zipFileNames[0] = stifZipFileName.toString();
        }
        if (symFiles.size() == 0) {
            zipFileNames[1] = "";
        } else {
            FileHelper.zipFiles(new Vector<File>(symFiles.values()), symZipFileName.toString());
            zipFileNames[1] = symZipFileName.toString();
        }
        for (File file : stifFiles.values()) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        for (File file : symFiles.values()) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        return zipFileNames;
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        Vector<File> soFiles = argsParser.getSoFiles();
        if (soFiles.isEmpty()) {
            return null;
        }
        if (soFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", soFiles.get(0).getName());
        } else if (soFiles.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", pathName);
        }
        Vector<String> uuids = new Vector<String>();
        for (File soFile : soFiles) {
            String fileName = null;
            try {
                fileName = soFile.getCanonicalPath();
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            uuids.add(ElfParser.getUuid(fileName));
        }
        return uuids;
    }

    private static boolean generateStifFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, ElfParser elfParser, Map<String, File> files) {
        SymtabIndexFile.vmAddr = -symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.moduleBase = symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.pvAddr = -symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
        String symtabFileName = symtabFile.getSymtabFileName();
        if (symtabFileName == null) {
            return false;
        }
        File symbolFile = new File(symtabFileName);
        if (!SymtabFileParser.parseFile(symtabFileName, symbolFile.getParent(), symtabFileInfoBean.getSymbolTable())) {
            Log.warn("Failed to parse symbol file: " + symtabFileName, new Object[0]);
        } else {
            String stifFilePath = FileHelper.changeFileSuffix(symtabFileName, "stif");
            File stifFile = new File(stifFilePath);
            Log.info("Add stif to symtab zip file: " + stifFilePath, new Object[0]);
            String stifFilePathNew = symtabFileName;
            if (symtabFileName.lastIndexOf(".") > 0) {
                stifFilePathNew = symtabFileName.substring(0, symtabFileName.lastIndexOf(".")) + "0.stif";
            }
            File stifFileNew = new File(stifFilePathNew);
            stifFile.renameTo(stifFileNew);
            files.put(stifFilePath, stifFileNew);
        }
        if (null != symtabFileInfoBean.getSymbolTable()) {
            symtabFileInfoBean.getSymbolTable().close();
        }
        if (argsParser.dumpSymbol()) {
            Log.info("Add symbol to symtab zip file: " + symtabFileName, new Object[0]);
            files.put(symtabFileName, symbolFile);
        } else if (!symbolFile.delete()) {
            symbolFile.deleteOnExit();
        }
        return true;
    }

    private static boolean generateSymFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, ElfParser elfParser, Map<String, File> breakpadFiles) {
        symtabFile.setUuid(elfParser.getBreakpadDebugId());
        Log.info("Breakpad UUID: " + elfParser.getBreakpadDebugId(), new Object[0]);
        if (symtabFile.createBreakpadSymtab(elfParser, true)) {
            Log.info("createBreakpadSymtab success", new Object[0]);
            String breakpadFilePath = symtabFile.getBreakpadSymtabFileName();
            Log.info("Add sym to breakpad symtab zip file: " + breakpadFilePath, new Object[0]);
            breakpadFiles.put(breakpadFilePath, new File(breakpadFilePath));
            String symtabFileName = symtabFile.getSymtabFileName();
            if (symtabFileName == null) {
                return false;
            }
            File symbolFile = new File(symtabFileName);
            if (!symbolFile.delete()) {
                symbolFile.deleteOnExit();
            }
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("Make breakpad failed");
            Log.error("Make breakpad failed", new Object[0]);
        }
        return true;
    }
}

