/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SymtabExtractorJs {
    public static String extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String fileName = argsParser.getFileName();
        return SymtabExtractorJs.extractByJsFileName(fileName);
    }

    public static String extractByJsFileName(String fileName) {
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        final ArrayList<File> jsFiles = new ArrayList<File>();
        String folderPath = "";
        if (f.isDirectory()) {
            try {
                folderPath = f.getCanonicalPath();
                Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (file.toFile().getName().endsWith(".map") || file.toFile().getName().endsWith(".js")) {
                            jsFiles.add(file.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                SymtabToolClient.getErrorInfo().addErrorMsg(e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                folderPath = f.getParentFile().getCanonicalPath();
                if (!fileName.endsWith(".map") && !fileName.endsWith(".js")) {
                    SymtabToolClient.getErrorInfo().addErrorMsg("not map file found");
                    return null;
                }
                jsFiles.add(f);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (jsFiles.size() == 0) {
            return null;
        }
        try {
            File tempSymbolFile = SymtabExtractorJs.zipFiles(jsFiles, folderPath, "jsFile");
            return tempSymbolFile.getCanonicalPath().toString();
        }
        catch (Exception e) {
            SymtabToolClient.getErrorInfo().addErrorMsg(e.getMessage());
            return null;
        }
    }

    public static File zipFiles(List<File> srcZipFiles, String folder, String filename) throws IOException {
        File zipedFile = File.createTempFile("crashsightSymbol", filename + ".zip");
        byte[] tempBuf = new byte[2048];
        ZipOutputStream zipOut = null;
        zipOut = new ZipOutputStream(new FileOutputStream(zipedFile));
        BufferedOutputStream bos = new BufferedOutputStream(zipOut, 2048);
        HashSet isDuplicateFile = new HashSet();
        for (File srcZipFile : srcZipFiles) {
            String relativePath = new File(folder).toURI().relativize(srcZipFile.toURI()).getPath();
            FileInputStream input = new FileInputStream(srcZipFile);
            ZipEntry tempZipEntry = new ZipEntry(relativePath);
            tempZipEntry.setTime(0L);
            zipOut.putNextEntry(tempZipEntry);
            BufferedInputStream zis = new BufferedInputStream(input);
            int count = 0;
            while ((count = zis.read(tempBuf, 0, 2048)) != -1) {
                bos.write(tempBuf, 0, count);
            }
            bos.flush();
            ((InputStream)input).close();
        }
        zipOut.close();
        return zipedFile;
    }
}

