/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.mach.MachFatHeaderParser;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class SymtabExtractorIos {
    private SymtabExtractorIos() {
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser machArgsParser, MachParser machParser, String fileName) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("Mach-O");
        symtabFileInfoBean.setFileFormat(machParser.getFileFormat());
        symtabFileInfoBean.setArch(machParser.getArch());
        symtabFileInfoBean.setUuid(machParser.getUuid());
        symtabFileInfoBean.setFileName(fileName);
        symtabFileInfoBean.setAppName(machArgsParser.getDsymName(fileName));
        symtabFileInfoBean.setVmAddr(machParser.getVmAddr());
        symtabFileInfoBean.setSymbolTable(machParser.getSymbolTable());
        symtabFileInfoBean.setSymtabToolVersion("@version@");
        return symtabFileInfoBean;
    }

    public static String extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        StringBuilder zipFileName = new StringBuilder("crashsightSymbol");
        HashMap<String, File> files = new HashMap<String, File>();
        Vector<File> dSymFiles = argsParser.getdSymFiles();
        if (dSymFiles.isEmpty()) {
            return null;
        }
        if (dSymFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", dSymFiles.get(0).getName());
        } else if (dSymFiles.size() > 1) {
            Log.info("Extracting symtab files of directory: %s with %d files", pathName, dSymFiles.size());
        }
        if (argsParser.uploadDsym()) {
            for (File dSymFile : dSymFiles) {
                files.put(dSymFile.getAbsolutePath(), dSymFile);
            }
        } else {
            int i = 0;
            boolean hasProcessed = false;
            HashSet<String> uuidSet = new HashSet<String>();
            for (File dSymFile : dSymFiles) {
                long beginTime = System.currentTimeMillis();
                String fileName = null;
                try {
                    fileName = dSymFile.getCanonicalPath();
                }
                catch (IOException e) {
                    Log.error(e);
                    return null;
                }
                MachFatHeaderParser machFatHeader = new MachFatHeaderParser(fileName);
                Vector<Long> offsetTable = machFatHeader.getOffsetTable();
                machFatHeader.close();
                if (null == offsetTable) {
                    SymtabToolClient.getErrorInfo().addErrorMsg("Failed to read Mach-0 file");
                    Log.error("SymtabExtractor Mach-O\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01", new Object[0]);
                    continue;
                }
                for (Long l : offsetTable) {
                    String uuid = MachParser.getUuid(fileName, l);
                    if (uuidSet.contains(uuid)) {
                        hasProcessed = true;
                        break;
                    }
                    uuidSet.add(uuid);
                }
                if (hasProcessed) {
                    Log.info("Ignore this dSYM file for it has been processed before: " + fileName, new Object[0]);
                    continue;
                }
                StringBuilder archInfoSuffix = new StringBuilder();
                for (Long offset3 : offsetTable) {
                    MachParser machParser = MachParser.create(fileName, offset3, false);
                    if (null == machParser) {
                        SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file!");
                        Log.error("Failed to parse the file!", new Object[0]);
                        return null;
                    }
                    SymtabFileInfoBean symtabFileInfoBean = SymtabExtractorIos.getSymtabFileInfoBean(argsParser, machParser, fileName);
                    SymtabFile symtabFile = SymtabFile.create(symtabFileInfoBean);
                    SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
                    if (null == symtabFile) {
                        SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to create symtab file!");
                        Log.error("SymtabExtractor: Failed to create symtab file!", new Object[0]);
                        continue;
                    }
                    String symtabFileName = symtabFile.getSymtabFileName();
                    if (symtabFileName == null) continue;
                    File symbolFile = new File(symtabFileName);
                    if (!SymtabFileParser.parseFile(symtabFileName, symbolFile.getParent(), symtabFileInfoBean.getSymbolTable())) {
                        Log.warn("Failed to parse symbol file: " + symtabFileName, new Object[0]);
                    } else {
                        String stifFilePath = FileHelper.changeFileSuffix(symtabFileName, "stif");
                        File stifFile = new File(stifFilePath);
                        if (stifFile.exists()) {
                            Log.info("Add stif to symtab zip file: " + stifFilePath, new Object[0]);
                            files.put(stifFilePath, stifFile);
                        }
                    }
                    if (argsParser.dumpSymbol()) {
                        Log.info("Add symbol to symtab zip file: " + symtabFileName, new Object[0]);
                        files.put(symtabFileName, symbolFile);
                    } else if (!symbolFile.delete()) {
                        symbolFile.deleteOnExit();
                    }
                    archInfoSuffix.append("_").append(machParser.getArch());
                    archInfoSuffix.append("-").append(machParser.getUuid().substring(0, 5));
                    machParser.close();
                }
                if (i++ < 2) {
                    zipFileName.append("_").append(argsParser.getDsymName(fileName)).append((CharSequence)archInfoSuffix);
                }
                long l = System.currentTimeMillis();
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("name", dSymFile.getName());
                jsonObject.addProperty("time", l - beginTime);
                SymtabToolClient.getJsonArray().add(jsonObject);
            }
            if (files.isEmpty()) {
                Log.error("Files is empty.", new Object[0]);
                return null;
            }
            Log.info("There are %d stif files", files.size());
        }
        zipFileName.append(".zip");
        if (StringUtils.isNotEmpty(argsParser.getStifZipFileName())) {
            zipFileName = new StringBuilder(argsParser.getStifZipFileName());
        } else if (argsParser.uploadDsym()) {
            zipFileName = new StringBuilder(pathName + argsParser.getFileName() + ".zip");
        } else {
            zipFileName.insert(0, pathName);
        }
        Log.info("Begin to zip symtab file: " + zipFileName, new Object[0]);
        boolean zipRes = FileHelper.zipFiles(new Vector<File>(files.values()), zipFileName.toString());
        if (zipRes) {
            Log.info("Successfully zipped symtab file!", new Object[0]);
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
        }
        if (!argsParser.uploadDsym()) {
            for (File file : files.values()) {
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
        return zipFileName.toString();
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        Vector<File> dSymFiles = argsParser.getdSymFiles();
        if (dSymFiles.isEmpty()) {
            return null;
        }
        if (dSymFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", dSymFiles.get(0).getName());
        } else if (dSymFiles.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", pathName);
        }
        Vector<String> uuids = new Vector<String>();
        for (File dSymFile : dSymFiles) {
            String fileName = null;
            try {
                fileName = dSymFile.getCanonicalPath();
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            MachFatHeaderParser machFatHeader = new MachFatHeaderParser(fileName);
            Vector<Long> offsetTable = machFatHeader.getOffsetTable();
            machFatHeader.close();
            if (null == offsetTable) {
                SymtabToolClient.getErrorInfo().addErrorMsg("Failed to read Mach-O file\uff01");
                Log.error("SymtabExtractor Mach-O\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01", new Object[0]);
                return null;
            }
            for (Long offset : offsetTable) {
                uuids.add(MachParser.getUuid(fileName, offset));
            }
        }
        return uuids;
    }
}

