/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class SymtabExtractorAndroid {
    private SymtabExtractorAndroid() {
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser elfArgsParser, ElfParser elfParser, String fileName) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("ELF");
        symtabFileInfoBean.setFileFormat(elfParser.getFileFormat());
        symtabFileInfoBean.setArch(elfParser.getArch());
        symtabFileInfoBean.setSha1(elfParser.getUuid());
        if (elfParser.getSoVersion() != null) {
            symtabFileInfoBean.setSoVersion(elfParser.getSoVersion());
        }
        symtabFileInfoBean.setFileName(fileName);
        symtabFileInfoBean.setAppName(elfArgsParser.getSoName(fileName));
        symtabFileInfoBean.setVmAddr(elfArgsParser.getOffsetAddress());
        symtabFileInfoBean.setSymbolTable(elfParser.getSymbolTable());
        symtabFileInfoBean.setSymtabToolVersion("@version@");
        symtabFileInfoBean.setPvaddr(elfParser.getProgramVaddr().get(0));
        symtabFileInfoBean.setPOffset(elfParser.getProgramOffset().get(0));
        return symtabFileInfoBean;
    }

    public static String[] extract(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        Vector<File> soFiles = argsParser.getSoFiles();
        StringBuilder stifZipFileName = new StringBuilder(argsParser.getPathName() + "crashsightSymbol");
        StringBuilder symZipFileName = new StringBuilder(argsParser.getPathName() + "crashsightBreakpadSymbol");
        HashMap<String, File> stifFiles = new HashMap<String, File>();
        HashMap<String, File> symFiles = new HashMap<String, File>();
        if (soFiles.isEmpty()) {
            return null;
        }
        if (soFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", soFiles.get(0).getName());
        } else if (soFiles.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", pathName);
        }
        HashSet<String> processedFiles = new HashSet<String>();
        int i = 0;
        for (File soFile : soFiles) {
            boolean res;
            long beginTime = System.currentTimeMillis();
            Log.info("Processing file: %s", soFile.getAbsolutePath());
            String fileName = null;
            try {
                fileName = soFile.getCanonicalPath();
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            ElfParser elfParser = ElfParser.create(fileName);
            if (null == elfParser) {
                SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file:" + fileName);
                Log.error("Failed to parse the file!", new Object[0]);
                continue;
            }
            Log.info("UUID: " + elfParser.getUuid(), new Object[0]);
            if (processedFiles.contains(elfParser.getUuid())) {
                Log.info("Ignore this SO file for it has been processed before: " + fileName, new Object[0]);
                continue;
            }
            if (argsParser.getSymbolPlatform().equals("hm")) {
                processedFiles.add(elfParser.getFullUuid());
            } else {
                processedFiles.add(elfParser.getUuid());
            }
            Log.info("stif file name %s", fileName);
            SymtabFileInfoBean symtabFileInfoBean = SymtabExtractorAndroid.getSymtabFileInfoBean(argsParser, elfParser, fileName);
            SymtabFile symtabFile = SymtabFile.create(symtabFileInfoBean);
            if (symtabFile == null) {
                SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to create symtab file!");
                Log.error("SymtabExtractor: Failed to create symtab file!", new Object[0]);
                continue;
            }
            String symtabFileName = symtabFile.getSymtabFileName();
            if (symtabFileName == null) continue;
            if (argsParser.getDumpStif()) {
                res = SymtabExtractorAndroid.generateStifFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, stifFiles);
                if (!res) continue;
                if (i++ < 2) {
                    stifZipFileName.append("_").append(argsParser.getSoName(fileName));
                    stifZipFileName.append("_").append(elfParser.getArch());
                    stifZipFileName.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            }
            if (argsParser.getDumpCfi()) {
                res = SymtabExtractorAndroid.generateSymFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, symFiles, true);
                if (!res) continue;
                if (i++ < 2) {
                    symZipFileName.append("_").append(argsParser.getSoName(fileName));
                    symZipFileName.append("_").append(elfParser.getArch());
                    symZipFileName.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            }
            if (argsParser.getDumpSym()) {
                res = SymtabExtractorAndroid.generateSymFile(symtabFileInfoBean, argsParser, symtabFile, elfParser, symFiles, false);
                if (!res) continue;
                if (i++ < 2) {
                    symZipFileName.append("_").append(argsParser.getSoName(fileName));
                    symZipFileName.append("_").append(elfParser.getArch());
                    symZipFileName.append("-").append(elfParser.getUuid().substring(0, 5)).append(".zip");
                }
            }
            long endTime = System.currentTimeMillis();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", soFile.getName());
            jsonObject.addProperty("time", endTime - beginTime);
            SymtabToolClient.getJsonArray().add(jsonObject);
        }
        String[] zipFileNames = new String[2];
        if (argsParser.getSymZipFileName() != null && !argsParser.getSymZipFileName().isEmpty()) {
            Log.info("symZipFileName is  " + argsParser.getSymZipFileName(), new Object[0]);
            symZipFileName = new StringBuilder(argsParser.getSymZipFileName());
        }
        if (argsParser.getStifZipFileName() != null && !argsParser.getStifZipFileName().isEmpty()) {
            Log.info("stifZipFileName is  " + argsParser.getStifZipFileName(), new Object[0]);
            stifZipFileName = new StringBuilder(argsParser.getStifZipFileName());
        }
        if (stifFiles.size() == 0) {
            zipFileNames[0] = "";
        } else {
            FileHelper.zipFiles(new Vector<File>(stifFiles.values()), stifZipFileName.toString());
            zipFileNames[0] = stifZipFileName.toString();
        }
        if (symFiles.size() == 0) {
            zipFileNames[1] = "";
        } else {
            FileHelper.zipFiles(new Vector<File>(symFiles.values()), symZipFileName.toString());
            zipFileNames[1] = symZipFileName.toString();
        }
        for (File file : stifFiles.values()) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        return zipFileNames;
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String pathName = argsParser.getPathName();
        Vector<File> soFiles = argsParser.getSoFiles();
        if (soFiles.isEmpty()) {
            return null;
        }
        if (soFiles.size() == 1) {
            Log.info("Extracting symtab file: %s", soFiles.get(0).getName());
        } else {
            Log.info("Extracting symtab files of directory: %s", pathName);
        }
        Vector<String> uuids = new Vector<String>();
        for (File soFile : soFiles) {
            String fileName = null;
            try {
                fileName = soFile.getCanonicalPath();
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            uuids.add(ElfParser.getUuid(fileName));
        }
        return uuids;
    }

    private static boolean generateStifFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, ElfParser elfParser, Map<String, File> files) {
        SymtabIndexFile.vmAddr = -symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.moduleBase = symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.pvAddr = -symtabFileInfoBean.getModuleBase();
        SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
        String symtabFileName = symtabFile.getSymtabFileName();
        if (symtabFileName == null) {
            return false;
        }
        File symbolFile = new File(symtabFileName);
        if (!SymtabFileParser.parseFile(symtabFileName, symbolFile.getParent(), symtabFileInfoBean.getSymbolTable())) {
            Log.warn("Failed to parse symbol file: " + symtabFileName, new Object[0]);
        } else {
            String stifFilePath = FileHelper.changeFileSuffix(symtabFileName, "stif");
            File stifFile = new File(stifFilePath);
            if (argsParser.getSymbolPlatform().equals("hm")) {
                String stifFilePathNew = symtabFileName;
                if (symtabFileName.lastIndexOf(".") > 0) {
                    String oldUuid = elfParser.getUuid();
                    String newUuid = elfParser.getFullUuid();
                    symtabFileName = symtabFileName.replace(oldUuid, newUuid);
                    stifFilePathNew = symtabFileName.substring(0, symtabFileName.lastIndexOf(".")) + ".stif";
                }
                File stifFileNew = new File(stifFilePathNew);
                stifFile.renameTo(stifFileNew);
                Log.info("Add stif to symtab zip file: " + stifFilePathNew, new Object[0]);
                files.put(stifFilePathNew, stifFileNew);
            } else if (!argsParser.getIdStyle().equals("ori")) {
                String stifFilePathNew = symtabFileName;
                if (symtabFileName.lastIndexOf(".") > 0) {
                    String oldUuid = elfParser.getUuid();
                    String newUuid = elfParser.getBreakpadDebugId();
                    symtabFileName = symtabFileName.replace(oldUuid, newUuid);
                    stifFilePathNew = symtabFileName.substring(0, symtabFileName.lastIndexOf(".")) + "0.stif";
                }
                File stifFileNew = new File(stifFilePathNew);
                stifFile.renameTo(stifFileNew);
                Log.info("Add stif to symtab zip file: " + stifFilePathNew, new Object[0]);
                files.put(stifFilePathNew, stifFileNew);
            } else {
                files.put(stifFilePath, stifFile);
            }
        }
        if (null != symtabFileInfoBean.getSymbolTable()) {
            symtabFileInfoBean.getSymbolTable().close();
        }
        if (argsParser.dumpSymbol()) {
            Log.info("Add symbol to symtab zip file: " + symtabFileName, new Object[0]);
            files.put(symtabFileName, symbolFile);
        } else if (!symbolFile.delete()) {
            symbolFile.deleteOnExit();
        }
        return true;
    }

    private static boolean generateSymFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, ElfParser elfParser, Map<String, File> breakpadFiles, boolean onliCfi) {
        symtabFile.setUuid(elfParser.getBreakpadDebugId());
        Log.info("Breakpad UUID: " + elfParser.getBreakpadDebugId(), new Object[0]);
        if (symtabFile.createBreakpadSymtab(elfParser, onliCfi)) {
            Log.info("createBreakpadSymtab success", new Object[0]);
            String breakpadFilePath = symtabFile.getBreakpadSymtabFileName();
            Log.info("Add sym to breakpad symtab zip file: " + breakpadFilePath, new Object[0]);
            breakpadFiles.put(breakpadFilePath, new File(breakpadFilePath));
            String symtabFileName = symtabFile.getSymtabFileName();
            if (symtabFileName == null) {
                return false;
            }
            File symbolFile = new File(symtabFileName);
            if (!symbolFile.delete()) {
                symbolFile.deleteOnExit();
            }
        } else {
            SymtabToolClient.getErrorInfo().addErrorMsg("Make breakpad failed");
            Log.error("Make breakpad failed", new Object[0]);
        }
        return true;
    }
}

