/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabtool.common.upload.HttpClientHelper;
import com.uqm.crashsight.symtabtool.common.upload.SymtabFileUploader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.SymtabToolLogPrinter;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorAndroid;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorIos;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorJs;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorLinux;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorNss;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorPs;
import com.uqm.crashsight.symtabtool.generic.extractor.SymtabExtractorWin;
import com.uqm.crashsight.symtabtool.generic.util.Common;
import com.uqm.crashsight.symtabtool.generic.util.CosUploader;
import com.uqm.crashsight.symtabtool.generic.util.ErrorInfo;
import com.uqm.crashsight.symtabtool.mach.MachFatHeaderParser;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class SymtabToolClient {
    public static final String SYMTAB_TOOL_VERSION = "@version@";
    private static final int EXIT_VALUE_SUCCESS = 0;
    private static final int EXIT_VALUE_ARGS_ERROR = -1;
    private static final int EXIT_VALUE_SYMTAB_ERROR = -2;
    private static final int EXIT_VALUE_UPLOAD_ERROR = -3;
    private static final int EXIT_VALUE_DUMP_UUID_ERROR = -4;
    public static boolean isDebug = false;
    public static boolean extracted = false;
    public static boolean uploaded = false;
    private static ErrorInfo errorInfo = new ErrorInfo();
    private static JsonArray jsonArray = new JsonArray();

    public static ErrorInfo getErrorInfo() {
        return errorInfo;
    }

    public static JsonArray getJsonArray() {
        return jsonArray;
    }

    private static void setLogPrinter() {
        Log.setPrinter(new SymtabToolLogPrinter());
    }

    private static String[] getTestArgs() {
        String appId = "0ac88aa5a3";
        String appKey = "8fb5d416-7cc7-46c7-a7ee-fd953ad3f9a3";
        String appPackage = "com.uqm.crashsight.demo";
        String appVersion = "5.0";
        String input = "./test/";
        return new String[]{"-d", "-u", "-symbol", "-package", appPackage, "-version", appVersion, "-id", appId, "-key", appKey, "-i", input, "-url", "https://test-crashsight.wetest.qq.com/openapi/file/upload/symbol"};
    }

    private static boolean dumpUuid(ArgsParser argsParser) {
        Vector<File> soFiles = argsParser.getSoFiles();
        if (argsParser.getSymbolPlatform().equals("aos")) {
            if (soFiles.isEmpty()) {
                Log.error("Please specify SO files to dump UUID.", new Object[0]);
                ArgsParser.printHelp();
                return false;
            }
            Log.setEnable(false);
            for (File soFile : soFiles) {
                String uuid;
                String filePath = soFile.getAbsolutePath();
                String arch = ElfParser.getArch(filePath);
                if (arch == null) {
                    Log.warn("Failed to get architecture of file: " + filePath, new Object[0]);
                    arch = "unknown";
                }
                if ((uuid = ElfParser.getUuid(filePath)) == null) {
                    Log.warn("Failed to get UUID of file: " + filePath, new Object[0]);
                    uuid = "unknown";
                }
                System.out.printf("%s [%s] %s\n", filePath, arch, uuid);
            }
            System.out.println();
            Log.setEnable(true);
            return true;
        }
        if (argsParser.getSymbolPlatform().equals("ios")) {
            Vector<File> symFiles = argsParser.getdSymFiles();
            if (symFiles.isEmpty()) {
                Log.error("Please specify SO files to dump UUID.", new Object[0]);
                ArgsParser.printHelp();
                return false;
            }
            Vector<String> uuidStrings = new Vector<String>();
            for (File symFile : symFiles) {
                String filePath = symFile.getAbsolutePath();
                MachFatHeaderParser machFatHeader = new MachFatHeaderParser(filePath);
                Vector<Long> offsetTable = machFatHeader.getOffsetTable();
                machFatHeader.close();
                if (null == offsetTable) {
                    Log.error("Failed to parse header of file: " + filePath, new Object[0]);
                    continue;
                }
                for (Long offset : offsetTable) {
                    String uuid;
                    String arch = MachParser.getArch(filePath, offset);
                    if (arch == null) {
                        Log.warn("Failed to get architecture of file: " + filePath, new Object[0]);
                        arch = "unknown";
                    }
                    if ((uuid = MachParser.getUuid(filePath, offset)) == null) {
                        Log.warn("Failed to get UUID of file: " + filePath, new Object[0]);
                        uuid = "unknown";
                    }
                    uuidStrings.add(Log.format("%s [%s] %s", filePath, arch, uuid));
                }
            }
            Log.setEnable(false);
            for (String uuidString : uuidStrings) {
                System.out.println(uuidString);
            }
            System.out.println();
            Log.setEnable(true);
        }
        return false;
    }

    private static boolean uploadSymtabFile(final List<String> fileNames, final ArgsParser argsParser, final List<String> symbolType) {
        int networkTimeout = argsParser.getNetworkTimeout();
        if (networkTimeout > 0) {
            HttpClientHelper.setNetworkTimeout(networkTimeout * 1000);
        }
        int cores = Runtime.getRuntime().availableProcessors();
        cores = Math.max(cores, fileNames.size());
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        ArrayList<Future<JsonObject>> futures = new ArrayList<Future<JsonObject>>();
        for (int i = 0; i < fileNames.size(); ++i) {
            if (StringUtils.isEmpty(fileNames.get(i))) continue;
            final int finalI = i;
            Future<JsonObject> future = executor.submit(new Callable<JsonObject>(){

                @Override
                public JsonObject call() throws Exception {
                    File symtabFile;
                    SymtabFileUploader.UploadInfo uploadInfo = new SymtabFileUploader.UploadInfo();
                    uploadInfo.appId = argsParser.getAppId();
                    uploadInfo.appKey = argsParser.getAppKey();
                    uploadInfo.appVersion = argsParser.getAppVersion();
                    uploadInfo.appPackage = argsParser.getAppPackage();
                    uploadInfo.crashSightVersion = argsParser.getCrashSightVersion();
                    uploadInfo.uploadUrl = argsParser.getUploadUrl();
                    uploadInfo.symbolType = (String)symbolType.get(finalI);
                    uploadInfo.file = symtabFile = new File((String)fileNames.get(finalI));
                    uploadInfo.fileName = symtabFile.getName();
                    uploadInfo.appChannel = argsParser.getAppChannel();
                    JsonObject resultJson = new JsonObject();
                    if (!uploadInfo.fileName.equals("")) {
                        long beginTime = System.currentTimeMillis();
                        JsonObject jsonObject = SymtabFileUploader.uploadSymtabFile(uploadInfo);
                        boolean ret = jsonObject != null && jsonObject.get("result").getAsBoolean();
                        long endTime = System.currentTimeMillis();
                        resultJson.addProperty("time", endTime - beginTime);
                        resultJson.addProperty("result", ret);
                        resultJson.addProperty("name", uploadInfo.fileName);
                        if (!ret && jsonObject != null) {
                            resultJson.addProperty("message", jsonObject.get("message").getAsString());
                        }
                    }
                    return resultJson;
                }
            });
            futures.add(future);
        }
        JsonObject reportJson = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        int success = 0;
        boolean flag = true;
        int all = 0;
        for (Future future : futures) {
            try {
                JsonObject jsonObject = (JsonObject)future.get();
                ++all;
                if (jsonObject.get("result").getAsBoolean()) {
                    jsonArray.add(jsonObject);
                    ++success;
                    continue;
                }
                JsonElement jsonElement = jsonObject.get("message");
                if (jsonElement != null) {
                    SymtabToolClient.getErrorInfo().addErrorMsg(jsonElement.getAsString());
                }
                flag = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
        reportJson.addProperty("all", all);
        reportJson.addProperty("success", success);
        reportJson.addProperty("info", jsonArray.toString());
        ErrorInfo reportInfo = new ErrorInfo();
        reportInfo.setAppKey(argsParser.getAppKey());
        reportInfo.setAppId(argsParser.getAppId());
        reportInfo.setType("jar-statistics");
        reportInfo.setUploadResult(reportJson.toString());
        SymtabToolClient.reportError(argsParser.getUploadUrl(), reportInfo);
        return flag;
    }

    public static void main(String[] args2) {
        ArgsParser argsParser;
        SymtabToolClient.setLogPrinter();
        Log.setEnable(true);
        if (isDebug) {
            args2 = SymtabToolClient.getTestArgs();
        }
        if (null == (argsParser = ArgsParser.create(args2))) {
            Log.error("Please input right args.", new Object[0]);
            System.exit(-1);
        }
        Log.setDebugMode(argsParser.isDebug());
        SymtabToolClient.getErrorInfo().setAppId(argsParser.getAppId());
        SymtabToolClient.getErrorInfo().setAppKey(argsParser.getAppKey());
        System.out.println("CrashSight Symtab Tool for @version@");
        if (argsParser.dumpUuid()) {
            if (!SymtabToolClient.dumpUuid(argsParser)) {
                System.exit(-4);
            } else {
                System.exit(0);
            }
        }
        ArrayList<String> symbolFileName = new ArrayList<String>();
        ArrayList<String> symbolType = new ArrayList<String>();
        if (argsParser.getSymbolPlatform().equals("aos") || argsParser.getSymbolPlatform().equals("hm")) {
            Log.info("Processing Android symbols.", new Object[0]);
            symbolType.add("3");
            symbolType.add("3");
            String[] fileNames = SymtabExtractorAndroid.extract(argsParser);
            if (fileNames != null) {
                symbolFileName.addAll(Arrays.asList(fileNames));
            }
            if (argsParser.getMappingFileName() != null) {
                File mappingFile = new File(argsParser.getMappingFileName());
                if (mappingFile.exists() && mappingFile.getName().endsWith(".txt")) {
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(mappingFile);
                    File zipFile = null;
                    try {
                        zipFile = Common.zipFile(files, "mappingFile");
                        symbolFileName.add(zipFile.getAbsolutePath());
                        symbolType.add("1");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    SymtabToolClient.getErrorInfo().addErrorMsg("apping file to upload is not valid:" + mappingFile.getAbsolutePath());
                    Log.error("Mapping file to upload is not valid: %s", mappingFile.getAbsolutePath());
                }
            }
            if (argsParser.getJsFileName() != null) {
                String jsFileName = SymtabExtractorJs.extractByJsFileName(argsParser.getJsFileName());
                symbolFileName.add(jsFileName);
                symbolType.add("30");
            }
            boolean bl = extracted = fileNames != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
        } else if (argsParser.getSymbolPlatform().equals("ios")) {
            Log.info("Processing iOS symbols.", new Object[0]);
            symbolType.add("2");
            String iosFileName = SymtabExtractorIos.extract(argsParser);
            boolean bl = extracted = iosFileName != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            symbolFileName.add(iosFileName);
        } else if (argsParser.getSymbolPlatform().equals("win")) {
            Log.info("Processing Windows symbols.", new Object[0]);
            if (argsParser.getParseMode().equals("") || argsParser.getParseMode().equals("ori")) {
                symbolType.add("10");
            } else {
                symbolType.add("11");
                symbolType.add("12");
            }
            String[] winFileNames = SymtabExtractorWin.getInstance().extract(argsParser);
            boolean bl = extracted = winFileNames != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            symbolFileName.addAll(Arrays.asList(winFileNames));
        } else if (argsParser.getSymbolPlatform().equals("linux")) {
            Log.info("Processing Linux symbols.", new Object[0]);
            String[] linuxFileNames = SymtabExtractorLinux.extract(argsParser);
            symbolType.add("20");
            symbolType.add("21");
            boolean bl = extracted = linuxFileNames != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            symbolFileName.addAll(Arrays.asList(linuxFileNames));
        } else if (argsParser.getSymbolPlatform().equals("js")) {
            String jsFileName = SymtabExtractorJs.extract(argsParser);
            symbolType.add("30");
            boolean bl = extracted = jsFileName != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            symbolFileName.add(jsFileName);
        } else if (argsParser.getSymbolPlatform().equals("ps5")) {
            String psFileName = SymtabExtractorPs.extract(argsParser);
            symbolType.add("14");
            boolean bl = extracted = psFileName != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            symbolFileName.add(psFileName);
        } else if (argsParser.getSymbolPlatform().equals("switch")) {
            String switchFileName = SymtabExtractorNss.extract(argsParser);
            boolean bl = extracted = switchFileName != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            symbolFileName.add(switchFileName);
            symbolType.add("13");
        } else if (argsParser.getSymbolPlatform().equals("xbox")) {
            argsParser.setParseMode("win");
            String[] xboxFileNames = SymtabExtractorWin.getInstance().extract(argsParser);
            boolean bl = extracted = xboxFileNames != null;
            if (!extracted) {
                SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
                System.exit(-2);
            }
            for (int i = 0; i < xboxFileNames.length; ++i) {
                symbolFileName.add(xboxFileNames[i]);
                symbolType.add("15");
            }
        } else {
            Log.error("Unsupport platform %s", argsParser.getSymbolPlatform());
        }
        if (!SymtabToolClient.getJsonArray().isEmpty()) {
            ErrorInfo makeInfo = new ErrorInfo();
            makeInfo.setAppKey(argsParser.getAppKey());
            makeInfo.setAppId(argsParser.getAppId());
            makeInfo.setType("make-statistics");
            makeInfo.setUploadResult(SymtabToolClient.getJsonArray().toString());
            SymtabToolClient.reportError(argsParser.getUploadUrl(), makeInfo);
        }
        if (argsParser.shouldUpload()) {
            System.out.println("Start to upload");
            if (argsParser.getUploadCos()) {
                try {
                    URL url = new URL(argsParser.getUploadUrl());
                    String domain = url.getHost();
                    CosUploader cosUploader = new CosUploader(argsParser.getAppId(), argsParser.getAppKey(), domain, argsParser.getAppPackage(), argsParser.getAppVersion(), argsParser.getSymbolPlatform());
                    for (int i = 0; i < symbolType.size(); ++i) {
                        if (symbolFileName.size() <= i || StringUtils.isEmpty((CharSequence)symbolFileName.get(i)) || !Files.exists(Paths.get((String)symbolFileName.get(i), new String[0]), new LinkOption[0])) continue;
                        uploaded = ((String)symbolType.get(i)).equals("30") ? cosUploader.uploadFile(new File((String)symbolFileName.get(i)), (String)symbolType.get(i)) : cosUploader.uploadFile(new File(Common.splitZipFiles((String)symbolFileName.get(i), (String)symbolType.get(i))), (String)symbolType.get(i));
                    }
                }
                catch (Exception e) {
                    Log.error(e);
                    uploaded = false;
                }
            }
            if (!uploaded) {
                uploaded = SymtabToolClient.uploadSymtabFile(symbolFileName, argsParser, symbolType);
            }
        }
        if (argsParser.shouldUpload() && !uploaded) {
            SymtabToolClient.reportError(argsParser.getUploadUrl(), SymtabToolClient.getErrorInfo());
            System.exit(-3);
        }
    }

    private static void reportError(String uploadUrl, ErrorInfo errorInfo) {
        try {
            URL url = new URL(uploadUrl);
            CosUploader cosUploader = new CosUploader(url.getHost());
            cosUploader.reportError(errorInfo);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

