/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic;

import com.uqm.crashsight.symtabtool.common.file.SettingFileParser;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ArgsParser {
    public static final String CRASHSIGHT_VERSION_2X = "2.x";
    private static final String DSYM_SUFFIX = ".app.dSYM";
    private static final String DSYM_SUFFIX_EX = ".appex.dSYM";
    private static final String IS_DEBUG = "-d";
    private static final String INPUT_FILE = "-i";
    private static final String OUTPUT_FILE = "-o";
    private static final String SYM_OUTPUT_FILE = "-osym";
    private static final String STIF_OUTPUT_FILE = "-ostif";
    private static final String SETTING_FILE = "-s";
    private static final String UPLOAD = "-u";
    private static final String DUMP_UUID = "-uuid";
    private static final String DUMP_SYMBOL = "-symbol";
    private static final String APP_ID = "-id";
    private static final String APP_KEY = "-key";
    private static final String APP_VERSION = "-version";
    private static final String APP_PACKAGE = "-package";
    private static final String CRASHSIGHT_VERSION = "-crashsight";
    private static final String NETWORK_TIMEOUT = "-timeout";
    private static final String UPLOAD_URL = "-url";
    private static final String PARSE_MODE = "-m";
    private static final String SYMBOL_PLATFORM = "-p";
    private static final String UPLOAD_PROXY = "-proxy";
    private static final String ONLY_REBUILD_DSYM = "-onlyrebuild";
    private static final String REBUILD_DSYM = "-rebuild";
    private static final String DUMP_STACK_VARIABLE = "-stackVariable";
    private static final String DUMP_STIF = "-stif";
    private static final String DUMP_CFI = "-cfi";
    private static final String DUMP_SYM = "-sym";
    private static final String ID_STYLE = "-idstyle";
    private static final String UPLOAD_COS = "-uploadcos";
    private static final String MAPPING_FILE = "-mapping";
    private static final String JS_FILE = "-jsFile";
    private Vector<File> dSymFiles = new Vector();
    private Vector<File> soFiles = new Vector();
    private String zipFileName = null;
    private String symZipFileName = null;
    private String stifZipFileName = null;
    private String pathName = null;
    private String fileName = null;
    private String appId = null;
    private String appKey = null;
    private String appVersion = null;
    private String appPackage = null;
    private String appChannel = null;
    private long offsetAddress = 0L;
    private boolean shouldUpload = false;
    private boolean dumpUuid = false;
    private boolean dumpSymbol = false;
    private boolean isDebug = false;
    public String crashsightVersion = "2.x";
    private boolean uploadDsym = false;
    private int networkTimeout = -1;
    private String uploadUrl = null;
    private String parseMode = "";
    private String symbolPlatform = "aos";
    private String mappingFileName = null;
    private String upload_proxy = "";
    private boolean onlyRebuildDsym = false;
    private boolean rebuildDsym = false;
    private boolean dumpStackVariable = false;
    private boolean dumpSym = false;
    private boolean dumpCfi = false;
    private boolean dumpStif = false;
    private String idStyle = "";
    private boolean uploadCos = false;
    private String jsFileName = null;

    public static void printHelp() {
        System.out.println("\nCrashSight Symtab Tool\n-------------------------------------------------------------------\n");
        System.out.println("-- Usage\n Java -jar CrashSightWin.jar -i <input> [-o <output>] [-d] [-s <setting file>] [-u -id <APP ID> -key <APP key>] -version <APP version> [-m <modle>]  [-p <platform>]\n");
        System.out.println("\u53c2\u6570\u8bf4\u660e -- Introduction for arguments\n -i    \u6307\u5b9a\u6587\u4ef6\u8def\u5f84\uff0c\u53ef\u6307\u5b9a\u76ee\u5f55 -- File path which contain debug info\n -o    \u8f93\u51fa\u7684\u7b26\u53f7\u8868zip\u6587\u4ef6\u7684\u8def\u5f84\uff0c\u5fc5\u987b\u662fzip\u6587\u4ef6 -- The output symbol.zip file path, it need to be named *.zip\n -d        \u5f00\u542f\u8c03\u8bd5\u6a21\u5f0f -- Open debug mode\n -s    \u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\uff08\u9ed8\u8ba4\u8bfb\u53d6JAR\u76ee\u5f55\u4e0b\u7684\u201csettings.txt\u201d\u6587\u4ef6\uff09 -- Specify the setting file\n -u    \u4e0a\u4f20 -- Upload to CrashSight\n -id        APP ID -- APP ID of CrashSight\n -key  APP key -- APP key of CrashSight\n -version  APP\u7248\u672c -- APP version name\n -m  \u4e0a\u4f20\u7b26\u53f7\u8868\u6a21\u5f0f -- ori/win default is ori\n -p  \u4e0a\u4f20\u7b26\u53f7\u8868\u6240\u5c5e\u5e73\u53f0 -- aos/ios/win/js/ps5 default is aos\n");
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean uploadDsym() {
        return this.uploadDsym;
    }

    public boolean shouldUpload() {
        return this.shouldUpload;
    }

    public boolean dumpUuid() {
        return this.dumpUuid;
    }

    public boolean dumpSymbol() {
        return this.dumpSymbol;
    }

    private ArgsParser() {
    }

    public boolean getOnlyRebuildDsym() {
        return this.onlyRebuildDsym;
    }

    public boolean getRebuildDsym() {
        return this.rebuildDsym;
    }

    public boolean dumpStackVariable() {
        return this.dumpStackVariable;
    }

    public boolean getDumpStif() {
        return this.dumpStif;
    }

    public boolean getDumpSym() {
        return this.dumpSym;
    }

    public boolean getDumpCfi() {
        return this.dumpCfi;
    }

    public Vector<File> getdSymFiles() {
        if (null == this.fileName) {
            return this.dSymFiles;
        }
        File file = new File(this.fileName);
        this.fileName = file.getName();
        this.pathName = file.getAbsoluteFile().getParent() + File.separator;
        if (!this.findMachFile(file)) {
            Log.error("There is no dSYM file in the path: %s", this.fileName);
            return this.dSymFiles;
        }
        return this.dSymFiles;
    }

    public Vector<File> getSoFiles() {
        if (null == this.fileName) {
            Log.error("File name is null.", new Object[0]);
            return this.soFiles;
        }
        File file = new File(this.fileName);
        this.pathName = file.getAbsoluteFile().getParent() + File.separator;
        if (!this.findSoFile(file)) {
            Log.error("Can not find any SO files to parse.", new Object[0]);
            return this.soFiles;
        }
        return this.soFiles;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public String getSymZipFileName() {
        return this.symZipFileName;
    }

    public String getStifZipFileName() {
        return this.stifZipFileName;
    }

    public String getZipFileName(String alterZipFileName) {
        File zipFile;
        if (this.zipFileName != null && alterZipFileName != null && (zipFile = new File(this.zipFileName)).isDirectory()) {
            this.zipFileName = this.zipFileName + File.separator + alterZipFileName;
        }
        return this.zipFileName;
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public String getDsymName(String fileName) {
        File file = new File(fileName);
        String appName = file.getName();
        if (appName.endsWith(DSYM_SUFFIX) || appName.endsWith(DSYM_SUFFIX_EX)) {
            appName = appName.substring(0, appName.indexOf("."));
        }
        return appName;
    }

    public String getSoName(String fileName) {
        File file = new File(fileName);
        String simpleName = file.getName();
        if (simpleName.contains(".")) {
            simpleName = simpleName.substring(0, simpleName.indexOf("."));
        }
        return simpleName;
    }

    public String getWinName(String fileName) {
        File file = new File(fileName);
        String simpleName = file.getName();
        if (simpleName.contains(".")) {
            simpleName = simpleName.substring(0, simpleName.indexOf("."));
        }
        return simpleName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppChannel() {
        return this.appChannel;
    }

    public String getCrashSightVersion() {
        return this.crashsightVersion;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public String getSymbolPlatform() {
        return this.symbolPlatform;
    }

    public long getOffsetAddress() {
        return this.offsetAddress;
    }

    public String getMappingFileName() {
        return this.mappingFileName;
    }

    public String getIdStyle() {
        return this.idStyle;
    }

    private String parseAppName(String fileName) {
        File file = new File(fileName);
        String simpleName = file.getName();
        if (simpleName.contains(".")) {
            simpleName = simpleName.substring(0, simpleName.indexOf("."));
        }
        return simpleName;
    }

    public String getAppName(String fileName) {
        return this.parseAppName(fileName);
    }

    private boolean verify() {
        if (this.pathName == null) {
            Log.error("Path name is null.", new Object[0]);
            ArgsParser.printHelp();
            return false;
        }
        return true;
    }

    private boolean findMachFile(File dir) {
        if (!dir.exists()) {
            Log.error("Dir %s is not exist, Please check again.", dir);
            return false;
        }
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    this.findMachFile(file);
                    continue;
                }
                try {
                    if (!MachParser.isMach(file.getCanonicalPath())) continue;
                    this.dSymFiles.add(file);
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
        } else {
            try {
                if (dir.isDirectory()) {
                    Log.error("%s is directory", dir.getCanonicalPath());
                }
                if (MachParser.isMach(dir.getCanonicalPath())) {
                    this.dSymFiles.add(dir);
                }
                Log.error("The file is not a dSYM file!", new Object[0]);
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
        return !this.dSymFiles.isEmpty();
    }

    private boolean parseFileName(String fileName) {
        Log.error("FileName is  %s .", fileName);
        if (null == fileName) {
            return false;
        }
        File file = new File(fileName);
        this.fileName = fileName;
        if (!file.exists()) {
            Log.error("File %s is not exists.", file.getAbsoluteFile());
            return false;
        }
        this.pathName = file.isDirectory() ? fileName + File.separator : file.getAbsoluteFile().getParent() + File.separator;
        return true;
    }

    private boolean findSoFile(File dir) {
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    this.findSoFile(file);
                    continue;
                }
                try {
                    String path = file.getCanonicalPath();
                    if (path.endsWith(".o") || path.endsWith(".a") || !ElfParser.isElf(path)) continue;
                    Log.info("path = %s", path);
                    this.soFiles.add(file);
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
        } else {
            try {
                if (ElfParser.isElf(dir.getCanonicalPath())) {
                    this.soFiles.add(dir);
                }
                Log.error("The file %s is not a SO file!", dir.getCanonicalPath());
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
        return !this.soFiles.isEmpty();
    }

    private String parseZipFileName(String zipFileName) {
        if (null == zipFileName) {
            return "";
        }
        File zipFile = new File(zipFileName);
        if (zipFile.isFile() && !zipFileName.endsWith(".zip")) {
            Log.warn("The output specified hasn't suffix of zip!", new Object[0]);
        }
        return zipFile.getPath();
    }

    private boolean parseSettingFile(String fileName) {
        String str;
        if (null == fileName) {
            return false;
        }
        SettingFileParser parser = SettingFileParser.create(fileName);
        if (null == parser) {
            return false;
        }
        Map<String, String> settings = parser.getSettings();
        if (this.dSymFiles.isEmpty() && settings.containsKey("input")) {
            this.parseFileName(settings.get("input"));
        }
        this.parseSettingFileIfNull(settings);
        if (!this.shouldUpload && settings.containsKey("upload")) {
            str = settings.get("upload");
            if (str.toLowerCase().equals("true")) {
                this.shouldUpload = true;
            } else if (str.toLowerCase().equals("false")) {
                this.shouldUpload = false;
            } else {
                Log.warn("Setting of \"Upload\" should only be \"true\" or \"false\"", new Object[0]);
            }
        }
        if (!this.isDebug && settings.containsKey("debug")) {
            str = settings.get("debug");
            if (str.toLowerCase().equals("true")) {
                this.isDebug = true;
            } else if (str.toLowerCase().equals("false")) {
                this.isDebug = false;
            } else {
                Log.warn("Setting of \"Debug\" should only be \"true\" or \"false\"", new Object[0]);
            }
        }
        return true;
    }

    private void parseSettingFileIfNull(Map<String, String> settings) {
        if (this.zipFileName == null && settings.containsKey("output")) {
            this.parseZipFileName(settings.get("output"));
        }
        if (this.appId == null && settings.containsKey("id")) {
            this.appId = settings.get("id");
        }
        if (this.appKey == null && settings.containsKey("key")) {
            this.appKey = settings.get("key");
        }
        if (this.appPackage == null && settings.containsKey("package")) {
            this.appPackage = settings.get("package");
        }
        if (this.appVersion == null && settings.containsKey("version")) {
            this.appKey = settings.get("version");
        }
        if (this.crashsightVersion == null && settings.containsKey("crashsight")) {
            this.crashsightVersion = settings.get("crashsight");
        }
    }

    private boolean parseNetworkTimeout(String timeout2) {
        if (null == timeout2) {
            return false;
        }
        try {
            this.networkTimeout = Integer.parseInt(timeout2, 10);
            return true;
        }
        catch (NumberFormatException e) {
            Log.error("Failed to parse offset address: Wrong format!", new Object[0]);
            return false;
        }
    }

    private void parseDefaultSettingFile() {
        File file;
        URL url = ArgsParser.class.getProtectionDomain().getCodeSource().getLocation();
        String classPath = null;
        try {
            classPath = URLDecoder.decode(url.getPath(), "utf-8");
            if (classPath.endsWith(".jar")) {
                classPath = classPath.substring(0, classPath.lastIndexOf("/") + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String filePath = "settings.txt";
        if (classPath != null) {
            filePath = classPath + filePath;
        }
        if ((file = new File(filePath)).exists()) {
            this.parseSettingFile(file.getAbsolutePath());
        }
    }

    private boolean parse(String[] args2) {
        if (null == args2) {
            return false;
        }
        boolean hasSpecifiedSettingFile = false;
        Log.debug("Args length is " + args2.length, new Object[0]);
        for (int i = 0; i < args2.length; ++i) {
            Log.debug("Arg[" + i + "] is " + args2[i], new Object[0]);
            if (args2[i].equals(SETTING_FILE)) {
                hasSpecifiedSettingFile = true;
                if (i + 1 >= args2.length) {
                    Log.error("The arguments are not enough!", new Object[0]);
                    break;
                }
                this.parseSettingFile(args2[i + 1]);
                continue;
            }
            if (this.parseArgWithoutData(args2[i])) continue;
            if (i + 1 >= args2.length) {
                Log.error("The value of argument " + args2[i] + " is missing!", new Object[0]);
                break;
            }
            this.parseArgWithData(args2[i], args2[i + 1]);
            ++i;
        }
        if (!hasSpecifiedSettingFile) {
            this.parseDefaultSettingFile();
        }
        return this.verify();
    }

    private boolean parseArgWithoutData(String arg) {
        if (null == arg) {
            return false;
        }
        if (arg.equals(UPLOAD)) {
            this.shouldUpload = true;
        } else if (arg.equals(IS_DEBUG)) {
            this.isDebug = true;
        } else if (arg.equals(DUMP_SYMBOL)) {
            this.dumpSymbol = true;
        } else if (arg.equals(DUMP_UUID)) {
            this.dumpUuid = true;
        } else if (arg.equals(ONLY_REBUILD_DSYM)) {
            this.onlyRebuildDsym = true;
        } else if (arg.equals(REBUILD_DSYM)) {
            this.rebuildDsym = true;
        } else if (arg.equals(DUMP_STIF)) {
            this.dumpStif = true;
        } else if (arg.equals(DUMP_CFI)) {
            this.dumpCfi = true;
        } else if (arg.equals(DUMP_SYM)) {
            this.dumpSym = true;
        } else if (arg.equals(UPLOAD_COS)) {
            this.uploadCos = true;
        } else {
            return false;
        }
        return true;
    }

    private boolean parseArgWithData(String arg, String arg1) {
        if (null == arg || null == arg1) {
            return false;
        }
        if (arg.equals(INPUT_FILE)) {
            this.parseFileName(arg1);
        } else if (arg.equals(OUTPUT_FILE)) {
            this.stifZipFileName = this.parseZipFileName(arg1);
        } else if (arg.equals(SYM_OUTPUT_FILE)) {
            this.symZipFileName = this.parseZipFileName(arg1);
        } else if (arg.equals(STIF_OUTPUT_FILE)) {
            this.stifZipFileName = this.parseZipFileName(arg1);
        } else if (arg.equals(APP_ID)) {
            this.appId = arg1;
        } else if (arg.equals(APP_KEY)) {
            this.appKey = arg1;
        } else if (arg.equals(APP_VERSION)) {
            this.appVersion = arg1;
        } else if (arg.equals(APP_PACKAGE)) {
            this.appPackage = arg1;
        } else if (arg.equals(CRASHSIGHT_VERSION)) {
            this.crashsightVersion = arg1;
        } else if (arg.equals(NETWORK_TIMEOUT)) {
            this.parseNetworkTimeout(arg1);
        } else if (arg.equals(UPLOAD_URL)) {
            this.uploadUrl = arg1;
        } else if (arg.equals(PARSE_MODE)) {
            this.parseMode = arg1;
        } else if (arg.equals(SYMBOL_PLATFORM)) {
            this.symbolPlatform = arg1;
        } else if (arg.equals(UPLOAD_PROXY)) {
            this.upload_proxy = arg1;
            this.setProxy();
        } else if (arg.equals(DUMP_STACK_VARIABLE)) {
            this.dumpStackVariable = true;
        } else if (arg.equals(ID_STYLE)) {
            this.idStyle = arg1;
        } else if (arg.equals(MAPPING_FILE)) {
            this.mappingFileName = arg1;
        } else if (arg.equals(JS_FILE)) {
            this.jsFileName = arg1;
        } else {
            return false;
        }
        return true;
    }

    private boolean setProxy() {
        if (this.upload_proxy == null || this.upload_proxy.split(":").length != 2) {
            Log.error("Proxy is ilegal.", new Object[0]);
            return false;
        }
        String host = this.upload_proxy.split(":")[0];
        String port = this.upload_proxy.split(":")[1];
        Log.info("Proxy is host:%s port:%s.", host, port);
        Properties prop = System.getProperties();
        prop.setProperty("https.proxySet", "true");
        prop.setProperty("https.proxyHost", host);
        prop.setProperty("https.proxyPort", port);
        prop.setProperty("http.proxySet", "true");
        prop.setProperty("http.proxyHost", host);
        prop.setProperty("http.proxyPort", port);
        Log.info("Proxy is %s", prop.toString());
        return true;
    }

    public static ArgsParser create(String[] args2) {
        ArgsParser argsParser = new ArgsParser();
        if (!argsParser.parse(args2)) {
            argsParser = null;
        }
        return argsParser;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public boolean getUploadCos() {
        return this.uploadCos;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public String getJsFileName() {
        return this.jsFileName;
    }
}

