/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfStringParser;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class ElfSymtabParser {
    private static final long SYMTAB_FUNC_TYPE = 2L;
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    public ElfSymtabParser(String fileName, long fileFormat, long endian) {
        this.setFileName(fileName);
        this.setFileFormat(fileFormat);
        this.setEndian(endian);
    }

    private static void sortSubroutineTable(Vector<Subroutine> subroutineTable) {
        Collections.sort(subroutineTable, new Comparator<Subroutine>(){

            @Override
            public int compare(Subroutine a, Subroutine b) {
                if (a.getLowPc() == b.getLowPc()) {
                    return (int)(a.getHighPc() - b.getHighPc());
                }
                return (int)(a.getLowPc() - b.getLowPc());
            }
        });
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setEndian(long endian) {
        this.endian = endian;
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private long parseSymbolType(long type) {
        return type & 0xFL;
    }

    private ElfSymtabEntry parseElfSymtabEntry() {
        try {
            ElfSymtabEntry elfSymtabEntry = new ElfSymtabEntry();
            elfSymtabEntry.setName(this.binaryFileReader.readUInt());
            if (32L == this.fileFormat) {
                elfSymtabEntry.setValue(this.binaryFileReader.readUInt());
                elfSymtabEntry.setSize(this.binaryFileReader.readUInt());
                elfSymtabEntry.setInfo(this.binaryFileReader.readUByte());
                elfSymtabEntry.setOther(this.binaryFileReader.readUByte());
                elfSymtabEntry.setSectionIndex(this.binaryFileReader.readUShort());
            } else if (64L == this.fileFormat) {
                elfSymtabEntry.setInfo(this.binaryFileReader.readUByte());
                elfSymtabEntry.setOther(this.binaryFileReader.readUByte());
                elfSymtabEntry.setSectionIndex(this.binaryFileReader.readUShort());
                elfSymtabEntry.setValue(this.binaryFileReader.readULong());
                elfSymtabEntry.setSize(this.binaryFileReader.readULong());
            } else {
                Log.error("File format error", new Object[0]);
            }
            return elfSymtabEntry;
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    private Vector<Subroutine> parseSubroutineTable(long entryNumber, ElfStringParser stringParser) {
        Vector<ElfSymtabEntry> elfSymtabEntries = new Vector<ElfSymtabEntry>();
        int i = 0;
        while ((long)i < entryNumber) {
            elfSymtabEntries.add(this.parseElfSymtabEntry());
            ++i;
        }
        Vector<Subroutine> subroutineTable = new Vector<Subroutine>();
        for (int i2 = 0; i2 < elfSymtabEntries.size(); ++i2) {
            ElfSymtabEntry elfSymtabEntry = (ElfSymtabEntry)elfSymtabEntries.get(i2);
            if (2L != this.parseSymbolType(elfSymtabEntry.getInfo()) || elfSymtabEntry.getValue() == 0L) continue;
            Subroutine subroutine = new Subroutine();
            subroutine.setName(stringParser.getString(elfSymtabEntry.getName()));
            subroutine.setLowPc(elfSymtabEntry.getValue());
            long highPc = subroutine.getLowPc() + elfSymtabEntry.getSize();
            subroutine.setHighPc(highPc);
            subroutineTable.add(subroutine);
            if (subroutine.getLowPc() != 13136244L && subroutine.getHighPc() != 13136244L) continue;
            Log.error("", new Object[0]);
        }
        return subroutineTable;
    }

    public Vector<Subroutine> getSubroutineTable(long sectionOffset, long entryNumber, ElfStringParser stringParser) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(sectionOffset)) {
            this.close();
            return null;
        }
        Vector<Subroutine> subroutineTable = this.parseSubroutineTable(entryNumber, stringParser);
        this.close();
        ElfSymtabParser.sortSubroutineTable(subroutineTable);
        for (int i = 0; i < subroutineTable.size(); ++i) {
            Subroutine subroutine = subroutineTable.elementAt(i);
            if (subroutine.getHighPc() != subroutine.getLowPc() || i + 1 >= subroutineTable.size()) continue;
            subroutine.setHighPc(subroutineTable.elementAt(i + 1).getLowPc());
        }
        return subroutineTable;
    }

    public static class ElfSymtabEntry {
        private long name = 0L;
        private long info = 0L;
        private long other = 0L;
        private long sectionIndex = 0L;
        private long value = 0L;
        private long size = 0L;

        public long getName() {
            return this.name;
        }

        public void setName(long name) {
            this.name = name;
        }

        public long getInfo() {
            return this.info;
        }

        public void setInfo(long info) {
            this.info = info;
        }

        public long getOther() {
            return this.other;
        }

        public void setOther(long other) {
            this.other = other;
        }

        public long getSectionIndex() {
            return this.sectionIndex;
        }

        public void setSectionIndex(long sectionIndex) {
            this.sectionIndex = sectionIndex;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }
}

