/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.elf.ElfStringParser;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Vector;

public class ElfSectionParser {
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    private void setEndian(long endian) {
        this.endian = endian;
    }

    public ElfSectionParser(String fileName, long fileFormat, long endian) {
        this.setFileName(fileName);
        this.setFileFormat(fileFormat);
        this.setEndian(endian);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private ElfSectionInfo parseSectionInfo() {
        ElfSectionInfo sectionInfo;
        block8: {
            sectionInfo = new ElfSectionInfo();
            try {
                sectionInfo.setNameIndex(this.binaryFileReader.readUInt());
                sectionInfo.setType(this.binaryFileReader.readUInt());
                if (32L == this.fileFormat) {
                    sectionInfo.setFlag(this.binaryFileReader.readUInt());
                    sectionInfo.setAddress(this.binaryFileReader.readUInt());
                    sectionInfo.setOffset(this.binaryFileReader.readUInt());
                    sectionInfo.setSize(this.binaryFileReader.readUInt());
                } else if (64L == this.fileFormat) {
                    sectionInfo.setFlag(this.binaryFileReader.readULong());
                    sectionInfo.setAddress(this.binaryFileReader.readULong());
                    sectionInfo.setOffset(this.binaryFileReader.readULong());
                    sectionInfo.setSize(this.binaryFileReader.readULong());
                } else {
                    Log.error("File format error", new Object[0]);
                    return null;
                }
                sectionInfo.setLink(this.binaryFileReader.readUInt());
                sectionInfo.setInfo(this.binaryFileReader.readUInt());
                if (32L == this.fileFormat) {
                    sectionInfo.setAddressAlign(this.binaryFileReader.readUInt());
                    sectionInfo.setEntrySize(this.binaryFileReader.readUInt());
                    break block8;
                }
                if (64L == this.fileFormat) {
                    sectionInfo.setAddressAlign(this.binaryFileReader.readULong());
                    sectionInfo.setEntrySize(this.binaryFileReader.readULong());
                    break block8;
                }
                Log.error("File format error", new Object[0]);
                return null;
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
        }
        return sectionInfo;
    }

    private HashMap<String, Section> getSectionInfoTable(long sectionNumber, long sectionNameTableIndex) {
        Vector<ElfSectionInfo> elfSectionInfos = new Vector<ElfSectionInfo>();
        int i = 0;
        while ((long)i < sectionNumber) {
            elfSectionInfos.add(this.parseSectionInfo());
            ++i;
        }
        ElfSectionInfo sectionNameSectionInfo = (ElfSectionInfo)elfSectionInfos.get((int)sectionNameTableIndex);
        ElfStringParser sectionNameTable = new ElfStringParser(this.fileName, sectionNameSectionInfo.getOffset(), sectionNameSectionInfo.getSize());
        HashMap<String, Section> sectionInfoTable = new HashMap<String, Section>();
        for (ElfSectionInfo elfSectionInfo : elfSectionInfos) {
            String sectionName = sectionNameTable.getString(elfSectionInfo.getNameIndex());
            Section sectionInfo = new Section();
            sectionInfo.setName(sectionName);
            sectionInfo.setAddress(elfSectionInfo.getAddress());
            sectionInfo.setOffset(elfSectionInfo.getOffset());
            sectionInfo.setSize(elfSectionInfo.getSize());
            sectionInfo.setEntrySize(elfSectionInfo.getEntrySize());
            sectionInfo.setAddrAlign(elfSectionInfo.getAddressAlign());
            sectionInfoTable.put(sectionName, sectionInfo);
        }
        sectionNameTable.close();
        return sectionInfoTable;
    }

    public HashMap<String, Section> getSectionInfoTable(long offset, long sectionNumber, long sectionNameTableIndex) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(offset)) {
            this.close();
            return null;
        }
        HashMap<String, Section> sectionInfoTable = this.getSectionInfoTable(sectionNumber, sectionNameTableIndex);
        this.close();
        return sectionInfoTable;
    }

    public ParseBuffer getSectionData(Section section) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(section.getOffset())) {
            this.close();
            return null;
        }
        byte[] data = new byte[(int)section.getSize()];
        this.binaryFileReader.readByteArray(data);
        this.close();
        return new ParseBuffer(data, this.endian == 1L ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public static class ElfSectionInfo {
        private long nameIndex = -1L;
        private long type = 0L;
        private long flag = 0L;
        private long address = -1L;
        private long offset = -1L;
        private long size = 0L;
        private long link = 0L;
        private long info = 0L;
        private long addressAlign = 0L;
        private long entrySize = 0L;

        public long getNameIndex() {
            return this.nameIndex;
        }

        public long getType() {
            return this.type;
        }

        public long getFlag() {
            return this.flag;
        }

        public long getAddress() {
            return this.address;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSize() {
            return this.size;
        }

        public long getLink() {
            return this.link;
        }

        public long getInfo() {
            return this.info;
        }

        public long getAddressAlign() {
            return this.addressAlign;
        }

        public long getEntrySize() {
            return this.entrySize;
        }

        public void setNameIndex(long nameIndex) {
            this.nameIndex = nameIndex;
        }

        public void setType(long type) {
            this.type = type;
        }

        public void setFlag(long flag) {
            this.flag = flag;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void setAddress(long address) {
            this.address = address;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setLink(long link) {
            this.link = link;
        }

        public void setInfo(long info) {
            this.info = info;
        }

        public void setAddressAlign(long addressAlign) {
            this.addressAlign = addressAlign;
        }

        public void setEntrySize(long entrySize) {
            this.entrySize = entrySize;
        }
    }
}

