/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.ProgramHeader;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class ElfProgramHeaderParser {
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    public ElfProgramHeaderParser(String fileName, long fileFormat, long endian) {
        this.setFileName(fileName);
        this.setFileFormat(fileFormat);
        this.setEndian(endian);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private ProgramHeader parsePhdrInfo() {
        ProgramHeader programHeaderInfo = new ProgramHeader();
        try {
            if (32L == this.fileFormat) {
                programHeaderInfo.setP_type(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_offset(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_vaddr(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_paddr(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_filesz(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_memsz(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_flags(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_align(this.binaryFileReader.readUInt());
            } else {
                programHeaderInfo.setP_type(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_flags(this.binaryFileReader.readUInt());
                programHeaderInfo.setP_offset(this.binaryFileReader.readULong());
                programHeaderInfo.setP_vaddr(this.binaryFileReader.readULong());
                programHeaderInfo.setP_paddr(this.binaryFileReader.readULong());
                programHeaderInfo.setP_filesz(this.binaryFileReader.readULong());
                programHeaderInfo.setP_memsz(this.binaryFileReader.readULong());
                programHeaderInfo.setP_align(this.binaryFileReader.readULong());
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        Log.info("current flag is : %d; it's vaddr is %d", programHeaderInfo.getP_flags(), programHeaderInfo.getP_vaddr());
        return programHeaderInfo;
    }

    private Vector<ProgramHeader> getProgramHeaderInfoTable(long numberOfPhdrs) {
        Vector<ProgramHeader> phdrTable = new Vector<ProgramHeader>();
        int i = 0;
        while ((long)i < numberOfPhdrs) {
            phdrTable.add(this.parsePhdrInfo());
            ++i;
        }
        return phdrTable;
    }

    public Vector<ProgramHeader> getProgramHeaderInfoTable(long offset, long numberOfPhdrs) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(offset)) {
            this.close();
            return null;
        }
        Vector<ProgramHeader> phdrTable = this.getProgramHeaderInfoTable(numberOfPhdrs);
        this.close();
        return phdrTable;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    public void setEndian(long endian) {
        this.endian = endian;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }
}

