/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.ProgramHeader;
import com.uqm.crashsight.symtabtool.common.Section;
import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DwarfInfoBean;
import com.uqm.crashsight.symtabtool.dwarf.DwarfParser;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.elf.ElfArmAttrParser;
import com.uqm.crashsight.symtabtool.elf.ElfHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfProgramHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfSectionParser;
import com.uqm.crashsight.symtabtool.elf.ElfStringParser;
import com.uqm.crashsight.symtabtool.elf.ElfSymtabParser;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import com.uqm.crashsight.symtabtool.symtab.SymtabMerger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class ElfParser {
    public static final long FILE_FORMAT_INVALID = 0L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    public static final String TEXT_SECTION = ".text";
    public static final String SYMTAB_SECTION = ".symtab";
    public static final String STRTAB_SECTION = ".strtab";
    public static final String DYN_SYMTAB_SECTION = ".dynsym";
    public static final String DYN_STRTAB_SECTION = ".dynstr";
    public static final String ARM_ATTR_SECTION = ".ARM.attributes";
    public static final String GNU_BUILD_ID_SECTION = ".note.gnu.build-id";
    public static final String CRASHSIGHT_VERSION_SECTION = ".crashSight_version";
    public static final String DEBUG_INFO_SECTION = ".debug_info";
    public static final String DEBUG_ABBREV_SECTION = ".debug_abbrev";
    public static final String DEBUG_LINE_SECTION = ".debug_line";
    public static final String DEBUG_RANGES_SECTION = ".debug_ranges";
    public static final String DEBUG_STR_SECTION = ".debug_str";
    public static final String DEBUG_STR_OFFSETS_SECTION = ".debug_str_offsets";
    public static final String DEBUG_LINE_STR_SECTION = ".debug_line_str";
    public static final String DEBUG_RNGLISTS_SECTION = ".debug_rnglists";
    public static final String DEBUG_ADDR_SECTION = ".debug_addr";
    private static final long GNU_NOTE_TYPE_BUILD_ID = 3L;
    private static final int UUID_MAX_LENGTH = 16;
    private static final int FULL_UUID_MAX_LENGTH = 128;
    public String breakpadArch = null;
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private String uuid = null;
    private String fullUuid = null;
    private String breakpadDebugId = null;
    private String breakpadCodeId = null;
    private String arch = null;
    private String soVersion = null;
    private HashMap<String, Section> sectionTable = null;
    private Vector<Subroutine> subroutineTable = null;
    private SymbolTable symbolTable = null;
    private Vector<ProgramHeader> programHeaderTable = null;
    private ElfHeaderParser headerParser = null;

    private ElfParser(String fileName) {
        this.setFileName(fileName);
    }

    public static String getUuid(String fileName) {
        ElfParser elfParser = new ElfParser(fileName);
        ElfHeaderParser header = elfParser.parseHeaderInfo();
        if (null == header) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        if (!elfParser.parseSectionTable(header)) {
            Log.error("Failed to parse section table", new Object[0]);
            return null;
        }
        if (!elfParser.parseUuid()) {
            Log.error("Failed to parse UUID of ELF file", new Object[0]);
        }
        return elfParser.uuid;
    }

    public static String getBreakpadDebugId(String fileName) {
        ElfParser elfParser = new ElfParser(fileName);
        ElfHeaderParser header = elfParser.parseHeaderInfo();
        if (null == header) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        if (!elfParser.parseSectionTable(header)) {
            Log.error("Failed to parse section table", new Object[0]);
            return null;
        }
        if (!elfParser.parseBreakpadDebugId()) {
            Log.error("Failed to parse Breakpad DebugId of ELF file", new Object[0]);
        }
        return elfParser.breakpadDebugId;
    }

    public static String getBreakpadCodeId(String fileName) {
        ElfParser elfParser = new ElfParser(fileName);
        ElfHeaderParser header = elfParser.parseHeaderInfo();
        if (null == header) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        if (!elfParser.parseSectionTable(header)) {
            Log.error("Failed to parse section table", new Object[0]);
            return null;
        }
        if (!elfParser.parseBreakpadCodeId()) {
            Log.error("Failed to parse Breakpad CodeId of ELF file", new Object[0]);
        }
        return elfParser.breakpadCodeId;
    }

    public static String getArch(String fileName) {
        ElfParser elfParser = new ElfParser(fileName);
        ElfHeaderParser header = elfParser.parseHeaderInfo();
        if (null == header) {
            Log.error("Failed to parse elf header", new Object[0]);
            return null;
        }
        String arch = header.getArchName();
        if (!arch.equals("armeabi")) {
            return arch;
        }
        if (!elfParser.parseSectionTable(header)) {
            Log.error("Failed to parse section table", new Object[0]);
            return arch;
        }
        Section armSection = elfParser.sectionTable.get(ARM_ATTR_SECTION);
        if (null == armSection) {
            Log.error("No .ARM.attributes section in the elf file", new Object[0]);
            return arch;
        }
        return ElfArmAttrParser.getArch(fileName, elfParser.endian, armSection.getOffset());
    }

    public static boolean isElf(String fileName) {
        return ElfHeaderParser.isElf(fileName);
    }

    public static boolean isDebugElf(String fileName) {
        ElfParser elfParser = new ElfParser(fileName);
        ElfHeaderParser header = elfParser.parseHeaderInfo();
        if (null == header) {
            Log.error("Failed to parse elf header", new Object[0]);
            return false;
        }
        if (!elfParser.parseSectionTable(header)) {
            Log.error("Failed to parse section table", new Object[0]);
            return false;
        }
        return elfParser.getDwarfInfoBean() != null;
    }

    public static ElfParser create(String fileName) {
        ElfParser elfParser = new ElfParser(fileName);
        if (!elfParser.parse()) {
            return null;
        }
        return elfParser;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ElfHeaderParser getHeaderParser() {
        return this.headerParser;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    private void setFileFormat(long fileFormat) {
        this.fileFormat = fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    private void setEndian(long endian) {
        this.endian = endian;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getFullUuid() {
        return this.fullUuid;
    }

    public boolean setUuid(String uuid) {
        if (uuid != null) {
            this.uuid = uuid;
            return true;
        }
        return false;
    }

    public String getBreakpadDebugId() {
        return this.breakpadDebugId;
    }

    public String getBreakpadCodeId() {
        return this.breakpadCodeId;
    }

    public String getArch() {
        return this.arch;
    }

    public String getSoVersion() {
        return this.soVersion;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public HashMap<String, Section> getSectionTable() {
        return this.sectionTable;
    }

    public Vector<Long> getProgramVaddr() {
        Vector<Long> flags = new Vector<Long>();
        for (ProgramHeader header : this.programHeaderTable) {
            if (header.getP_flags() % 2L == 0L) continue;
            flags.add(header.getP_vaddr());
        }
        return flags;
    }

    public Vector<Long> getProgramOffset() {
        Vector<Long> flags = new Vector<Long>();
        for (ProgramHeader header : this.programHeaderTable) {
            if (header.getP_flags() % 2L == 0L) continue;
            flags.add(header.getP_offset());
        }
        return flags;
    }

    public long getModuleBase() {
        long flags = 0L;
        for (ProgramHeader header : this.programHeaderTable) {
            if (header.getP_offset() != 0L) continue;
            flags = header.getP_vaddr();
            return flags;
        }
        return flags;
    }

    private ElfHeaderParser parseHeaderInfo() {
        ElfHeaderParser header = ElfHeaderParser.create(this.fileName);
        if (null == header) {
            return null;
        }
        this.setFileFormat(header.getFileFormat());
        this.setEndian(header.getEndian());
        return header;
    }

    private boolean parseSectionTable(ElfHeaderParser header) {
        ElfSectionParser elfSection = new ElfSectionParser(this.fileName, this.fileFormat, this.endian);
        this.sectionTable = elfSection.getSectionInfoTable(header.getSectionHeaderTableOffset(), header.getSectionNumber(), header.getStringTableHeaderIndex());
        return null != this.sectionTable;
    }

    public ParseBuffer getSectionData(Section section) {
        ElfSectionParser elfSection = new ElfSectionParser(this.fileName, this.fileFormat, this.endian);
        return elfSection.getSectionData(section);
    }

    private boolean parseProgramHeaderTable(ElfHeaderParser header) {
        ElfProgramHeaderParser elfProgramHeader = new ElfProgramHeaderParser(this.fileName, this.fileFormat, this.endian);
        this.programHeaderTable = elfProgramHeader.getProgramHeaderInfoTable(header.getProgramHeaderTableOffset(), header.getProgramNumber());
        return null != this.programHeaderTable;
    }

    private ElfStringParser getStringSectionParser() {
        Section stringSectionInfo = this.sectionTable.get(STRTAB_SECTION);
        if (null == stringSectionInfo && null == (stringSectionInfo = this.sectionTable.get(DYN_STRTAB_SECTION))) {
            Log.error("No string section in the elf file", new Object[0]);
            return null;
        }
        return new ElfStringParser(this.fileName, stringSectionInfo.getOffset(), stringSectionInfo.getSize());
    }

    private boolean parseSubroutineTable(ElfStringParser stringParser) {
        ElfSymtabParser elfSymtab = new ElfSymtabParser(this.fileName, this.fileFormat, this.endian);
        Section symtabSectionInfo = this.sectionTable.get(SYMTAB_SECTION);
        if (null == symtabSectionInfo && null == (symtabSectionInfo = this.sectionTable.get(DYN_SYMTAB_SECTION))) {
            Log.error("No symtab section in the elf file", new Object[0]);
            return false;
        }
        long entryNumber = symtabSectionInfo.getSize() / symtabSectionInfo.getEntrySize();
        this.subroutineTable = elfSymtab.getSubroutineTable(symtabSectionInfo.getOffset(), entryNumber, stringParser);
        if (null == this.subroutineTable) {
            return false;
        }
        stringParser.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseSoVersion() {
        Section soVersionSection = this.sectionTable.get(CRASHSIGHT_VERSION_SECTION);
        if (null == soVersionSection) {
            Log.warn("No %s section in the elf file", CRASHSIGHT_VERSION_SECTION);
            return false;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            binaryFileReader.skip(soVersionSection.getOffset());
            byte[] version = new byte[(int)soVersionSection.getSize()];
            if (!binaryFileReader.readByteArray(version)) {
                boolean bl = false;
                return bl;
            }
            this.soVersion = new String(version, "utf-8").trim();
            boolean bl = true;
            return bl;
        }
    }

    private boolean parseArch(ElfHeaderParser header) {
        this.arch = header.getArchName();
        if (!this.arch.equals("armeabi")) {
            return true;
        }
        Section armSection = this.sectionTable.get(ARM_ATTR_SECTION);
        if (null == armSection) {
            Log.warn("No .ARM.attributes section in the elf file", new Object[0]);
            return true;
        }
        String archName = ElfArmAttrParser.getArch(this.fileName, this.endian, armSection.getOffset());
        if (null != archName) {
            this.arch = archName;
        }
        return true;
    }

    private boolean parse() {
        ElfStringParser stringParser;
        Log.info("Begin to parse file: %s", this.fileName);
        ElfHeaderParser header = this.parseHeaderInfo();
        if (null == header) {
            Log.error("Failed to parse elf header", new Object[0]);
            return false;
        }
        this.headerParser = header;
        if (!this.parseSectionTable(header)) {
            Log.error("Failed to parse section table", new Object[0]);
            return false;
        }
        if (!this.parseProgramHeaderTable(header)) {
            Log.error("Failed to parse programHeader table", new Object[0]);
            return false;
        }
        if (!this.parseUuid()) {
            Log.error("Failed to parse SHA-1", new Object[0]);
            return false;
        }
        try {
            if (!this.parseFullUuid()) {
                Log.error("Failed to parse SHA-1", new Object[0]);
                return false;
            }
        }
        catch (Exception e) {
            Log.error("Failed to parse full uuid", new Object[0]);
        }
        this.parseSoVersion();
        if (!this.parseArch(header)) {
            Log.warn("Failed to parse arch", new Object[0]);
        }
        if (null == (stringParser = this.getStringSectionParser())) {
            Log.warn("Please check whether it is a debug SO file", new Object[0]);
            return false;
        }
        if (!this.parseSubroutineTable(stringParser)) {
            Log.error("Failed to extract subroutine table", new Object[0]);
            return false;
        }
        Log.info("Successfully parsed the file!", new Object[0]);
        Log.printBusyingLog("Begin to extract symbol table..", 256L);
        DwarfInfoBean dwarfInfoBean = this.getDwarfInfoBean();
        SymbolTable symbolTable = null;
        if (null == dwarfInfoBean) {
            Log.warn("Failed to get DWARF info!", new Object[0]);
            symbolTable = SymtabMerger.getSymtabTable(this.subroutineTable);
        } else {
            long startTime = System.currentTimeMillis();
            symbolTable = DwarfParser.getSymbolTable(this.subroutineTable, dwarfInfoBean);
            Log.info("[Time]DwarfParser.getSymbolTable cost %d[ms]", System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
            if (null == symbolTable) {
                Log.error("Failed to extract symbol table from DWARF section!", new Object[0]);
                return false;
            }
        }
        this.setSymbolTable(symbolTable);
        Log.info("Successfully extracted symbol table!", new Object[0]);
        return true;
    }

    private DwarfInfoBean getDwarfInfoBean() {
        Section debugAddrSection;
        Section debugRngListSection;
        Section debugLineStrSection;
        Section debugStrSection;
        DwarfInfoBean dwarfInfoBean = new DwarfInfoBean();
        dwarfInfoBean.setFileName(this.fileName);
        Section debugAbbrevSection = this.sectionTable.get(DEBUG_ABBREV_SECTION);
        if (null == debugAbbrevSection) {
            Log.warn("No debug_abbrev section in the elf file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugAbbrevOffset(debugAbbrevSection.getOffset());
        dwarfInfoBean.setDebugAbbrevSize(debugAbbrevSection.getSize());
        Section debugInfoSection = this.sectionTable.get(DEBUG_INFO_SECTION);
        if (null == debugInfoSection) {
            Log.warn("No debug_info section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugInfoOffset(debugInfoSection.getOffset());
        dwarfInfoBean.setDebugInfoSize(debugInfoSection.getSize());
        Section debugLineSection = this.sectionTable.get(DEBUG_LINE_SECTION);
        if (null == debugLineSection) {
            Log.warn("No debug_line section in the file.", new Object[0]);
            return null;
        }
        dwarfInfoBean.setDebugLineOffset(debugLineSection.getOffset());
        dwarfInfoBean.setDebugLineSize(debugLineSection.getSize());
        Section debugRangesSection = this.sectionTable.get(DEBUG_RANGES_SECTION);
        if (null != debugRangesSection) {
            dwarfInfoBean.setDebugRangesOffset(debugRangesSection.getOffset());
            dwarfInfoBean.setDebugRangesSize(debugRangesSection.getSize());
        }
        if (null == (debugStrSection = this.sectionTable.get(DEBUG_STR_SECTION))) {
            Log.warn("No debug_str section in the file.", new Object[0]);
        } else {
            dwarfInfoBean.setDebugStrOffset(debugStrSection.getOffset());
            dwarfInfoBean.setDebugStrSize(debugStrSection.getSize());
        }
        Section debugStrOffsetsStrSection = this.sectionTable.get(DEBUG_STR_OFFSETS_SECTION);
        if (debugStrOffsetsStrSection != null) {
            dwarfInfoBean.setDebugStrOffsetsOffset(debugStrOffsetsStrSection.getOffset());
            dwarfInfoBean.setDebugStrOffsetsSize(debugStrOffsetsStrSection.getSize());
        }
        if ((debugLineStrSection = this.sectionTable.get(DEBUG_LINE_STR_SECTION)) != null) {
            dwarfInfoBean.setDebugLineStrOffset(debugLineStrSection.getOffset());
            dwarfInfoBean.setDebugLineStrSize(debugLineStrSection.getSize());
        }
        if ((debugRngListSection = this.sectionTable.get(DEBUG_RNGLISTS_SECTION)) != null) {
            dwarfInfoBean.setDebugRngListOffset(debugRngListSection.getOffset());
            dwarfInfoBean.setDebugRngListSize(debugRngListSection.getSize());
        }
        if ((debugAddrSection = this.sectionTable.get(DEBUG_ADDR_SECTION)) != null) {
            dwarfInfoBean.setDebugAddrOffset(debugAddrSection.getOffset());
            dwarfInfoBean.setDebugAddrSize(debugAddrSection.getSize());
        }
        return dwarfInfoBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseUuid() {
        this.parseBreakpadDebugId();
        if (this.sectionTable == null) {
            return false;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            byte[] uuid = new byte[16];
            byte[] fullUuid = null;
            Section gnuBuildIdSection = this.sectionTable.get(GNU_BUILD_ID_SECTION);
            if (null == gnuBuildIdSection) {
                Section textSection = this.sectionTable.get(TEXT_SECTION);
                if (textSection == null) {
                    boolean bl = false;
                    return bl;
                }
                long size = textSection.getSize() <= 4096L ? textSection.getSize() : 4096L;
                binaryFileReader.skip(textSection.getOffset());
                int i = 0;
                while ((long)i < size) {
                    int j = 0;
                    while (j < 16) {
                        int n = j++;
                        uuid[n] = (byte)(uuid[n] ^ binaryFileReader.readByte());
                    }
                    i += 16;
                }
            } else {
                binaryFileReader.skip(gnuBuildIdSection.getOffset());
                long nameSize = binaryFileReader.readUInt();
                long descriptionSize = binaryFileReader.readUInt();
                long type = binaryFileReader.readUInt();
                if (3L != type) {
                    Log.warn("GNU note type is not GNU_NOTE_TYPE_BUILD_ID(3).", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                long nameOffset = nameSize + 3L & 0xFFFFFFFFFFFFFFFCL;
                binaryFileReader.skip(nameOffset);
                if (descriptionSize > 16L) {
                    binaryFileReader.skip(descriptionSize - 16L);
                }
                if (!binaryFileReader.readByteArray(uuid)) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.uuid = Utils.byteArrayToHexString(uuid);
            this.fullUuid = fullUuid == null ? this.uuid : Utils.byteArrayToHexString(fullUuid);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseFullUuid() {
        this.parseBreakpadDebugId();
        if (this.sectionTable == null) {
            return false;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            byte[] fullUuid = null;
            Section gnuBuildIdSection = this.sectionTable.get(GNU_BUILD_ID_SECTION);
            if (null == gnuBuildIdSection) {
                fullUuid = new byte[16];
                Section textSection = this.sectionTable.get(TEXT_SECTION);
                if (textSection == null) {
                    boolean bl = false;
                    return bl;
                }
                long size = textSection.getSize() <= 4096L ? textSection.getSize() : 4096L;
                binaryFileReader.skip(textSection.getOffset());
                int i = 0;
                while ((long)i < size) {
                    int j = 0;
                    while (j < 16) {
                        int n = j++;
                        fullUuid[n] = (byte)(fullUuid[n] ^ binaryFileReader.readByte());
                    }
                    i += 16;
                }
            } else {
                binaryFileReader.skip(gnuBuildIdSection.getOffset());
                long nameSize = binaryFileReader.readUInt();
                long descriptionSize = binaryFileReader.readUInt();
                long type = binaryFileReader.readUInt();
                fullUuid = descriptionSize > 128L ? new byte[128] : new byte[(int)descriptionSize];
                if (3L != type) {
                    Log.warn("GNU note type is not GNU_NOTE_TYPE_BUILD_ID(3).", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                long nameOffset = nameSize + 3L & 0xFFFFFFFFFFFFFFFCL;
                binaryFileReader.skip(nameOffset);
                if (descriptionSize > 128L) {
                    binaryFileReader.skip(descriptionSize - 128L);
                }
                if (!binaryFileReader.readByteArray(fullUuid)) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.fullUuid = Utils.byteArrayToHexString(fullUuid);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] findBuildId() {
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            Section gnuBuildIdSection = this.sectionTable.get(GNU_BUILD_ID_SECTION);
            if (null != gnuBuildIdSection) {
                binaryFileReader.skip(gnuBuildIdSection.getOffset());
                long nameSize = binaryFileReader.readUInt();
                long descriptionSize = binaryFileReader.readUInt();
                long type = binaryFileReader.readUInt();
                if (3L != type) {
                    Log.warn("GNU note type is not GNU_NOTE_TYPE_BUILD_ID(3).", new Object[0]);
                    byte[] byArray = null;
                    return byArray;
                }
                long nameOffset = nameSize + 3L & 0xFFFFFFFFFFFFFFFCL;
                binaryFileReader.skip(nameOffset);
                byte[] identifier = new byte[(int)descriptionSize];
                binaryFileReader.readByteArray(identifier);
                byte[] byArray = identifier;
                return byArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseBreakpadDebugId() {
        if (this.sectionTable == null) {
            return false;
        }
        byte[] identifier = this.findBuildId();
        if (identifier != null) {
            byte[] data = Arrays.copyOf(identifier, 16);
            if (this.endian == BinaryFileReader.LITTLE_ENDIAN) {
                Utils.reverseByteArray(data, 0, 4);
                Utils.reverseByteArray(data, 4, 6);
                Utils.reverseByteArray(data, 6, 8);
            }
            this.breakpadDebugId = Utils.byteArrayToHexString(data).toUpperCase(Locale.ROOT) + "0";
            return true;
        }
        try (BinaryFileReader binaryFileReader = null;){
            binaryFileReader = new BinaryFileReader(this.fileName);
            byte[] uuid = new byte[16];
            Section textSection = this.sectionTable.get(TEXT_SECTION);
            if (textSection == null) {
                boolean bl = false;
                return bl;
            }
            long size = textSection.getSize() <= 4096L ? textSection.getSize() : 4096L;
            binaryFileReader.skip(textSection.getOffset());
            int i = 0;
            while ((long)i < size) {
                int j = 0;
                while (j < 16) {
                    int n = j++;
                    uuid[n] = (byte)(uuid[n] ^ binaryFileReader.readByte());
                }
                i += 16;
            }
            this.breakpadDebugId = Utils.byteArrayToHexString(uuid);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public boolean parseBreakpadCodeId() {
        byte[] identifier = this.findBuildId();
        if (identifier == null) {
            return false;
        }
        this.breakpadCodeId = Utils.byteArrayToHexString(identifier).toUpperCase(Locale.ROOT);
        return true;
    }
}

