/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.HashMap;

public class ElfHeaderParser {
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private byte[] elfIdentification = new byte[16];
    private long fileType = 0L;
    private long arch = 0L;
    private String archName = null;
    private long version = 0L;
    private long entryAddress = 0L;
    private long programHeaderTableOffset = 0L;
    private long sectionHeaderTableOffset = 0L;
    private long processorSpecificFlags = 0L;
    private long headerSize = 0L;
    private long programHeaderTableEntrySize = 0L;
    private long programNumber = 0L;
    private long sectionHeaderTableEntrySize = 0L;
    private long sectionNumber = 0L;
    private long stringTableHeaderIndex = 0L;
    private static final HashMap<Long, String> archTable = new HashMap();
    public static final String ARCH_ARM = "armeabi";
    public static final String ARCH_MIPS = "mips";
    public static final String ARCH_MIPS_64 = "mips64";

    private static String getArchName(long arch, long format) {
        String archName = archTable.get(arch);
        if (64L == format && archName.equals(ARCH_MIPS)) {
            archName = ARCH_MIPS_64;
        }
        return archName;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    public long getEndian() {
        return this.endian;
    }

    public long getFileType() {
        return this.fileType;
    }

    public long getArch() {
        return this.arch;
    }

    public String getArchName() {
        return this.archName;
    }

    public long getEntryAddress() {
        return this.entryAddress;
    }

    public long getSectionHeaderTableOffset() {
        return this.sectionHeaderTableOffset;
    }

    public long getSectionNumber() {
        return this.sectionNumber;
    }

    public long getStringTableHeaderIndex() {
        return this.stringTableHeaderIndex;
    }

    public long getProgramNumber() {
        return this.programNumber;
    }

    public long getProgramHeaderTableOffset() {
        return this.programHeaderTableOffset;
    }

    public long getProcessorSpecificFlags() {
        return this.processorSpecificFlags;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private ElfHeaderParser(String fileName) {
        this.setFileName(fileName);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private static boolean checkMagic(byte[] array) {
        if (array.length < 3) {
            return false;
        }
        if (127 != array[0]) {
            return false;
        }
        if (69 != array[1]) {
            return false;
        }
        if (76 != array[2]) {
            return false;
        }
        return 70 == array[3];
    }

    private long parseFileFormat(byte format) {
        if (1 == format) {
            return 32L;
        }
        if (2 == format) {
            return 64L;
        }
        return 0L;
    }

    private long parseEndian(byte endian) {
        if (1 == endian) {
            return BinaryFileReader.LITTLE_ENDIAN;
        }
        if (2 == endian) {
            return BinaryFileReader.BIG_ENDIAN;
        }
        return BinaryFileReader.INVALID_ENDIAN;
    }

    private boolean parseHeaderIndent() {
        if (!this.binaryFileReader.readByteArray(this.elfIdentification)) {
            Log.error("Failed to parse elf indentification", new Object[0]);
            return false;
        }
        if (!ElfHeaderParser.checkMagic(this.elfIdentification)) {
            Log.error("Not a elf file: %s", this.fileName);
            return false;
        }
        this.fileFormat = this.parseFileFormat(this.elfIdentification[4]);
        if (0L == this.fileFormat) {
            Log.error("File format error: 0x%x", this.elfIdentification[4]);
            return false;
        }
        this.endian = this.parseEndian(this.elfIdentification[5]);
        if (BinaryFileReader.INVALID_ENDIAN == this.endian) {
            Log.error("Endian error: 0x%x", this.elfIdentification[5]);
            return false;
        }
        this.binaryFileReader.setEndian(this.endian);
        return true;
    }

    private boolean parseHeader() {
        if (!this.parseHeaderIndent()) {
            Log.error("Failed to parse header indent of elf", new Object[0]);
            return false;
        }
        try {
            this.fileType = this.binaryFileReader.readUShort();
            this.arch = this.binaryFileReader.readUShort();
            this.archName = ElfHeaderParser.getArchName(this.arch, this.fileFormat);
            this.version = this.binaryFileReader.readUInt();
            if (32L == this.fileFormat) {
                this.entryAddress = this.version = this.binaryFileReader.readUInt();
                this.programHeaderTableOffset = this.binaryFileReader.readUInt();
                this.sectionHeaderTableOffset = this.binaryFileReader.readUInt();
            } else if (64L == this.fileFormat) {
                this.entryAddress = this.version = this.binaryFileReader.readULong();
                this.programHeaderTableOffset = this.binaryFileReader.readULong();
                this.sectionHeaderTableOffset = this.binaryFileReader.readULong();
            } else {
                Log.error("File format error", new Object[0]);
                return false;
            }
            this.processorSpecificFlags = this.binaryFileReader.readUInt();
            this.headerSize = this.binaryFileReader.readUShort();
            this.programHeaderTableEntrySize = this.binaryFileReader.readUShort();
            this.programNumber = this.binaryFileReader.readUShort();
            this.sectionHeaderTableEntrySize = this.binaryFileReader.readUShort();
            this.sectionNumber = this.binaryFileReader.readUShort();
            this.stringTableHeaderIndex = this.binaryFileReader.readUShort();
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private boolean parse() {
        if (!this.openFile()) {
            return false;
        }
        if (!this.parseHeader()) {
            this.close();
            return false;
        }
        this.close();
        return true;
    }

    public static ElfHeaderParser create(String fileName) {
        ElfHeaderParser header = new ElfHeaderParser(fileName);
        if (!header.parse()) {
            return null;
        }
        return header;
    }

    public static boolean isElf(String fileName) {
        try {
            BinaryFileReader binaryFileReader = new BinaryFileReader(fileName);
            byte[] array = new byte[4];
            if (!binaryFileReader.readByteArray(array)) {
                return false;
            }
            return ElfHeaderParser.checkMagic(array);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), new Object[0]);
            return false;
        }
    }

    static {
        archTable.put(new Long(3L), "x86");
        archTable.put(new Long(7L), "x86");
        archTable.put(new Long(8L), ARCH_MIPS);
        archTable.put(new Long(10L), ARCH_MIPS);
        archTable.put(new Long(40L), ARCH_ARM);
        archTable.put(new Long(62L), "x86_64");
        archTable.put(new Long(183L), "arm64-v8a");
    }
}

