/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.elf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import java.io.IOException;
import java.util.HashMap;

public class ElfArmAttrParser {
    private String fileName = null;
    private BinaryFileReader binaryFileReader = null;
    private long endian = 0L;
    private long sectionOffset = 0L;
    private String archName = null;
    private static final long ARM_ATTR_PREFIX = 65L;
    private static final String VENDOR_AEABI = "aeabi";
    private static final long ATTR_PREFIX_SIZE = 5L;
    private static final int TAG_FILE = 1;
    private static final int TAG_SECTION = 2;
    private static final int TAG_SYMBOL = 3;
    private static final int TAG_CPU_RAW_NAME = 4;
    private static final int TAG_CPU_NAME = 5;
    private static final int TAG_CPU_ARCH = 6;
    private static final int TAG_CPU_ARCH_PROFILE = 7;
    private static final int TAG_ARM_ISA_USE = 8;
    private static final int TAG_THUMB_ISA_USE = 9;
    private static final int TAG_FP_ARCH = 10;
    private static final int TAG_WMMX_ARCH = 11;
    private static final int TAG_ADVANCED_SIMD_ARCH = 12;
    private static final int TAG_PCS_CONFIG = 13;
    private static final int TAG_ABI_PCS_R9_USE = 14;
    private static final int TAG_ABI_PCS_RW_DATA = 15;
    private static final int TAG_ABI_PCS_RO_DATA = 16;
    private static final int TAG_ABI_PCS_GOT_USE = 17;
    private static final int TAG_ABI_PCS_WCHAR_T = 18;
    private static final int TAG_ABI_FP_ROUNDING = 19;
    private static final int TAG_ABI_FP_DENORMAL = 20;
    private static final int TAG_ABI_FP_EXCEPTIONS = 21;
    private static final int TAG_ABI_FP_USER_EXCEPTIONS = 22;
    private static final int TAG_ABI_FP_NUMBER_MODEL = 23;
    private static final int TAG_ABI_ALIGN_NEEDED = 24;
    private static final int TAG_ABI_ALIGN8_PRESERVED = 25;
    private static final int TAG_ABI_ENUM_SIZE = 26;
    private static final int TAG_ABI_HARDFP_USE = 27;
    private static final int TAG_ABI_VFP_ARGS = 28;
    private static final int TAG_ABI_WMMX_ARGS = 29;
    private static final int TAG_ABI_OPTIMIZATION_GOALS = 30;
    private static final int TAG_ABI_FP_OPTIMIZATION_GOALS = 31;
    private static final int TAG_COMPATIBILITY = 32;
    private static final int TAG_CPU_UNALIGNED_ACCESS = 34;
    private static final int TAG_FP_HP_EXTENSION = 36;
    private static final int TAG_ABI_FP_16BIT_FORMAT = 38;
    private static final int TAG_MPEXTENSION_USE = 42;
    private static final int TAG_DIV_USE = 44;
    private static final int TAG_NODEFAULTS = 64;
    private static final int TAG_ALSO_COMPATIBLE_WITH = 65;
    private static final int TAG_CONFORMANCE = 67;
    private static final int TAG_T2EE_USE = 66;
    private static final int TAG_VIRTUALIZATION_USE = 68;
    private static final int TAG_MPEXTENSION_USE_RECODED = 70;
    private static final HashMap<Long, String> archTable = new HashMap();

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void setEndian(long endian) {
        this.endian = endian;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public ElfArmAttrParser(String fileName, long endian, long sectionOffset) {
        this.setFileName(fileName);
        this.setEndian(endian);
        this.setSectionOffset(sectionOffset);
    }

    private boolean checkInit() {
        return 0L != this.sectionOffset;
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return false != this.binaryFileReader.skip(this.sectionOffset);
    }

    private String parseString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            char c = '\u0000';
            while ('\u0000' != (c = (char)this.binaryFileReader.readByte())) {
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    private String parseVendorName() {
        return this.parseString();
    }

    private boolean parseFileAttribute(long size) {
        try {
            while (size > 0L) {
                long tag = Leb128Parser.parseULeb128(this.binaryFileReader);
                if (tag == 4L || tag == 5L || tag == 32L || tag == 65L || tag == 67L) {
                    String str = this.parseString();
                    size -= (long)str.length();
                    continue;
                }
                if (tag >= 7L && tag <= 31L || tag == 34L || tag == 36L || tag == 38L || tag == 42L || tag == 44L || tag == 64L || tag == 66L || tag == 68L || tag == 70L) {
                    Leb128Parser.parseULeb128(this.binaryFileReader);
                    continue;
                }
                if (tag == 6L) {
                    long arch = Leb128Parser.parseULeb128(this.binaryFileReader);
                    this.archName = archTable.get(arch);
                    return true;
                }
                Log.error("Unimplemented tag.", new Object[0]);
                return false;
            }
            return false;
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
    }

    private boolean parseArmAttribute() {
        try {
            long prefix = this.binaryFileReader.readUByte();
            if (65L != prefix) {
                return false;
            }
            long sectionLength = this.binaryFileReader.readUInt();
            String vendorName = this.parseVendorName();
            if (null == vendorName || !vendorName.equals(VENDOR_AEABI)) {
                return false;
            }
            long restLength = sectionLength - (long)vendorName.length();
            while (restLength > 0L) {
                long typeTag = this.binaryFileReader.readUByte();
                long size = this.binaryFileReader.readUInt() - 5L;
                if (1L == typeTag) {
                    return this.parseFileAttribute(size);
                }
                this.binaryFileReader.skip(size);
            }
            return true;
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
    }

    private boolean parse() {
        if (!this.openFile()) {
            this.close();
            return false;
        }
        if (!this.parseArmAttribute()) {
            Log.error("Failed to parse elf header", new Object[0]);
        }
        this.close();
        return true;
    }

    public static String getArch(String fileName, long endian, long sectionOffset) {
        ElfArmAttrParser parser = new ElfArmAttrParser(fileName, endian, sectionOffset);
        if (!parser.parse()) {
            Log.error("Failed to parse the arch.", new Object[0]);
            return null;
        }
        return parser.archName;
    }

    static {
        archTable.put(new Long(1L), "armeabi-v4");
        archTable.put(new Long(2L), "armeabi-v4t");
        archTable.put(new Long(3L), "armeabi-v5t");
        archTable.put(new Long(4L), "armeabi-v5te");
        archTable.put(new Long(5L), "armeabi-v5tej");
        archTable.put(new Long(6L), "armeabi-v6");
        archTable.put(new Long(7L), "armeabi-v6kz");
        archTable.put(new Long(8L), "armeabi-v6t2");
        archTable.put(new Long(9L), "armeabi-v6k");
        archTable.put(new Long(10L), "armeabi-v7a");
        archTable.put(new Long(11L), "armeabi-v6-m");
        archTable.put(new Long(12L), "armeabi-v6s-m");
        archTable.put(new Long(13L), "armeabi-v7e-m");
        archTable.put(new Long(14L), "armeabi-v8a");
    }
}

