/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstruction;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstructionIter;
import com.uqm.crashsight.symtabtool.dwarf.CfaRule;
import com.uqm.crashsight.symtabtool.dwarf.CommonInformationEntry;
import com.uqm.crashsight.symtabtool.dwarf.FrameDescriptionEntry;
import com.uqm.crashsight.symtabtool.dwarf.RegisterAndOffset;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.UninitializedUnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTableRow;

class UnwindTable {
    long codeAlignmentFactor;
    long dataAlignmentFactor;
    long nextStartAddress;
    long lastEndAddress;
    boolean returnedLastRow;
    CallFrameInstructionIter instructions;
    UnwindContext ctx;

    public UnwindTable(long codeAlignmentFactor, long dataAlignmentFactor, long nextStartAddress, long lastEndAddress, boolean returnedLastRow, CallFrameInstructionIter instructions, UnwindContext ctx) {
        this.codeAlignmentFactor = codeAlignmentFactor;
        this.dataAlignmentFactor = dataAlignmentFactor;
        this.nextStartAddress = nextStartAddress;
        this.lastEndAddress = lastEndAddress;
        this.returnedLastRow = returnedLastRow;
        this.instructions = instructions;
        this.ctx = ctx;
    }

    public static UnwindTable _new(UnwindSection section, BaseAddresses bases, UninitializedUnwindContext ctx, FrameDescriptionEntry fde) {
        UnwindContext unwindContext = ctx.initialize(section, bases, fde.cie);
        return UnwindTable.newForFde(section, bases, unwindContext, fde);
    }

    public static UnwindTable newForCie(UnwindSection section, BaseAddresses bases, UnwindContext ctx, CommonInformationEntry cie) {
        assert (ctx.stack().length >= 1);
        return new UnwindTable(cie.codeAlignmentFactor, cie.dataAlignmentFactor, 0L, 0L, false, cie.instructions(section, bases), ctx);
    }

    public static UnwindTable newForFde(UnwindSection section, BaseAddresses bases, UnwindContext ctx, FrameDescriptionEntry fde) {
        assert (ctx.stack().length >= 1);
        return new UnwindTable(fde.cie.codeAlignmentFactor, fde.cie.dataAlignmentFactor, fde.initialAddress, fde.initialAddress + fde.len(), false, fde.instructions(section, bases), ctx);
    }

    public UnwindTableRow nextRow() {
        UnwindTableRow[] rows = this.ctx.stack();
        int size = rows.length;
        if (size < 1) {
            return null;
        }
        this.ctx.setStartAddress(this.nextStartAddress);
        try {
            CallFrameInstruction instruction;
            do {
                if ((instruction = this.instructions.next()) != null) continue;
                if (this.returnedLastRow) {
                    return null;
                }
                UnwindTableRow row = this.ctx.row();
                row.endAddress = this.lastEndAddress;
                this.returnedLastRow = true;
                return row;
            } while (!this.evaluate(instruction));
            return this.ctx.row();
        }
        catch (RuntimeException e) {
            Log.error(e);
            throw e;
        }
    }

    public boolean evaluate(CallFrameInstruction instruction) {
        RegisterAndOffset registerAndOffset;
        CfaRule cfaRule;
        if (instruction.setLoc != null) {
            if (instruction.setLoc.address < this.ctx.startAddress()) {
                throw new RuntimeException("InvalidAddressRange");
            }
            this.ctx.row().endAddress = this.nextStartAddress = instruction.setLoc.address;
            return true;
        }
        if (instruction.advanceLoc != null) {
            long delta = instruction.advanceLoc.delta * this.codeAlignmentFactor;
            this.ctx.row().endAddress = this.nextStartAddress = this.ctx.startAddress() + delta;
            return true;
        }
        if (instruction.defCfa != null) {
            cfaRule = new CfaRule();
            cfaRule.registerAndOffset = new RegisterAndOffset(instruction.defCfa.register, instruction.defCfa.offset);
            this.ctx.setCfa(cfaRule);
        }
        if (instruction.defCfaSf != null) {
            cfaRule = new CfaRule();
            cfaRule.registerAndOffset = new RegisterAndOffset(instruction.defCfaSf.register, instruction.defCfaSf.factoredOffset * this.dataAlignmentFactor);
            this.ctx.setCfa(cfaRule);
        }
        if (instruction.defCfaRegister != null) {
            registerAndOffset = this.ctx.cfa().registerAndOffset;
            if (registerAndOffset != null) {
                registerAndOffset.register = instruction.defCfaRegister.register;
            } else {
                throw new RuntimeException("CfiInstructionInInvalidContext");
            }
        }
        if (instruction.defCfaOffset != null) {
            registerAndOffset = this.ctx.cfa().registerAndOffset;
            if (registerAndOffset != null) {
                registerAndOffset.offset = instruction.defCfaOffset.offset;
            } else {
                throw new RuntimeException("CfiInstructionInInvalidContext");
            }
        }
        if (instruction.defCfaOffsetSf != null) {
            registerAndOffset = this.ctx.cfa().registerAndOffset;
            if (registerAndOffset != null) {
                registerAndOffset.offset = instruction.defCfaOffsetSf.factoredOffset * this.dataAlignmentFactor;
            } else {
                throw new RuntimeException("CfiInstructionInInvalidContext");
            }
        }
        if (instruction.defCfaExpression != null) {
            cfaRule = new CfaRule();
            cfaRule.expression = instruction.defCfaExpression.expression;
            this.ctx.setCfa(cfaRule);
        }
        if (instruction.undefined != null) {
            this.ctx.setRegisterRule(instruction.undefined.register, RegisterRule.undefined());
        }
        if (instruction.sameValue != null) {
            this.ctx.setRegisterRule(instruction.sameValue.register, RegisterRule.sameValue());
        }
        if (instruction.offset != null) {
            this.ctx.setRegisterRule(instruction.offset.register, RegisterRule.offset(instruction.offset.factoredOffset * this.dataAlignmentFactor));
        }
        if (instruction.offsetExtendedSf != null) {
            this.ctx.setRegisterRule(instruction.offsetExtendedSf.register, RegisterRule.offset(instruction.offsetExtendedSf.factoredOffset * this.dataAlignmentFactor));
        }
        if (instruction.valueOffset != null) {
            this.ctx.setRegisterRule(instruction.valueOffset.register, RegisterRule.valueOffset(instruction.valueOffset.factoredOffset * this.dataAlignmentFactor));
        }
        if (instruction.valueOffsetSf != null) {
            this.ctx.setRegisterRule(instruction.valueOffsetSf.register, RegisterRule.valueOffset(instruction.valueOffsetSf.factoredOffset * this.dataAlignmentFactor));
        }
        if (instruction.cfaRegister != null) {
            this.ctx.setRegisterRule(instruction.cfaRegister.destRegister, RegisterRule.register(instruction.cfaRegister.srcRegister));
        }
        if (instruction.expression != null) {
            this.ctx.setRegisterRule(instruction.expression.register, RegisterRule.expression(instruction.expression.expression));
        }
        if (instruction.valExpression != null) {
            this.ctx.setRegisterRule(instruction.valExpression.register, RegisterRule.valExpression(instruction.valExpression.expression));
        }
        if (instruction.restore != null) {
            if (instruction.restore.register.val == 77 && this.nextStartAddress == 371084L) {
                boolean cfaRule2 = true;
            }
            RegisterRule initialRule = this.ctx.getInitialRule(instruction.restore.register);
            this.ctx.setRegisterRule(instruction.restore.register, initialRule);
        }
        if (instruction.rememberState != null) {
            this.ctx.pushRow();
        }
        if (instruction.restoreState != null) {
            assert (this.ctx.stack().length > 0);
            if (this.ctx.stack().length == 1) {
                throw new RuntimeException("PopWithEmptyStack");
            }
            long startAddress = this.ctx.startAddress();
            this.ctx.popRow();
            this.ctx.setStartAddress(startAddress);
        }
        if (instruction.argsSize != null) {
            this.ctx.row().savedArgsSize = instruction.argsSize.size;
        }
        if (instruction.nop != null) {
            Log.debug("nop", new Object[0]);
        }
        return false;
    }
}

