/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.CfaRule;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRuleMap;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTableRow;

class UnwindContext {
    public static final int MAX_UNWIND_STACK_DEPTH = 4;
    UnwindTableRow[] stackStorage = new UnwindTableRow[4];
    long stackLen = 0L;
    RegisterRuleMap initialRules = RegisterRuleMap._default();
    boolean isInitialized = false;

    public UnwindContext() {
        this.reset();
    }

    public void reset() {
        this.stackLen = 0L;
        boolean res = this.tryPush(UnwindTableRow._default());
        assert (res);
        this.initialRules.clear();
        this.isInitialized = false;
        this.assertFullyUninitialized();
    }

    public boolean tryPush(UnwindTableRow row) {
        if (this.stackLen < 4L) {
            this.stackStorage[(int)this.stackLen] = row;
            ++this.stackLen;
            return true;
        }
        return false;
    }

    public void assertFullyUninitialized() {
        assert (!this.isInitialized);
        assert (this.initialRules.rules().length == 0);
        assert (this.stack().length == 1);
        assert (this.stack()[0].isDefault());
    }

    UnwindTableRow[] stack() {
        int len = (int)this.stackLen;
        UnwindTableRow[] stack = new UnwindTableRow[len];
        System.arraycopy(this.stackStorage, 0, stack, 0, len);
        return stack;
    }

    public UnwindTableRow row() {
        return this.stack()[(int)(this.stackLen - 1L)];
    }

    public void setStartAddress(long startAddress) {
        UnwindTableRow row = this.row();
        row.startAddress = startAddress;
    }

    public long startAddress() {
        return this.row().startAddress;
    }

    public void setCfa(CfaRule cfaRule) {
        this.row().cfa = cfaRule;
    }

    public CfaRule cfa() {
        return this.row().cfa;
    }

    public void setRegisterRule(Register register, RegisterRule registerRule) {
        this.row().registers.set(register, registerRule);
    }

    public RegisterRule getInitialRule(Register register) {
        if (!this.isInitialized) {
            return null;
        }
        return this.initialRules.get(register);
    }

    public void pushRow() {
        UnwindTableRow newRow = this.row()._clone();
        if (!this.tryPush(newRow)) {
            throw new RuntimeException("CfiStackFull");
        }
    }

    public void popRow() {
        assert (this.stack().length > 1);
        --this.stackLen;
    }

    public void saveInitialRules() {
        assert (!this.isInitialized);
        RegisterRuleMap registers = this.row().registers;
        this.initialRules = registers._clone();
        this.isInitialized = true;
    }
}

