/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRulePair;

class RegisterRuleMap {
    public static final int MAX_RULES = 192;
    RegisterRulePair[] rulesStorage = new RegisterRulePair[192];
    long rulesLen;

    RegisterRuleMap() {
    }

    public static RegisterRuleMap _default() {
        RegisterRuleMap map = new RegisterRuleMap();
        for (int i = 0; i < map.rulesStorage.length; ++i) {
            map.rulesStorage[i] = new RegisterRulePair();
        }
        map.rulesLen = 0L;
        return map;
    }

    public RegisterRuleMap _clone() {
        RegisterRuleMap newRuleMap = new RegisterRuleMap();
        for (int i = 0; i < this.rulesStorage.length; ++i) {
            if (this.rulesStorage[i] == null) continue;
            newRuleMap.rulesStorage[i] = this.rulesStorage[i]._clone();
        }
        newRuleMap.rulesLen = this.rulesLen;
        return newRuleMap;
    }

    public void clear() {
        this.rulesLen = 0L;
    }

    public RegisterRulePair[] rules() {
        RegisterRulePair[] rules = new RegisterRulePair[(int)this.rulesLen];
        System.arraycopy(this.rulesStorage, 0, rules, 0, rules.length);
        return rules;
    }

    public Pair<RegisterRulePair[], RegisterRulePair[]> splitAt(int idx) {
        RegisterRulePair[] rules = this.rules();
        RegisterRulePair[] first = new RegisterRulePair[idx];
        System.arraycopy(rules, 0, first, 0, first.length);
        RegisterRulePair[] second = new RegisterRulePair[rules.length - first.length];
        System.arraycopy(rules, first.length, second, 0, second.length);
        return new Pair<RegisterRulePair[], RegisterRulePair[]>(first, second);
    }

    public boolean isDefault() {
        return this.rulesLen == 0L;
    }

    public int find(Register register) {
        RegisterRulePair[] rules = this.rules();
        for (int i = 0; i < rules.length; ++i) {
            if (this.rulesStorage[i].register.val != register.val) continue;
            return i;
        }
        return -1;
    }

    public void push(Register register, RegisterRule rule) {
        if (this.rulesLen >= 192L) {
            throw new RuntimeException("TooManyRegisterRules");
        }
        this.rulesStorage[(int)this.rulesLen] = new RegisterRulePair(register, rule);
        ++this.rulesLen;
    }

    public void set(Register register, RegisterRule rule) {
        if (!rule.isDefined()) {
            int idx = this.find(register);
            if (idx != -1) {
                Pair<RegisterRulePair[], RegisterRulePair[]> pair = this.splitAt(idx + 1);
                RegisterRulePair[] a = pair.getKey();
                RegisterRulePair[] b = pair.getValue();
                if (b.length > 0) {
                    RegisterRulePair tmp = a[a.length - 1];
                    a[a.length - 1] = b[b.length - 1];
                    b[b.length - 1] = tmp;
                }
                --this.rulesLen;
            }
            return;
        }
        for (RegisterRulePair pair : this.rules()) {
            assert (pair.registerRule.isDefined());
            if (pair.register.val != register.val) continue;
            pair.registerRule = rule;
            return;
        }
        this.push(register, rule);
    }

    public RegisterRule get(Register register) {
        int idx = this.find(register);
        if (idx >= 0) {
            RegisterRulePair pair = this.rulesStorage[idx];
            return pair.registerRule;
        }
        return RegisterRule.undefined();
    }
}

