/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.Format;

interface Reader {
    public Endianity endian();

    public Long len();

    public void empty();

    public Long offsetFrom(Reader var1);

    public void readSlice(byte[] var1);

    public short readU8();

    public int readU16();

    public long readU32();

    public long readU64();

    public short readI16();

    public int readI32();

    public long readI64();

    public long readULeb128();

    public long readSLeb128();

    default public long readAddress(short addressSize) {
        switch (addressSize) {
            case 1: {
                return this.readU8();
            }
            case 2: {
                return this.readU16();
            }
            case 4: {
                return this.readU32();
            }
            case 8: {
                return this.readU64();
            }
        }
        throw new RuntimeException("UnsupportedAddressSize");
    }

    public Long find(byte var1);

    public void skip(Long var1);

    default public Reader readNullTerminatedSlice() {
        Long idx = this.find((byte)0);
        Reader val = this.split(idx);
        this.skip(1L);
        return val;
    }

    default public Pair<Long, Format> readInitialLength() {
        long MAX_DWARF_32_UNIT_LENGTH = 0xFFFFFFF0L;
        long DWARF_64_INITIAL_UNIT_LENGTH = 0xFFFFFFFFL;
        long val = this.readU32();
        if (val < MAX_DWARF_32_UNIT_LENGTH) {
            return new Pair<Long, Format>(val, Format.Dwarf32);
        }
        if (val == DWARF_64_INITIAL_UNIT_LENGTH) {
            val = this.readU64();
            return new Pair<Long, Format>(val, Format.Dwarf64);
        }
        Log.error("UnknownReservedLength", new Object[0]);
        return null;
    }

    public Reader split(Long var1);

    default public boolean isEmpty() {
        return this.len() == 0L;
    }

    public Long offsetId();

    public Reader _clone();
}

