/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ParseBuffer {
    private static final long FIX_LEB128 = 127L;
    private ByteBuffer buffer;
    private final ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
    private final byte[] tmpBytes = new byte[8];
    private long sectionOffset = 0L;
    private long offset = 0L;
    private long initialSize = 0L;

    public static ParseBuffer empty() {
        ByteBuffer buffer = ByteBuffer.allocate(0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(buffer);
    }

    public ParseBuffer(byte[] array, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(byteOrder);
        this.sectionOffset = 0L;
        this.offset = 0L;
        this.initialSize = array.length;
        this.buffer = buffer;
    }

    public ParseBuffer(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        this.buffer = buffer;
    }

    public ParseBuffer(ByteBuffer buffer, long sectionOffset, long initialSize) {
        this.sectionOffset = sectionOffset;
        this.offset = 0L;
        this.initialSize = initialSize;
        this.buffer = buffer;
    }

    public long getPtr() {
        return this.sectionOffset + this.offset;
    }

    public ParseBuffer copy() {
        return new ParseBuffer(this.buffer, this.sectionOffset + this.offset, this.len());
    }

    public ParseBuffer[] take(long size) {
        ParseBuffer buffer1 = new ParseBuffer(this.buffer, this.sectionOffset + this.offset, size);
        ParseBuffer buffer2 = new ParseBuffer(this.buffer, this.sectionOffset + this.offset + size, this.len() - size);
        ParseBuffer[] parseBuffers = new ParseBuffer[]{buffer1, buffer2};
        return parseBuffers;
    }

    public long pos() {
        return this.offset;
    }

    public void pos(long pos) {
        this.buffer.position((int)pos);
    }

    public long len() {
        return this.initialSize - this.offset;
    }

    public boolean isEmpty() {
        return this.len() == 0L;
    }

    public void align(long alignment) {
        long diff = this.pos() % alignment;
        if (diff > 0L) {
            if (this.len() < alignment - diff) {
                Log.error("UnexpectedEof", new Object[0]);
            }
            this.pos(this.pos() + (alignment - diff));
        }
    }

    public byte readI8() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        ++this.offset;
        return this.buffer.get();
    }

    public short readI16() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 2L;
        return this.buffer.getShort();
    }

    public int readI32() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 4L;
        return this.buffer.getInt();
    }

    public long readI64() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 8L;
        return this.buffer.getLong();
    }

    public short readU8() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        ++this.offset;
        byte b = this.buffer.get();
        this.tmpBuffer.clear();
        this.tmpBuffer.put((byte)0);
        this.tmpBuffer.put(b);
        this.tmpBuffer.flip();
        return this.tmpBuffer.getShort();
    }

    public short getU8() {
        short v = this.readU8();
        --this.offset;
        return v;
    }

    public int readU16() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 2L;
        this.buffer.get(this.tmpBytes, 0, 2);
        this.tmpBuffer.clear();
        this.tmpBuffer.putShort((short)0);
        for (int i = 1; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getInt();
    }

    public int getU16() {
        int v = this.readU16();
        this.offset -= 2L;
        return v;
    }

    public long readU32() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 4L;
        this.buffer.get(this.tmpBytes, 0, 4);
        this.tmpBuffer.clear();
        this.tmpBuffer.putInt(0);
        for (int i = 3; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getLong();
    }

    public long getU32() {
        long v = this.readU32();
        this.offset -= 4L;
        return v;
    }

    public long parseULeb128() {
        byte b;
        this.buffer.position((int)(this.sectionOffset + this.offset));
        int curPos = this.buffer.position();
        long result = 0L;
        long shift = 0L;
        do {
            b = this.buffer.get();
            result |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
        } while ((b & 0x80) != 0);
        this.offset += (long)(this.buffer.position() - curPos);
        return result;
    }

    public long parseSLeb128() {
        byte b;
        this.buffer.position((int)(this.sectionOffset + this.offset));
        int curPos = this.buffer.position();
        long result = 0L;
        long shift = 0L;
        boolean negative = false;
        do {
            b = this.buffer.get();
            result |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
            boolean bl = negative = (b & 0x40) != 0;
        } while ((b & 0x80) != 0);
        if (negative) {
            result |= -(1L << (int)shift);
        }
        this.offset += (long)(this.buffer.position() - curPos);
        return result;
    }

    public int find(byte needle) {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        int i = 0;
        while ((long)i < this.initialSize && this.buffer.get() != needle) {
            ++i;
        }
        return (long)i == this.initialSize ? -1 : i;
    }

    public String parseAddress(long addrBits) {
        long address = 0L;
        if (32L == addrBits) {
            address = this.readU32();
        } else if (64L == addrBits) {
            address = this.readI64();
        }
        return Long.toHexString(address);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    public byte[] getTmpBytes() {
        return this.tmpBytes;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setInitialSize(long initialSize) {
        this.initialSize = initialSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseBuffer)) {
            return false;
        }
        ParseBuffer other = (ParseBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != other.getSectionOffset()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getInitialSize() != other.getInitialSize()) {
            return false;
        }
        ByteBuffer this$buffer = this.getBuffer();
        ByteBuffer other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer)) {
            return false;
        }
        ByteBuffer this$tmpBuffer = this.getTmpBuffer();
        ByteBuffer other$tmpBuffer = other.getTmpBuffer();
        if (this$tmpBuffer == null ? other$tmpBuffer != null : !((Object)this$tmpBuffer).equals(other$tmpBuffer)) {
            return false;
        }
        return Arrays.equals(this.getTmpBytes(), other.getTmpBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParseBuffer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sectionOffset = this.getSectionOffset();
        result = result * 59 + (int)($sectionOffset >>> 32 ^ $sectionOffset);
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $initialSize = this.getInitialSize();
        result = result * 59 + (int)($initialSize >>> 32 ^ $initialSize);
        ByteBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        ByteBuffer $tmpBuffer = this.getTmpBuffer();
        result = result * 59 + ($tmpBuffer == null ? 43 : ((Object)$tmpBuffer).hashCode());
        result = result * 59 + Arrays.hashCode(this.getTmpBytes());
        return result;
    }

    public String toString() {
        return "ParseBuffer(buffer=" + this.getBuffer() + ", tmpBuffer=" + this.getTmpBuffer() + ", tmpBytes=" + Arrays.toString(this.getTmpBytes()) + ", sectionOffset=" + this.getSectionOffset() + ", offset=" + this.getOffset() + ", initialSize=" + this.getInitialSize() + ")";
    }
}

