/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Leb128Parser {
    private static final long FIX_LEB128 = 127L;

    public static long parseULeb128(BinaryFileReader bfr) throws IOException {
        byte b;
        long result = 0L;
        long shift = 0L;
        do {
            b = bfr.readByte();
            result |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
        } while ((b & 0x80) != 0);
        return result;
    }

    public static long parseSLeb128(BinaryFileReader bfr) throws IOException {
        byte b;
        long result = 0L;
        long shift = 0L;
        boolean negative = false;
        do {
            b = bfr.readByte();
            result |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
            boolean bl = negative = (b & 0x40) != 0;
        } while ((b & 0x80) != 0);
        if (negative) {
            result |= (long)(-(1 << (int)shift));
        }
        return result;
    }

    public static int writeUnsignedLeb128(ByteBuffer out, long value) {
        int num = 0;
        for (long remaining = value >>> 7; remaining != 0L; remaining >>>= 7) {
            out.put((byte)(value & 0x7FL | 0x80L));
            ++num;
            value = remaining;
        }
        out.put((byte)(value & 0x7FL));
        return ++num;
    }

    public static void writeSignedLeb128(ByteBuffer out, int value) {
        int end;
        int remaining = value >> 7;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            out.put((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }
}

